/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.IntegrationInitEvent;
import com.mcmoddev.lib.integration.IntegrationPostInitEvent;
import com.mcmoddev.lib.integration.IntegrationPreInitEvent;
import com.mcmoddev.lib.integration.MMDPlugin;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;

public enum IntegrationManager {
    INSTANCE;

    private final List<IIntegration> integrations = Lists.newArrayList();
    private final Map<String, Map<String, VersionMatch>> plugins = Maps.newConcurrentMap();

    private String getAnnotationItem(@Nonnull String item, @Nonnull ASMDataTable.ASMData asmData) {
        if (asmData.getAnnotationInfo().get(item) != null) {
            return asmData.getAnnotationInfo().get(item).toString();
        }
        return "";
    }

    public void doSetupTasks(@Nonnull FMLConstructionEvent event) throws InvalidVersionSpecificationException {
        for (ASMDataTable.ASMData asmDataItem : event.getASMHarvestedData().getAll(MMDPlugin.class.getCanonicalName())) {
            Map<String, VersionMatch> rv;
            String addonId = this.getAnnotationItem("addonId", asmDataItem);
            String modId = this.getAnnotationItem("pluginId", asmDataItem);
            String versions = this.getAnnotationItem("versions", asmDataItem);
            if (!versions.equals("")) {
                MMDLib.logger.debug("Trying to load integration for {} ({}) - versions {}", (Object)addonId, (Object)modId, (Object)versions);
                this.plugins.computeIfAbsent(addonId, val -> Maps.newConcurrentMap());
                rv = this.plugins.get(addonId);
                for (String entry : versions.split(";")) {
                    final String[] bits = entry.split("@");
                    String targetModId = bits[0];
                    if (bits[1].matches("[\\[\\(]?[\\w\\d\\.\\+,]+[\\]\\)]?")) {
                        rv.put(targetModId, new VersionMatch(){
                            private final VersionRange myRange;
                            {
                                this.myRange = VersionRange.createFromVersionSpec((String)bits[1]);
                            }

                            @Override
                            public boolean matches(String otherVersion) {
                                return this.myRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(otherVersion));
                            }

                            @Override
                            public String asString() {
                                return this.myRange.toStringFriendly();
                            }
                        });
                    } else {
                        rv.put(targetModId, match -> true);
                    }
                    this.plugins.put(addonId, rv);
                }
                continue;
            }
            this.plugins.computeIfAbsent(addonId, val -> Maps.newConcurrentMap());
            rv = this.plugins.get(addonId);
            rv.put(modId, match -> true);
            this.plugins.put(addonId, rv);
        }
    }

    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData asmDataItem : event.getAsmData().getAll(MMDPlugin.class.getCanonicalName())) {
            String addonId = this.getAnnotationItem("addonId", asmDataItem);
            String pluginId = this.getAnnotationItem("pluginId", asmDataItem);
            String clazz = asmDataItem.getClassName();
            if (!Loader.isModLoaded((String)pluginId)) continue;
            String pluginVersion = FMLCommonHandler.instance().findContainerFor((Object)pluginId).getVersion();
            VersionMatch matcher = this.plugins.get(addonId).getOrDefault(pluginId, match -> true);
            if (!matcher.matches(pluginVersion)) {
                MMDLib.logger.debug("Version {} of mod {} is not valid for this mods ({}) integration with it - {} required", (Object)pluginVersion, (Object)pluginId, (Object)addonId, (Object)matcher.asString());
                continue;
            }
            try {
                IIntegration integration = Class.forName(clazz).asSubclass(IIntegration.class).newInstance();
                this.integrations.add(integration);
                integration.init();
                MMDLib.logger.debug("Loaded " + pluginId + " for " + addonId);
            }
            catch (Exception ex) {
                MMDLib.logger.error("Couldn't load " + pluginId + " for " + addonId, (Throwable)ex);
            }
        }
    }

    public void preInitPhase() {
        MinecraftForge.EVENT_BUS.post((Event)new IntegrationPreInitEvent());
    }

    public void initPhase() {
        MinecraftForge.EVENT_BUS.post((Event)new IntegrationInitEvent());
    }

    public void postInitPhase() {
        MinecraftForge.EVENT_BUS.post((Event)new IntegrationPostInitEvent());
    }

    private static interface VersionMatch {
        public boolean matches(String var1);

        default public String asString() {
            return "any";
        }
    }
}

