/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.ItemGroups;
import com.mcmoddev.lib.init.MMDCreativeTab;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.GenericMMDItem;
import com.mcmoddev.lib.item.ItemMMDArmor;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.util.Config;
import com.mcmoddev.lib.util.Oredicts;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public abstract class Items {
    private static final BiMap<String, Item> itemRegistry = HashBiMap.create((int)34);
    private static final Map<MMDMaterial, List<Item>> itemsByMaterial = new HashMap<MMDMaterial, List<Item>>();
    private static final Map<String, Class<? extends Item>> nameToClass = new HashMap<String, Class<? extends Item>>();
    private static final Map<String, String> nameToOredict = new HashMap<String, String>();
    private static final Map<String, Boolean> nameToEnabled = new HashMap<String, Boolean>();
    private static final Map<Class<?>, Integer> classSortingValues = new HashMap();
    private static final Map<MMDMaterial, Integer> materialSortingValues = new HashMap<MMDMaterial, Integer>();
    protected static final int BLOCK_BURN_TIME = 16000;
    protected static final int INGOT_BURN_TIME = 1600;
    protected static final int NUGGET_BURN_TIME = 200;
    private static int ss = 0;

    protected Items() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    protected static int getMaxSortingValue() {
        return ss;
    }

    protected static void addClassSorting(Class<?> clazz) {
        classSortingValues.put(clazz, ++ss * 10000);
    }

    protected static void addClassSorting(Class<?> clazz, Class<?> otherClazz) {
        classSortingValues.put(clazz, classSortingValues.get(otherClazz));
    }

    public static void dumpNameToEnabled() {
        MMDLib.logger.debug("Dumping nameToEnabled ({} entries)", (Object)nameToEnabled.entrySet().size());
        nameToEnabled.entrySet().stream().forEach(ent -> MMDLib.logger.debug("name {} is {}", ent.getKey(), (Object)((Boolean)ent.getValue() != false ? "enabled" : "disabled")));
    }

    public static void init() {
        try {
            Items.expandCombatArrays(ItemAxe.class);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            MMDLib.logger.error("Error modifying item classes", (Throwable)ex);
        }
    }

    public static void addToMetList() {
        ArrayList<MMDMaterial> metlist = new ArrayList<MMDMaterial>(Materials.getAllMaterials().size());
        metlist.addAll(Materials.getAllMaterials());
        metlist.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        for (int i = 0; i < metlist.size(); ++i) {
            materialSortingValues.put((MMDMaterial)((Object)metlist.get(i)), i * 100);
        }
    }

    @Nullable
    protected static Item create(@Nonnull Names name, @Nonnull String materialName) {
        return Items.create(name, Materials.getMaterialByName(materialName));
    }

    @Nullable
    protected static Item create(@Nonnull Names name, @Nonnull MMDMaterial material) {
        MMDCreativeTab tab = name.equals((Object)Names.DOOR) || name.equals((Object)Names.SLAB) ? ItemGroups.getTab("blocks") : (name.equals((Object)Names.SWORD) || name.equals((Object)Names.BOW) || name.equals((Object)Names.CROSSBOW) || name.equals((Object)Names.BOLT) || name.equals((Object)Names.ARROW) || name.equals((Object)Names.SHIELD) || name.equals((Object)Names.HELMET) || name.equals((Object)Names.CHESTPLATE) || name.equals((Object)Names.LEGGINGS) || name.equals((Object)Names.BOOTS) || name.equals((Object)Names.HORSE_ARMOR) ? ItemGroups.getTab("combat") : (name.equals((Object)Names.SHEARS) || name.equals((Object)Names.FISHING_ROD) || name.equals((Object)Names.HOE) || name.equals((Object)Names.AXE) || name.equals((Object)Names.SHOVEL) || name.equals((Object)Names.PICKAXE) || name.equals((Object)Names.CRACKHAMMER) ? ItemGroups.getTab("tools") : ItemGroups.getTab("items")));
        return Items.create(name, material, (CreativeTabs)tab);
    }

    @Nullable
    protected static Item create(@Nonnull Names name, @Nonnull String materialName, CreativeTabs tab) {
        return Items.create(name, Materials.getMaterialByName(materialName), tab);
    }

    @Nullable
    protected static Item create(@Nonnull Names name, @Nonnull MMDMaterial material, CreativeTabs tab) {
        if (Items.sanityCheck(name, material)) {
            return null;
        }
        if (material.hasItem(name)) {
            return material.getItem(name);
        }
        if (Items.isArmor(name)) {
            return Items.createArmorItem(name, material, tab);
        }
        Item item = Items.createItem(material, name.toString(), Items.getClassFromName(name), Items.isNameEnabled(name), tab);
        Items.setupOredict(item, Items.getOredictFromName(name), name, material);
        return item;
    }

    private static boolean sanityCheck(Names name, MMDMaterial material) {
        return material.isEmpty() || name == null || Items.isWrongThingToMake(name, material);
    }

    private static void setupOredict(@Nullable Item item, @Nullable String oredict, Names name, MMDMaterial material) {
        if (item != null) {
            if (oredict != null) {
                Oredicts.registerOre(oredict + material.getCapitalizedName(), item);
                if (name.equals((Object)Names.ROD)) {
                    Oredicts.registerOre("stick" + material.getCapitalizedName(), item);
                    Oredicts.registerOre("rod", item);
                } else if (name.equals((Object)Names.GEAR)) {
                    Oredicts.registerOre("gear", item);
                }
            }
            if (name.equals((Object)Names.DOOR)) {
                Oredicts.registerOre("door", item);
            }
        }
    }

    private static boolean isWrongThingToMake(Names name, MMDMaterial material) {
        return (name.equals((Object)Names.BLEND) || name.equals((Object)Names.SMALLBLEND)) && !material.hasBlend() || name.equals((Object)Names.ANVIL) && !material.hasBlock(Names.ANVIL) || name.equals((Object)Names.DOOR) && !material.hasBlock(Names.DOOR) || name.equals((Object)Names.SLAB) && !material.hasBlock(Names.SLAB) && !material.hasBlock(Names.DOUBLE_SLAB);
    }

    private static boolean isArmor(Names name) {
        return name.equals((Object)Names.HELMET) || name.equals((Object)Names.CHESTPLATE) || name.equals((Object)Names.LEGGINGS) || name.equals((Object)Names.BOOTS);
    }

    @Nullable
    protected static Item addItem(@Nonnull Item item, @Nonnull Names name, CreativeTabs tab) {
        return Items.addItem(item, name.toString(), Materials.DEFAULT, tab);
    }

    @Nullable
    protected static Item addItem(@Nonnull Item item, @Nonnull String name, CreativeTabs tab) {
        return Items.addItem(item, name, Materials.DEFAULT, tab);
    }

    @Nullable
    protected static Item addItem(@Nonnull Item item, @Nonnull String name, MMDMaterial material, @Nullable CreativeTabs tab) {
        String fullName;
        if (!material.isEmpty() && !material.isDefault()) {
            if (material.hasItem(name)) {
                return material.getItem(name);
            }
            fullName = material.getName() + "_" + name;
        } else {
            fullName = name;
        }
        item.setRegistryName(new ResourceLocation(Loader.instance().activeModContainer().getModId(), fullName));
        item.func_77655_b(item.getRegistryName().func_110624_b() + "." + fullName);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        if (!material.isEmpty()) {
            itemsByMaterial.computeIfAbsent(material, g -> new ArrayList());
            itemsByMaterial.get((Object)material).add(item);
        }
        itemRegistry.put((Object)fullName, (Object)item);
        return item;
    }

    @Nullable
    private static Item createItem(@Nonnull MMDMaterial material, @Nonnull String name, @Nonnull Class<? extends Item> clazz, @Nonnull boolean enabled, CreativeTabs tab) {
        if (material.hasItem(name)) {
            return material.getItem(name);
        }
        if (enabled) {
            Constructor<? extends Item> ctor = null;
            Item inst = null;
            try {
                ctor = clazz.getConstructor(((Object)((Object)material)).getClass());
            }
            catch (NoSuchMethodException | SecurityException ex) {
                MMDLib.logger.error("Class for Item named %s does not have the correct constructor", (Object)name, (Object)ex);
                return null;
            }
            try {
                inst = ctor.newInstance(new Object[]{material});
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                MMDLib.logger.error("Unable to create new instance of Item class for item name %s of material %s", (Object)name, (Object)material.getCapitalizedName(), (Object)ex);
                return null;
            }
            catch (Exception ex) {
                MMDLib.logger.error("Unable to create Item named %s for material %s", (Object)name, (Object)material.getCapitalizedName(), (Object)ex);
                return null;
            }
            if (inst != null) {
                Items.addItem(inst, name, material, tab);
                material.addNewItem(name, inst);
                return inst;
            }
        }
        return null;
    }

    @Nullable
    private static Item createArmorItem(@Nonnull Names name, @Nonnull MMDMaterial material, CreativeTabs tab) {
        if (!Items.isNameEnabled(name)) {
            return null;
        }
        if (material.hasItem(name)) {
            return material.getItem(name);
        }
        ItemMMDArmor item = ItemMMDArmor.createArmor(material, name);
        if (item == null) {
            return null;
        }
        Item finalItem = Items.addItem((Item)item, name.toString(), material, tab);
        material.addNewItem(name, finalItem);
        return finalItem;
    }

    @Nullable
    protected static Item createMekCrystal(@Nonnull MMDMaterial material, CreativeTabs tab) {
        if (material.hasItem(Names.CRYSTAL)) {
            return material.getItem(Names.CRYSTAL);
        }
        Item item = Items.createItem(material, Names.CRYSTAL.toString(), GenericMMDItem.class, Config.Options.isModEnabled("mekanism") && material.getType() != MMDMaterialType.MaterialType.CRYSTAL, tab);
        if (item != null) {
            Oredicts.registerOre("crystal" + material.getCapitalizedName(), item);
            return item;
        }
        return null;
    }

    private static void expandCombatArrays(@Nonnull Class<?> itemClass) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        int expandedSize = 256;
        for (Field field : fields = itemClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().isArray() || !field.getType().getComponentType().equals(Float.TYPE)) continue;
            MMDLib.logger.info("{}: Expanding array variable {}.{} to size {}", (Object)Thread.currentThread().getStackTrace()[0].toString(), (Object)itemClass.getSimpleName(), (Object)field.getName(), (Object)256);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            float[] newArray = new float[256];
            Arrays.fill(newArray, 0.0f);
            System.arraycopy(field.get(null), 0, newArray, 0, Array.getLength(field.get(null)));
            field.set(null, newArray);
        }
    }

    public static int getSortingValue(@Nonnull ItemStack itemStack) {
        int classVal = 990000;
        int materialVal = 9900;
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IMMDObject) {
            Block block = ((ItemBlock)item).func_179223_d();
            classVal = classSortingValues.computeIfAbsent(block.getClass(), clazz -> 990000);
            materialVal = materialSortingValues.computeIfAbsent(((IMMDObject)block).getMMDMaterial(), material -> 9900);
        } else if (item instanceof IMMDObject) {
            classVal = classSortingValues.computeIfAbsent(item.getClass(), clazz -> 990000);
            materialVal = materialSortingValues.computeIfAbsent(((IMMDObject)item).getMMDMaterial(), material -> 9900);
        }
        return classVal + materialVal + itemStack.func_77960_j() % 100;
    }

    protected static Class<? extends Item> getClassFromName(@Nonnull Names name) {
        if (nameToClass.containsKey(name.toString())) {
            return nameToClass.get(name.toString());
        }
        return Item.class;
    }

    @Nullable
    protected static String getOredictFromName(@Nonnull Names name) {
        if (nameToOredict.containsKey(name.toString())) {
            return nameToOredict.get(name.toString());
        }
        return null;
    }

    protected static boolean isNameEnabled(@Nonnull Names name) {
        if (nameToEnabled.containsKey(name.toString())) {
            return nameToEnabled.get(name.toString());
        }
        return false;
    }

    protected static void addItemType(@Nonnull Names name, @Nonnull Class<? extends Item> clazz, @Nonnull Boolean enabled) {
        Items.addItemType(name, clazz, enabled, null);
    }

    protected static void addItemType(@Nonnull Names name, @Nonnull Class<? extends Item> clazz, @Nonnull Boolean enabled, @Nullable String oredict) {
        Items.addItemType(name.toString(), clazz, enabled, oredict);
    }

    protected static void addItemType(@Nonnull String name, @Nonnull Class<? extends Item> clazz, @Nonnull Boolean enabled) {
        MMDLib.logger.debug("Register Item Type: {}/{}/{}/null", (Object)name, (Object)clazz.getName(), (Object)enabled);
        Items.addItemType(name, clazz, enabled, null);
    }

    protected static void addItemType(@Nonnull String name, @Nonnull Class<? extends Item> clazz, @Nonnull Boolean enabled, @Nullable String oredict) {
        MMDLib.logger.debug("Register Item Type: {}/{}/{}/{}", (Object)name, (Object)clazz.getName(), (Object)enabled, (Object)(oredict == null ? "null" : ("".contentEquals(oredict) ? "EMPTY" : oredict)));
        if (!nameToClass.containsKey(name)) {
            nameToClass.put(name, clazz);
        }
        if (!nameToEnabled.containsKey(name)) {
            MMDLib.logger.debug("!nameToEnabled({}) ({})", (Object)name, (Object)enabled);
            nameToEnabled.put(name, enabled);
        } else {
            MMDLib.logger.debug("nameToEnabled({}) ({} -- {})", (Object)name, (Object)enabled, (Object)nameToEnabled.get(name));
            if (nameToEnabled.get(name) != enabled) {
                nameToEnabled.put(name, enabled);
            }
        }
        if (oredict != null && !"".equals(oredict) && !nameToOredict.containsKey(name)) {
            nameToOredict.put(name, oredict);
        }
    }

    @Nullable
    public static Item getItemByName(@Nonnull String name) {
        return (Item)itemRegistry.get((Object)name);
    }

    @Nullable
    public static String getNameOfItem(@Nonnull Item item) {
        return (String)itemRegistry.inverse().get((Object)item);
    }

    public static Map<String, Item> getItemRegistry() {
        return Collections.unmodifiableMap(itemRegistry);
    }

    public static Map<MMDMaterial, List<Item>> getItemsByMaterial() {
        return Collections.unmodifiableMap(itemsByMaterial);
    }
}

