/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.feature.FeatureDirtyLevel;
import com.mcmoddev.lib.feature.IFeature;
import com.mcmoddev.lib.feature.IFeatureHolder;
import com.mcmoddev.lib.feature.IServerFeature;
import com.mcmoddev.lib.feature.ISidedFeature;
import com.mcmoddev.lib.feature.SidedFeatureWrapper;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BaseFeature
implements IFeature,
IServerFeature {
    private final String key;
    private boolean dirty = false;
    private IFeatureHolder holder = null;

    protected BaseFeature(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty() {
        this.setDirty(FeatureDirtyLevel.MIN_LEVEL);
    }

    protected void setDirty(FeatureDirtyLevel level) {
        this.dirty = true;
        if (this.holder != null) {
            this.holder.featureChanged(this, level);
        }
    }

    public final NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    protected abstract void writeToNBT(NBTTagCompound var1);

    @Override
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        NBTTagCompound nbt = this.serializeNBT();
        if (resetDirtyFlag) {
            this.dirty = false;
        }
        return nbt;
    }

    @Override
    @Nullable
    public NBTTagCompound getTickUpdateTag(boolean resetDirtyFlag) {
        return null;
    }

    @Override
    @Nullable
    public NBTTagCompound getLoadUpdateTag() {
        return this.serializeNBT();
    }

    @Override
    @Nullable
    public IFeatureHolder getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(@Nullable IFeatureHolder holder) {
        this.holder = holder;
    }

    public ISidedFeature getSidedWrapper(Color color, int priorityIndex) {
        return this.getSidedWrapper(color.getRGB(), priorityIndex);
    }

    public ISidedFeature getSidedWrapper(MapColor color, int priorityIndex) {
        return this.getSidedWrapper(color.field_76291_p, priorityIndex);
    }

    public ISidedFeature getSidedWrapper(int color, int priorityIndex) {
        return new SidedFeatureWrapper(this, color, priorityIndex);
    }
}

