/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy;

import com.mcmoddev.lib.energy.BaseEnergyValue;
import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.IEnergyValue;
import java.text.NumberFormat;

public class ForgeEnergyValue
extends BaseEnergyValue<Integer> {
    public ForgeEnergyValue(int value) {
        super(EnergySystemRegistry.FORGE_ENERGY, value);
    }

    @Override
    public IEnergyValue<Integer> add(IEnergyValue other) {
        if (!this.isCompatible(other)) {
            return this;
        }
        ForgeEnergyValue otherEnergy = EnergySystemRegistry.FORGE_ENERGY.convertFrom(other);
        return new ForgeEnergyValue((Integer)this.getValue() + (otherEnergy == null ? 0 : (Integer)otherEnergy.getValue()));
    }

    @Override
    public IEnergyValue<Integer> subtract(IEnergyValue other) {
        if (!this.isCompatible(other)) {
            return this;
        }
        ForgeEnergyValue otherEnergy = EnergySystemRegistry.FORGE_ENERGY.convertFrom(other);
        return new ForgeEnergyValue((Integer)this.getValue() - (otherEnergy == null ? 0 : (Integer)otherEnergy.getValue()));
    }

    @Override
    public IEnergyValue<Integer> copy() {
        return new ForgeEnergyValue((Integer)this.getValue());
    }

    public String toString() {
        return NumberFormat.getNumberInstance().format(this.getValue()) + " FE";
    }
}

