/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.block;

import com.mcmoddev.lib.block.MMDBlockWithGui;
import com.mcmoddev.lib.tile.MMDTileEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MMDBlockWithTile<T extends MMDTileEntity>
extends MMDBlockWithGui
implements ITileEntityProvider {
    private final Class<T> tileClass;
    private final Supplier<T> tileClassCreator;

    public MMDBlockWithTile(Class<T> tileClass, Supplier<T> tileClassCreator, Material materialIn) {
        super(materialIn);
        this.tileClass = tileClass;
        this.tileClassCreator = tileClassCreator;
    }

    public MMDBlockWithTile(Class<T> tileClass, Supplier<T> tileClassCreator, Material materialIn, MapColor blockMapColorIn) {
        super(materialIn, blockMapColorIn);
        this.tileClass = tileClass;
        this.tileClassCreator = tileClassCreator;
    }

    public void registerTile() {
        ResourceLocation key = this.getRegistryName();
        if (key != null) {
            GameRegistry.registerTileEntity(this.tileClass, (String)(key.toString() + "_tile"));
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return (TileEntity)this.tileClassCreator.get();
    }
}

