/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class NormalCloudGenerator
extends FeatureBase
implements IFeature {
    private NormalCloudGenerator(Random rand) {
        super(rand);
    }

    public NormalCloudGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, ISpawnEntry spawnData, ChunkPos chunkPos) {
        ChunkPos pos = chunkPos;
        JsonObject params = spawnData.getFeature().getFeatureParameters();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        NormalCloudGenerator.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, spawnData);
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        int maxSpread = params.get("maxSpread").getAsInt();
        int medianSize = params.get("medianSize").getAsInt();
        int minHeight = params.get("minHeight").getAsInt();
        int maxHeight = params.get("maxHeight").getAsInt();
        int variance = params.get("variation").getAsInt();
        int frequency = params.get("frequency").getAsInt();
        int triesMin = params.get("minAttempts").getAsInt();
        int triesMax = params.get("maxAttempts").getAsInt();
        int offsetXZ = 32 - maxSpread;
        int sizeY = maxHeight - minHeight;
        int offsetY = sizeY - maxSpread;
        int radiusXZ = offsetXZ / 2;
        int radiusY = offsetY / 2;
        int blockY = minHeight + sizeY / 2;
        int fSave = frequency;
        int tryCount = 0;
        for (int tries = triesMax == triesMin ? triesMax : this.random.nextInt(triesMax - triesMin) + triesMin; tries > 0; --tries) {
            BlockPos p;
            if (this.random.nextInt(100) > frequency) continue;
            frequency = fSave;
            int x = blockX + this.getPoint(0, offsetXZ, radiusXZ) + radiusXZ;
            int y = blockY + this.getPoint(0, offsetY, radiusY);
            int z = blockZ + this.getPoint(0, offsetXZ, radiusXZ) + radiusXZ;
            int r = medianSize - variance;
            if (variance > 0) {
                r += this.random.nextInt(2 * variance) - variance;
            }
            if (!this.spawnCloud(r, maxSpread, minHeight, maxHeight, p = new BlockPos(x, y, z), spawnData, world) && tryCount < 5) {
                ++tries;
                frequency = 100;
                ++tryCount;
                continue;
            }
            tryCount = 0;
        }
    }

    private boolean spawnCloud(int size, int maxSpread, int minHeight, int maxHeight, BlockPos pos, ISpawnEntry spawnData, World world) {
        if (!this.spawn(spawnData.getBlocks().getRandomBlock(this.random), world, pos, world.field_73011_w.getDimension(), true, spawnData)) {
            return false;
        }
        int radius = maxSpread / 2;
        boolean alreadySpewed = false;
        for (int count = Math.min(size, (int)Math.round(Math.PI * Math.pow(radius, 2.0))); count > 0; --count) {
            int z;
            int xp = this.getPoint(0, maxSpread, radius);
            int yp = this.getPoint(minHeight, maxHeight, (maxHeight - minHeight) / 2);
            int zp = this.getPoint(0, maxSpread, radius);
            BlockPos p = pos.func_177982_a(xp, yp, zp);
            for (z = 0; z < 5 && !this.spawn(spawnData.getBlocks().getRandomBlock(this.random), world, p, world.field_73011_w.getDimension(), true, spawnData); ++z) {
                xp = this.getPoint(0, maxSpread, radius);
                yp = this.getPoint(minHeight, maxHeight, (maxHeight - minHeight) / 2);
                zp = this.getPoint(0, maxSpread, radius);
                p = pos.func_177982_a(xp, yp, zp);
            }
            if (z < 5 || alreadySpewed) continue;
            OreSpawn.LOGGER.info("unable to achieve requested cloud density for cloud centered at %s", (Object)pos);
            alreadySpewed = true;
        }
        return true;
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("maxSpread", (Number)16);
        defParams.addProperty("medianSize", (Number)8);
        defParams.addProperty("minHeight", (Number)8);
        defParams.addProperty("maxHeight", (Number)24);
        defParams.addProperty("variation", (Number)4);
        defParams.addProperty("frequency", (Number)25);
        defParams.addProperty("minAttempts", (Number)4);
        defParams.addProperty("maxAttempts", (Number)4);
        return defParams;
    }
}

