/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.IReplacementEntry;
import com.mcmoddev.orespawn.impl.os3.ReplacementEntry;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.io.FileUtils;

public class ReplacementsRegistry {
    private static final String ORE_SPAWN_VERSION = "OreSpawn Version";
    private static final IForgeRegistryModifiable<IReplacementEntry> registry = (IForgeRegistryModifiable)new RegistryBuilder().setName(new ResourceLocation("orespawn", "replacements_registry")).allowModification().setType(IReplacementEntry.class).setMaxID(65535).create();

    public Map<ResourceLocation, IReplacementEntry> getReplacements() {
        return ImmutableMap.copyOf((Iterable)registry.getEntries());
    }

    public List<IBlockState> getDimensionDefault(int dimension) {
        String[] names = new String[]{"minecraft:netherrack", "minecraft:stone", "minecraft:end_stone"};
        List mineralogyOres = OreDictionary.getOres((String)"cobblestone").stream().filter(iS -> iS.func_77973_b().getRegistryName().func_110624_b().equals("mineralogy")).map(iS -> Block.func_149634_a((Item)iS.func_77973_b()).func_176203_a(iS.func_77960_j())).collect(Collectors.toList());
        ArrayList<IBlockState> baseRv = new ArrayList<IBlockState>();
        baseRv.addAll(mineralogyOres);
        if (dimension < -1 || dimension > 1 || dimension == 0) {
            for (ItemStack iS2 : OreDictionary.getOres((String)"stone")) {
                baseRv.add(Block.func_149634_a((Item)iS2.func_77973_b()).func_176203_a(iS2.func_77960_j()));
            }
            return baseRv;
        }
        baseRv.addAll(Arrays.asList(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(names[dimension + 1]))).func_176223_P()));
        return baseRv;
    }

    public IReplacementEntry getReplacement(String name) {
        ResourceLocation act = new ResourceLocation(name.contains(":") ? name : String.format(Locale.ENGLISH, "orespawn:%s", name));
        if (registry.containsKey(act)) {
            return (IReplacementEntry)registry.getValue(act);
        }
        return (IReplacementEntry)registry.getValue(new ResourceLocation("orespawn:default"));
    }

    public void addBlock(String name, String blockName, String blockState) {
        IBlockState b;
        try {
            b = StateUtil.deserializeState((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName)), blockState);
        }
        catch (Exception e) {
            StringBuilder p = new StringBuilder();
            for (StackTraceElement elem : e.getStackTrace()) {
                p.append(String.format("%s.%s (%s:%u)\n", elem.getClassName(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber()));
            }
            OreSpawn.LOGGER.error(String.format("Exception: %s\n%s", e.getMessage(), p.toString()));
            b = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName))).func_176223_P();
        }
        this.addBlock(name, b);
    }

    public Map<String, List<IBlockState>> getBlocks() {
        TreeMap tempMap = new TreeMap();
        registry.getEntries().stream().forEach(e -> tempMap.put(((ResourceLocation)e.getKey()).toString(), ((IReplacementEntry)e.getValue()).getEntries()));
        return Collections.unmodifiableMap(tempMap);
    }

    public void addReplacement(IReplacementEntry replacement) {
        registry.register((IForgeRegistryEntry)replacement);
    }

    public void addBlock(String name, IBlockState state) {
        ResourceLocation regName = new ResourceLocation(name);
        if (registry.containsKey(regName)) {
            IReplacementEntry old = (IReplacementEntry)registry.getValue(regName);
            List<IBlockState> oldList = old.getEntries();
            oldList.add(state);
            ReplacementEntry newRE = new ReplacementEntry(name, oldList);
            registry.remove(regName);
            newRE.setRegistryName(regName);
            registry.register((IForgeRegistryEntry)newRE);
            return;
        }
        ReplacementEntry r = new ReplacementEntry(name, state);
        registry.register((IForgeRegistryEntry)r);
    }

    public void loadFile(Path file) {
        String rawJson;
        JsonParser parser = new JsonParser();
        try {
            rawJson = FileUtils.readFileToString((File)file.toFile(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getFileName()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
            return;
        }
        JsonObject elements = parser.parse(rawJson).getAsJsonObject();
        elements.entrySet().stream().forEach(elem -> {
            String entName = (String)elem.getKey();
            JsonArray entries = ((JsonElement)elem.getValue()).getAsJsonArray();
            LinkedList<IBlockState> blocks = new LinkedList<IBlockState>();
            entries.forEach(e -> {
                JsonObject asObj = e.getAsJsonObject();
                String blockName = asObj.get("name").getAsString().toLowerCase();
                if (blockName.startsWith("ore:")) {
                    this.loadOreDict(blockName, blocks);
                } else {
                    ResourceLocation blockRL = new ResourceLocation(blockName);
                    Block theBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockRL);
                    if (asObj.has("metaData")) {
                        int meta = asObj.get("metaData").getAsInt();
                        blocks.add(theBlock.func_176203_a(meta));
                    } else if (asObj.has("state")) {
                        this.loadBlockState(blockName, asObj, blocks);
                    } else {
                        blocks.add(theBlock.func_176223_P());
                    }
                }
            });
            ReplacementEntry replacer = new ReplacementEntry("orespawn:" + entName, blocks);
            registry.register((IForgeRegistryEntry)replacer);
        });
    }

    private void loadBlockState(String blockName, JsonObject asObj, List<IBlockState> blocks) {
        IBlockState b;
        ResourceLocation blockRL = new ResourceLocation(blockName);
        Block theBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockRL);
        String state = asObj.get("state").getAsString();
        try {
            b = StateUtil.deserializeState(theBlock, state);
        }
        catch (Exception e1) {
            StringBuilder p = new StringBuilder();
            for (StackTraceElement elem1 : e1.getStackTrace()) {
                p.append(String.format("%s.%s (%s:%d)\n", elem1.getClassName(), elem1.getMethodName(), elem1.getFileName(), elem1.getLineNumber()));
            }
            OreSpawn.LOGGER.error(String.format("Exception loading block with state [%s]: %s\n%s", state, e1.getMessage(), p.toString()));
            b = theBlock.func_176223_P();
        }
        blocks.add(b);
    }

    private void loadOreDict(String blockName, List<IBlockState> blocks) {
        String oreDictName = blockName.split(":")[1];
        OreDictionary.getOres((String)oreDictName).forEach(iS -> {
            if (iS.func_77960_j() != 0) {
                blocks.add(Block.func_149634_a((Item)iS.func_77973_b()).func_176203_a(iS.func_77960_j()));
            } else {
                blocks.add(Block.func_149634_a((Item)iS.func_77973_b()).func_176223_P());
            }
        });
    }

    public void saveFile(String modName) {
        JsonObject outs = new JsonObject();
        registry.getEntries().stream().filter(ent -> ((ResourceLocation)ent.getKey()).func_110624_b().equals(modName)).forEach(ent -> {
            JsonArray entry = new JsonArray();
            IReplacementEntry workVal = (IReplacementEntry)ent.getValue();
            workVal.getEntries().stream().forEach(bs -> {
                JsonObject block = new JsonObject();
                block.addProperty("blocks", bs.func_177230_c().getRegistryName().toString());
                if (!bs.toString().matches("\\[normal\\]")) {
                    block.addProperty("state", bs.toString().replaceAll("[\\[\\]]", ""));
                }
                entry.add((JsonElement)block);
            });
            outs.add(((ResourceLocation)ent.getKey()).toString(), (JsonElement)entry);
        });
        Path p = Paths.get("config", "orespawn3", "sysconfig", String.format(Locale.ENGLISH, "replacements-%s.json", modName));
        try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String ov = gson.toJson((JsonElement)outs);
            w.write(ov);
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)String.format(Locale.ENGLISH, "Failed writing replacements file  %s", p.toAbsolutePath().toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    public boolean has(ResourceLocation resourceLocation) {
        return registry.containsKey(resourceLocation);
    }
}

