/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.exceptions.BadStateValueException;
import com.mcmoddev.orespawn.api.os3.IBlockBuilder;
import com.mcmoddev.orespawn.api.os3.IBlockDefinition;
import com.mcmoddev.orespawn.impl.os3.BlockDefinition;
import com.mcmoddev.orespawn.util.StateUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockBuilder
implements IBlockBuilder {
    private IBlockState blockState;
    private int chance;
    private boolean isValid = true;

    @Override
    public IBlockBuilder setFromBlockState(IBlockState blockState) {
        ResourceLocation key = blockState.func_177230_c().getRegistryName();
        if (!ForgeRegistries.BLOCKS.containsKey(key)) {
            this.isValid = false;
        }
        return this.setFromBlockStateWithChance(blockState, 100);
    }

    @Override
    public IBlockBuilder setFromBlock(Block block) {
        ResourceLocation key = block.getRegistryName();
        if (!ForgeRegistries.BLOCKS.containsKey(key)) {
            this.isValid = false;
        }
        return this.setFromBlockState(block.func_176223_P());
    }

    @Override
    public IBlockBuilder setFromName(String blockName) {
        return this.setFromName(new ResourceLocation(blockName));
    }

    @Override
    public IBlockBuilder setFromName(String blockName, String state) {
        return this.setFromName(new ResourceLocation(blockName), state);
    }

    @Override
    public IBlockBuilder setFromName(String blockName, int metadata) {
        return this.setFromName(new ResourceLocation(blockName), metadata);
    }

    @Override
    public IBlockBuilder setFromName(ResourceLocation blockResourceLocation) {
        if (!ForgeRegistries.BLOCKS.containsKey(blockResourceLocation)) {
            this.isValid = false;
        }
        return this.setFromBlock((Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation));
    }

    @Override
    public IBlockBuilder setFromName(ResourceLocation blockResourceLocation, String state) {
        if (!ForgeRegistries.BLOCKS.containsKey(blockResourceLocation)) {
            this.isValid = false;
        }
        Block tempBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation);
        try {
            return this.setFromBlockState(StateUtil.deserializeState(tempBlock, state));
        }
        catch (BadStateValueException e) {
            StringBuilder p = new StringBuilder();
            for (StackTraceElement elem : e.getStackTrace()) {
                p.append(String.format("%s.%s (%s:%u)\n", elem.getClassName(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber()));
            }
            OreSpawn.LOGGER.error(String.format("Exception: %s\n%s", e.getMessage(), p.toString()));
            return this;
        }
    }

    @Override
    @Deprecated
    public IBlockBuilder setFromName(ResourceLocation blockResourceLocation, int metadata) {
        if (!ForgeRegistries.BLOCKS.containsKey(blockResourceLocation)) {
            this.isValid = false;
        }
        Block tempBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation);
        return this.setFromBlockState(tempBlock.func_176203_a(metadata));
    }

    @Override
    public IBlockBuilder setFromBlockStateWithChance(IBlockState blockState, int chance) {
        ResourceLocation key = blockState.func_177230_c().getRegistryName();
        if (!ForgeRegistries.BLOCKS.containsKey(key)) {
            this.isValid = false;
        }
        this.blockState = blockState;
        this.chance = chance;
        return this;
    }

    @Override
    public IBlockBuilder setFromBlockWithChance(Block block, int chance) {
        ResourceLocation key = block.getRegistryName();
        if (!ForgeRegistries.BLOCKS.containsKey(key)) {
            this.isValid = false;
        }
        return this.setFromBlockStateWithChance(block.func_176223_P(), chance);
    }

    @Override
    public IBlockBuilder setFromNameWithChance(String blockName, int chance) {
        return this.setFromNameWithChance(new ResourceLocation(blockName), chance);
    }

    @Override
    public IBlockBuilder setFromNameWithChance(String blockName, String state, int chance) {
        return this.setFromNameWithChance(new ResourceLocation(blockName), state, chance);
    }

    @Override
    public IBlockBuilder setFromNameWithChance(String blockName, int metadata, int chance) {
        return this.setFromNameWithChance(new ResourceLocation(blockName), metadata, chance);
    }

    @Override
    public IBlockBuilder setFromNameWithChance(ResourceLocation blockResourceLocation, int chance) {
        if (!ForgeRegistries.BLOCKS.containsKey(blockResourceLocation)) {
            this.isValid = false;
        }
        return this.setFromBlockWithChance((Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation), chance);
    }

    @Override
    public IBlockBuilder setFromNameWithChance(ResourceLocation blockResourceLocation, String state, int chance) {
        if (!ForgeRegistries.BLOCKS.containsKey(blockResourceLocation)) {
            this.isValid = false;
        }
        Block tempBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation);
        try {
            return this.setFromBlockStateWithChance(StateUtil.deserializeState(tempBlock, state), chance);
        }
        catch (BadStateValueException e) {
            StringBuilder p = new StringBuilder();
            for (StackTraceElement elem : e.getStackTrace()) {
                p.append(String.format("%s.%s (%s:%u)\n", elem.getClassName(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber()));
            }
            OreSpawn.LOGGER.error(String.format("Exception: %s\n%s", e.getMessage(), p.toString()));
            return this;
        }
    }

    @Override
    @Deprecated
    public IBlockBuilder setFromNameWithChance(ResourceLocation blockResourceLocation, int metadata, int chance) {
        if (!ForgeRegistries.BLOCKS.containsKey(blockResourceLocation)) {
            this.isValid = false;
        }
        Block tempBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation);
        return this.setFromBlockStateWithChance(tempBlock.func_176203_a(metadata), chance);
    }

    @Override
    public IBlockBuilder setChance(int chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public IBlockDefinition create() {
        return new BlockDefinition(this.blockState, this.chance, this.isValid);
    }
}

