/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Station;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import mtr.servlet.Webserver;
import net.minecraft.world.entity.player.Player;

public class InfoServletHandler
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        Webserver.callback.accept(() -> {
            JsonArray dataArray = new JsonArray();
            Webserver.getWorlds.get().forEach(world -> {
                RailwayData railwayData = RailwayData.getInstance(world);
                JsonArray playersArray = new JsonArray();
                if (railwayData != null) {
                    world.m_6907_().forEach(player -> {
                        int color;
                        String circular;
                        String destination;
                        String routeNumber;
                        String routeName;
                        JsonObject dataObject = new JsonObject();
                        dataObject.addProperty("player", player.m_7755_().getString());
                        Route route = railwayData.railwayDataCoolDownModule.getRidingRoute((Player)player);
                        if (route == null) {
                            routeName = "";
                            routeNumber = "";
                            destination = "";
                            circular = "";
                            color = 0;
                        } else {
                            routeName = route.name;
                            routeNumber = route.isLightRailRoute ? route.lightRailRouteNumber : "";
                            Station station = railwayData.dataCache.platformIdToStation.get(route.platformIds.get(route.platformIds.size() - 1));
                            String string = destination = station == null ? "" : station.name;
                            circular = route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw");
                            color = route.color;
                        }
                        dataObject.addProperty("name", routeName);
                        dataObject.addProperty("number", routeNumber);
                        dataObject.addProperty("destination", destination);
                        dataObject.addProperty("circular", circular);
                        dataObject.addProperty("color", (Number)color);
                        playersArray.add((JsonElement)dataObject);
                    });
                }
                dataArray.add((JsonElement)playersArray);
            });
            IServletHandler.sendResponse(response, asyncContext, dataArray.toString());
        });
    }
}

