/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mtr.data.DataCache;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.data.Station;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import mtr.servlet.Webserver;

public class ArrivalsServletHandler
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        long stationId = 0L;
        long worldIndex = 0L;
        try {
            stationId = Long.parseLong(request.getParameter("stationId"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            worldIndex = Integer.parseInt(request.getParameter("worldIndex"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        AsyncContext asyncContext = request.startAsync();
        long stationIdFinal = stationId;
        long worldIndexFinal = worldIndex;
        Webserver.callback.accept(() -> {
            JsonArray dataArray = new JsonArray();
            int[] worldIndexCounter = new int[]{0};
            Webserver.getWorlds.get().forEach(world -> {
                RailwayData railwayData;
                if ((long)worldIndexCounter[0] == worldIndexFinal && (railwayData = RailwayData.getInstance(world)) != null) {
                    HashMap<Long, List<ScheduleEntry>> schedulesForStation = new HashMap<Long, List<ScheduleEntry>>();
                    railwayData.getSchedulesForStation(schedulesForStation, stationIdFinal);
                    ArrayList scheduleEntries = new ArrayList();
                    schedulesForStation.values().forEach(scheduleEntries::addAll);
                    Collections.sort(scheduleEntries);
                    for (ScheduleEntry scheduleEntry : scheduleEntries) {
                        DataCache dataCache = railwayData.dataCache;
                        Route route = dataCache.routeIdMap.get(scheduleEntry.routeId);
                        if (route == null || scheduleEntry.currentStationIndex >= route.platformIds.size() - 1) continue;
                        JsonObject scheduleObject = new JsonObject();
                        scheduleObject.addProperty("arrival", (Number)scheduleEntry.arrivalMillis);
                        scheduleObject.addProperty("name", route.name);
                        Station station = railwayData.dataCache.platformIdToStation.get(route.platformIds.get(route.platformIds.size() - 1));
                        scheduleObject.addProperty("destination", station == null ? "" : station.name);
                        scheduleObject.addProperty("circular", route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw"));
                        scheduleObject.addProperty("route", route.isLightRailRoute ? route.lightRailRouteNumber : "");
                        Platform platform = railwayData.dataCache.platformIdMap.get(route.platformIds.get(scheduleEntry.currentStationIndex));
                        scheduleObject.addProperty("platform", platform == null ? "" : platform.name);
                        scheduleObject.addProperty("color", (Number)route.color);
                        dataArray.add((JsonElement)scheduleObject);
                    }
                }
                worldIndexCounter[0] = worldIndexCounter[0] + 1;
            });
            IServletHandler.sendResponse(response, asyncContext, dataArray.toString());
        });
    }
}

