/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.AreaBase;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.SavedRailBase;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.SelectableMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.levelgen.Heightmap;

public class WidgetMap
implements Widget,
SelectableMapper,
GuiEventListener,
IGui {
    private int x;
    private int y;
    private int width;
    private int height;
    private double scale;
    private double centerX;
    private double centerY;
    private Tuple<Integer, Integer> drawArea1;
    private Tuple<Integer, Integer> drawArea2;
    private MapState mapState;
    private boolean showStations;
    private final TransportMode transportMode;
    private final OnDrawCorners onDrawCorners;
    private final Runnable onDrawCornersMouseRelease;
    private final Consumer<Long> onClickAddPlatformToRoute;
    private final Consumer<SavedRailBase> onClickEditSavedRail;
    private final BiFunction<Double, Double, Boolean> isRestrictedMouseArea;
    private final ClientLevel world;
    private final LocalPlayer player;
    private final Font textRenderer;
    private static final int ARGB_BLUE = -12417548;
    private static final int SCALE_UPPER_LIMIT = 64;
    private static final double SCALE_LOWER_LIMIT = 0.0078125;

    public WidgetMap(TransportMode transportMode, OnDrawCorners onDrawCorners, Runnable onDrawCornersMouseRelease, Consumer<Long> onClickAddPlatformToRoute, Consumer<SavedRailBase> onClickEditSavedRail, BiFunction<Double, Double, Boolean> isRestrictedMouseArea) {
        this.transportMode = transportMode;
        this.onDrawCorners = onDrawCorners;
        this.onDrawCornersMouseRelease = onDrawCornersMouseRelease;
        this.onClickAddPlatformToRoute = onClickAddPlatformToRoute;
        this.onClickEditSavedRail = onClickEditSavedRail;
        this.isRestrictedMouseArea = isRestrictedMouseArea;
        Minecraft minecraftClient = Minecraft.m_91087_();
        this.world = minecraftClient.f_91073_;
        this.player = minecraftClient.f_91074_;
        this.textRenderer = minecraftClient.f_91062_;
        if (this.player == null) {
            this.centerX = 0.0;
            this.centerY = 0.0;
        } else {
            this.centerX = this.player.m_20185_();
            this.centerY = this.player.m_20189_();
        }
        this.scale = 1.0;
        this.setShowStations(true);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        UtilitiesClient.beginDrawingRectangle(buffer);
        RenderSystem.m_69478_();
        Tuple<Integer, Integer> topLeft = this.coordsToWorldPos(0, 0);
        Tuple<Integer, Integer> bottomRight = this.coordsToWorldPos(this.width, this.height);
        int increment = this.scale >= 1.0 ? 1 : (int)Math.ceil(1.0 / this.scale);
        for (int i = ((Integer)topLeft.m_14418_()).intValue(); i <= (Integer)bottomRight.m_14418_(); i += increment) {
            for (int j = ((Integer)topLeft.m_14419_()).intValue(); j <= (Integer)bottomRight.m_14419_(); j += increment) {
                if (this.world == null) continue;
                int color = WidgetMap.divideColorRGB(this.world.m_8055_((BlockPos)new BlockPos((int)i, (int)(this.world.m_6924_((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (int)i, (int)j) - 1), (int)j)).m_60734_().m_60590_().f_76396_, 2);
                this.drawRectangleFromWorldCoords(buffer, i, j, i + increment, j + increment, 0xFF000000 | color);
            }
        }
        Tuple<Double, Double> mouseWorldPos = this.coordsToWorldPos((double)mouseX - (double)this.x, (double)(mouseY - this.y));
        try {
            if (this.showStations) {
                ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode).forEach((platformPos, platforms) -> this.drawRectangleFromWorldCoords(buffer, platformPos.m_123341_(), platformPos.m_123343_(), platformPos.m_123341_() + 1, platformPos.m_123343_() + 1, -1));
                for (Station station : ClientData.STATIONS) {
                    if (!AreaBase.nonNullCorners(station)) continue;
                    this.drawRectangleFromWorldCoords(buffer, (Tuple<Integer, Integer>)station.corner1, (Tuple<Integer, Integer>)station.corner2, 0x7F000000 + station.color);
                }
                this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(buffer, x1, z1, x2, z2, -1), true);
            } else {
                ClientData.DATA_CACHE.getPosToSidings(this.transportMode).forEach((sidingPos, sidings) -> this.drawRectangleFromWorldCoords(buffer, sidingPos.m_123341_(), sidingPos.m_123343_(), sidingPos.m_123341_() + 1, sidingPos.m_123343_() + 1, -1));
                for (Depot depot : ClientData.DEPOTS) {
                    if (!depot.isTransportMode(this.transportMode) || !AreaBase.nonNullCorners(depot)) continue;
                    this.drawRectangleFromWorldCoords(buffer, (Tuple<Integer, Integer>)depot.corner1, (Tuple<Integer, Integer>)depot.corner2, 0x7F000000 + depot.color);
                }
                this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(buffer, x1, z1, x2, z2, -1), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mapState == MapState.EDITING_AREA && this.drawArea1 != null && this.drawArea2 != null) {
            this.drawRectangleFromWorldCoords(buffer, this.drawArea1, this.drawArea2, Integer.MAX_VALUE);
        }
        if (this.player != null) {
            this.drawFromWorldCoords(this.player.m_20185_(), this.player.m_20189_(), (x1, y1) -> {
                this.drawRectangle(buffer, x1 - 2.0, y1 - 3.0, x1 + 2.0, y1 + 3.0, -1);
                this.drawRectangle(buffer, x1 - 3.0, y1 - 2.0, x1 + 3.0, y1 + 2.0, -1);
                this.drawRectangle(buffer, x1 - 2.0, y1 - 2.0, x1 + 2.0, y1 + 2.0, -12417548);
            });
        }
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        UtilitiesClient.finishDrawingRectangle();
        if (this.mapState == MapState.EDITING_AREA) {
            Gui.m_93236_((PoseStack)matrices, (Font)this.textRenderer, (String)Text.translatable("gui.mtr.edit_area", new Object[0]).getString(), (int)(this.x + 6), (int)(this.y + 6), (int)-1);
        } else if (this.mapState == MapState.EDITING_ROUTE) {
            Gui.m_93236_((PoseStack)matrices, (Font)this.textRenderer, (String)Text.translatable("gui.mtr.edit_route", new Object[0]).getString(), (int)(this.x + 6), (int)(this.y + 6), (int)-1);
        }
        if (this.scale >= 8.0) {
            try {
                if (this.showStations) {
                    ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode).forEach((platformPos, platforms) -> this.drawSavedRail(matrices, (BlockPos)platformPos, (List<? extends SavedRailBase>)platforms));
                } else {
                    ClientData.DATA_CACHE.getPosToSidings(this.transportMode).forEach((sidingPos, sidings) -> this.drawSavedRail(matrices, (BlockPos)sidingPos, (List<? extends SavedRailBase>)sidings));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (this.showStations) {
            for (Station station : ClientData.STATIONS) {
                if (!this.canDrawAreaText(station)) continue;
                BlockPos pos = station.getCenter();
                String stationString = String.format("%s|(%s)", station.name, Text.translatable("gui.mtr.zone_number", station.zone).getString());
                this.drawFromWorldCoords(pos.m_123341_(), pos.m_123343_(), (x1, y1) -> IDrawing.drawStringWithFont(matrices, this.textRenderer, immediate, stationString, (float)this.x + (float)x1, (float)this.y + (float)y1, 0xF000F0));
            }
        } else {
            for (Depot depot : ClientData.DEPOTS) {
                if (!this.canDrawAreaText(depot)) continue;
                BlockPos pos = depot.getCenter();
                this.drawFromWorldCoords(pos.m_123341_(), pos.m_123343_(), (x1, y1) -> IDrawing.drawStringWithFont(matrices, this.textRenderer, immediate, depot.name, (float)this.x + (float)x1, (float)this.y + (float)y1, 0xF000F0));
            }
        }
        immediate.m_109911_();
        String mousePosText = String.format("(%s, %s)", Float.valueOf(RailwayData.round((Double)mouseWorldPos.m_14418_(), 1)), Float.valueOf(RailwayData.round((Double)mouseWorldPos.m_14419_(), 1)));
        Gui.m_93236_((PoseStack)matrices, (Font)this.textRenderer, (String)mousePosText, (int)(this.x + this.width - 6 - this.textRenderer.m_92895_(mousePosText)), (int)(this.y + 6), (int)-1);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.drawArea2 = this.coordsToWorldPos((int)Math.round(mouseX - (double)this.x), (int)Math.round(mouseY - (double)this.y));
            if (((Integer)this.drawArea1.m_14418_()).equals(this.drawArea2.m_14418_())) {
                this.drawArea2 = new Tuple((Object)((Integer)this.drawArea2.m_14418_() + 1), (Object)((Integer)this.drawArea2.m_14419_()));
            }
            if (((Integer)this.drawArea1.m_14419_()).equals(this.drawArea2.m_14419_())) {
                this.drawArea2 = new Tuple((Object)((Integer)this.drawArea2.m_14418_()), (Object)((Integer)this.drawArea2.m_14419_() + 1));
            }
            this.onDrawCorners.onDrawCorners(this.drawArea1, this.drawArea2);
        } else {
            this.centerX -= deltaX / this.scale;
            this.centerY -= deltaY / this.scale;
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.onDrawCornersMouseRelease.run();
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (ClientData.hasPermission()) {
                if (this.mapState == MapState.EDITING_AREA) {
                    this.drawArea1 = this.coordsToWorldPos((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y));
                    this.drawArea2 = null;
                } else if (this.mapState == MapState.EDITING_ROUTE) {
                    Tuple<Double, Double> mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.x, mouseY - (double)this.y);
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickAddPlatformToRoute.accept(savedRail.id), true);
                } else {
                    Tuple<Double, Double> mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.x, mouseY - (double)this.y);
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickEditSavedRail.accept(savedRail), this.showStations);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        double oldScale = this.scale;
        if (oldScale > 0.0078125 && amount < 0.0) {
            this.centerX -= (mouseX - (double)this.x - (double)this.width / 2.0) / this.scale;
            this.centerY -= (mouseY - (double)this.y - (double)this.height / 2.0) / this.scale;
        }
        this.scale(amount);
        if (oldScale < 64.0 && amount > 0.0) {
            this.centerX += (mouseX - (double)this.x - (double)this.width / 2.0) / this.scale;
            this.centerY += (mouseY - (double)this.y - (double)this.height / 2.0) / this.scale;
        }
        return true;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height) && (!(mouseX >= (double)(this.x + this.width - 200)) || !(mouseY >= (double)(this.y + this.height - 20))) && this.isRestrictedMouseArea.apply(mouseX, mouseY) == false;
    }

    public void setPositionAndSize(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void scale(double amount) {
        this.scale *= Math.pow(2.0, amount);
        this.scale = Mth.m_14008_((double)this.scale, (double)0.0078125, (double)64.0);
    }

    public void find(double x1, double z1, double x2, double z2) {
        this.centerX = (x1 + x2) / 2.0;
        this.centerY = (z1 + z2) / 2.0;
        this.scale = Math.max(2.0, this.scale);
    }

    public void find(BlockPos pos) {
        this.centerX = pos.m_123341_();
        this.centerY = pos.m_123343_();
        this.scale = Math.max(8.0, this.scale);
    }

    public void startEditingArea(AreaBase editingArea) {
        this.mapState = MapState.EDITING_AREA;
        this.drawArea1 = editingArea.corner1;
        this.drawArea2 = editingArea.corner2;
    }

    public void startEditingRoute() {
        this.mapState = MapState.EDITING_ROUTE;
    }

    public void stopEditing() {
        this.mapState = MapState.DEFAULT;
    }

    public void setShowStations(boolean showStations) {
        this.showStations = showStations;
    }

    private void mouseOnSavedRail(Tuple<Double, Double> mouseWorldPos, MouseOnSavedRailCallback mouseOnSavedRailCallback, boolean isPlatform) {
        try {
            (isPlatform ? ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode) : ClientData.DATA_CACHE.getPosToSidings(this.transportMode)).forEach((savedRailPos, savedRails) -> {
                int savedRailCount = savedRails.size();
                for (int i = 0; i < savedRailCount; ++i) {
                    float left = savedRailPos.m_123341_();
                    float right = savedRailPos.m_123341_() + 1;
                    float top = (float)savedRailPos.m_123343_() + (float)i / (float)savedRailCount;
                    float bottom = (float)savedRailPos.m_123343_() + ((float)i + 1.0f) / (float)savedRailCount;
                    if (!RailwayData.isBetween((Double)mouseWorldPos.m_14418_(), left, right) || !RailwayData.isBetween((Double)mouseWorldPos.m_14419_(), top, bottom)) continue;
                    mouseOnSavedRailCallback.mouseOnSavedRailCallback((SavedRailBase)savedRails.get(i), left, top, right, bottom);
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Tuple<Integer, Integer> coordsToWorldPos(int mouseX, int mouseY) {
        Tuple<Double, Double> worldPos = this.coordsToWorldPos((double)mouseX, (double)mouseY);
        return new Tuple((Object)((int)Math.floor((Double)worldPos.m_14418_())), (Object)((int)Math.floor((Double)worldPos.m_14419_())));
    }

    private Tuple<Double, Double> coordsToWorldPos(double mouseX, double mouseY) {
        double left = (mouseX - (double)this.width / 2.0) / this.scale + this.centerX;
        double right = (mouseY - (double)this.height / 2.0) / this.scale + this.centerY;
        return new Tuple((Object)left, (Object)right);
    }

    private void drawFromWorldCoords(double worldX, double worldZ, DrawFromWorldCoords callback) {
        double coordsX = (worldX - this.centerX) * this.scale + (double)this.width / 2.0;
        double coordsY = (worldZ - this.centerY) * this.scale + (double)this.height / 2.0;
        callback.drawFromWorldCoords(coordsX, coordsY);
    }

    private void drawRectangleFromWorldCoords(BufferBuilder buffer, Tuple<Integer, Integer> corner1, Tuple<Integer, Integer> corner2, int color) {
        this.drawRectangleFromWorldCoords(buffer, ((Integer)corner1.m_14418_()).intValue(), ((Integer)corner1.m_14419_()).intValue(), ((Integer)corner2.m_14418_()).intValue(), ((Integer)corner2.m_14419_()).intValue(), color);
    }

    private void drawRectangleFromWorldCoords(BufferBuilder buffer, double posX1, double posZ1, double posX2, double posZ2, int color) {
        double x1 = (posX1 - this.centerX) * this.scale + (double)this.width / 2.0;
        double z1 = (posZ1 - this.centerY) * this.scale + (double)this.height / 2.0;
        double x2 = (posX2 - this.centerX) * this.scale + (double)this.width / 2.0;
        double z2 = (posZ2 - this.centerY) * this.scale + (double)this.height / 2.0;
        this.drawRectangle(buffer, x1, z1, x2, z2, color);
    }

    private void drawRectangle(BufferBuilder buffer, double xA, double yA, double xB, double yB, int color) {
        double x1 = Math.min(xA, xB);
        double y1 = Math.min(yA, yB);
        double x2 = Math.max(xA, xB);
        double y2 = Math.max(yA, yB);
        if (x1 < (double)this.width && y1 < (double)this.height && x2 >= 0.0 && y2 >= 0.0) {
            IDrawing.drawRectangle((VertexConsumer)buffer, (double)this.x + Math.max(0.0, x1), (double)this.y + y1, (double)this.x + x2, (double)this.y + y2, color);
        }
    }

    private boolean canDrawAreaText(AreaBase areaBase) {
        return areaBase.getCenter() != null && this.scale >= (double)(80.0f / (float)Math.max(Math.abs((Integer)areaBase.corner1.m_14418_() - (Integer)areaBase.corner2.m_14418_()), Math.abs((Integer)areaBase.corner1.m_14419_() - (Integer)areaBase.corner2.m_14419_())));
    }

    private void drawSavedRail(PoseStack matrices, BlockPos savedRailPos, List<? extends SavedRailBase> savedRails) {
        int savedRailCount = savedRails.size();
        for (int i = 0; i < savedRailCount; ++i) {
            int index = i;
            this.drawFromWorldCoords((double)savedRailPos.m_123341_() + 0.5, (double)savedRailPos.m_123343_() + ((double)i + 0.5) / (double)savedRailCount, (x1, y1) -> Gui.m_93208_((PoseStack)matrices, (Font)this.textRenderer, (String)((SavedRailBase)savedRails.get((int)index)).name, (int)(this.x + (int)x1), (int)(this.y + (int)y1 - 4), (int)-1));
        }
    }

    private static int divideColorRGB(int color, int amount) {
        int r = (color >> 16 & 0xFF) / amount;
        int g = (color >> 8 & 0xFF) / amount;
        int b = (color & 0xFF) / amount;
        return (r << 16) + (g << 8) + b;
    }

    @FunctionalInterface
    public static interface OnDrawCorners {
        public void onDrawCorners(Tuple<Integer, Integer> var1, Tuple<Integer, Integer> var2);
    }

    @FunctionalInterface
    private static interface MouseOnSavedRailCallback {
        public void mouseOnSavedRailCallback(SavedRailBase var1, double var2, double var4, double var6, double var8);
    }

    private static enum MapState {
        DEFAULT,
        EDITING_AREA,
        EDITING_ROUTE;

    }

    @FunctionalInterface
    private static interface DrawFromWorldCoords {
        public void drawFromWorldCoords(double var1, double var3);
    }
}

