/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.data.DataConverter;
import mtr.data.NameColorDataBase;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.SavedRailScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SidingScreen
extends SavedRailScreenBase<Siding> {
    private boolean isSelectingTrain;
    private final float oldAcceleration;
    private final boolean oldIsManual;
    private final int oldMaxManualSpeed;
    private final int oldDwellTime;
    private final TransportMode transportMode;
    private final Button buttonSelectTrain;
    private final DashboardList availableTrainsList;
    private final WidgetBetterCheckbox buttonUnlimitedTrains;
    private final WidgetBetterTextField textFieldMaxTrains;
    private final WidgetShorterSlider sliderAccelerationConstant;
    private final WidgetBetterCheckbox buttonIsManual;
    private final WidgetShorterSlider sliderMaxManualSpeed;
    private static final Component SELECTED_TRAIN_TEXT = Text.translatable("gui.mtr.selected_vehicle", new Object[0]);
    private static final Component MAX_TRAINS_TEXT = Text.translatable("gui.mtr.max_vehicles", new Object[0]);
    private static final Component ACCELERATION_CONSTANT_TEXT = Text.translatable("gui.mtr.acceleration", new Object[0]);
    private static final Component MANUAL_TO_AUTOMATIC_TIME = Text.translatable("gui.mtr.manual_to_automatic_time", new Object[0]);
    private static final Component MAX_MANUAL_SPEED = Text.translatable("gui.mtr.max_manual_speed", new Object[0]);
    private static final int MAX_TRAINS_TEXT_LENGTH = 3;
    private static final int MAX_TRAINS_WIDTH = 80;
    private static final int SLIDER_SCALE = 1000;
    private static final float ACCELERATION_UNIT_CONVERSION_1 = 400.0f;
    private static final float ACCELERATION_UNIT_CONVERSION_2 = 1440.0f;

    public SidingScreen(Siding siding, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(siding, transportMode, dashboardScreen, SELECTED_TRAIN_TEXT, MAX_TRAINS_TEXT, ACCELERATION_CONSTANT_TEXT, MANUAL_TO_AUTOMATIC_TIME, MAX_MANUAL_SPEED);
        this.transportMode = transportMode;
        this.buttonSelectTrain = new Button(0, 0, 0, 20, (Component)Text.literal(""), button -> this.onSelectingTrain());
        this.availableTrainsList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.TRAINS_SEARCH, text -> {
            ClientData.TRAINS_SEARCH = text;
        });
        this.textFieldMaxTrains = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "", 3);
        this.sliderAccelerationConstant = new WidgetShorterSlider(0, 80, Math.round(49.000004f), this::accelerationSliderFormatter, null);
        this.buttonIsManual = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.is_manual", new Object[0]), checked -> {
            if (checked && !this.textFieldMaxTrains.m_94155_().equals("1")) {
                this.textFieldMaxTrains.m_94144_("1");
            }
            this.setIsSelectingTrain(false);
        });
        this.sliderMaxManualSpeed = new WidgetShorterSlider(0, 80, RailType.DIAMOND.ordinal(), this::speedSliderFormatter, null);
        this.buttonUnlimitedTrains = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.unlimited_vehicles", new Object[0]), checked -> {
            if (checked) {
                this.buttonIsManual.setChecked(false);
            }
            if (checked && !this.textFieldMaxTrains.m_94155_().isEmpty()) {
                this.textFieldMaxTrains.m_94144_("");
            } else if (!checked && this.textFieldMaxTrains.m_94155_().isEmpty()) {
                this.textFieldMaxTrains.m_94144_("1");
            }
            this.setIsSelectingTrain(false);
        });
        this.oldAcceleration = ((Siding)this.savedRailBase).getAccelerationConstant();
        this.oldIsManual = ((Siding)this.savedRailBase).getIsManual();
        this.oldMaxManualSpeed = ((Siding)this.savedRailBase).getMaxManualSpeed();
        this.oldDwellTime = ((Siding)this.savedRailBase).getDwellTime();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonSelectTrain, this.startX + this.textWidth, 44, 240);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonUnlimitedTrains, this.startX + this.textWidth + 80 + 4 + 4, 66, 240);
        this.addDrawableChild(this.buttonSelectTrain);
        this.availableTrainsList.y = 40;
        this.availableTrainsList.height = this.f_96544_ - 100;
        this.availableTrainsList.width = 240;
        this.availableTrainsList.init(this::addDrawableChild);
        this.buttonIsManual.setChecked(((Siding)this.savedRailBase).getIsManual());
        this.buttonUnlimitedTrains.setChecked(((Siding)this.savedRailBase).getUnlimitedTrains());
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldMaxTrains, this.startX + this.textWidth + 2, 66, 76);
        this.textFieldMaxTrains.m_94144_(((Siding)this.savedRailBase).getUnlimitedTrains() ? "" : String.valueOf(((Siding)this.savedRailBase).getMaxTrains() + 1));
        this.textFieldMaxTrains.m_94151_(text -> {
            this.buttonUnlimitedTrains.setChecked(text.isEmpty());
            if (!text.equals("1")) {
                this.buttonIsManual.setChecked(false);
            }
            this.setIsSelectingTrain(false);
        });
        this.sliderAccelerationConstant.f_93620_ = this.startX + this.textWidth;
        this.sliderAccelerationConstant.f_93621_ = 88;
        this.sliderAccelerationConstant.setHeight(20);
        this.sliderAccelerationConstant.setValue(Math.round((((Siding)this.savedRailBase).getAccelerationConstant() - 0.001f) * 1000.0f));
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsManual, this.startX, 128, 240);
        this.sliderMaxManualSpeed.f_93620_ = this.startX + this.textWidth;
        this.sliderMaxManualSpeed.f_93621_ = 148;
        this.sliderMaxManualSpeed.setHeight(20);
        this.sliderMaxManualSpeed.setValue(((Siding)this.savedRailBase).getMaxManualSpeed());
        this.sliderDwellTimeMin.f_93621_ = 168;
        this.sliderDwellTimeSec.f_93621_ = 178;
        this.setIsSelectingTrain(false);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.buttonUnlimitedTrains);
            this.addDrawableChild(this.textFieldMaxTrains);
            this.addDrawableChild(this.sliderAccelerationConstant);
            this.addDrawableChild(this.buttonIsManual);
            this.addDrawableChild(this.sliderMaxManualSpeed);
        }
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.availableTrainsList.tick();
        this.textFieldMaxTrains.m_94120_();
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (!this.isSelectingTrain) {
            this.f_96547_.m_92889_(matrices, SELECTED_TRAIN_TEXT, (float)this.startX, 50.0f, -1);
            if (this.showScheduleControls) {
                this.f_96547_.m_92889_(matrices, MAX_TRAINS_TEXT, (float)this.startX, 72.0f, -1);
                this.f_96547_.m_92889_(matrices, ACCELERATION_CONSTANT_TEXT, (float)this.startX, 94.0f, -1);
                if (this.buttonIsManual.m_93840_()) {
                    this.f_96547_.m_92889_(matrices, MAX_MANUAL_SPEED, (float)this.startX, 154.0f, -1);
                    this.f_96547_.m_92889_(matrices, MANUAL_TO_AUTOMATIC_TIME, (float)this.startX, 174.0f, -1);
                }
            }
        }
    }

    @Override
    public void m_7379_() {
        float accelerationConstant;
        int maxTrains;
        try {
            maxTrains = Math.max(0, Integer.parseInt(this.textFieldMaxTrains.m_94155_()) - 1);
        }
        catch (Exception ignored) {
            maxTrains = 0;
        }
        try {
            accelerationConstant = RailwayData.round(Mth.m_14036_((float)((float)this.sliderAccelerationConstant.getIntValue() / 1000.0f + 0.001f), (float)0.001f, (float)0.05f), 3);
        }
        catch (Exception ignored) {
            accelerationConstant = 0.01f;
        }
        boolean isManual = this.buttonIsManual.m_93840_();
        int maxManualSpeed = this.sliderMaxManualSpeed.getIntValue();
        int minutes = this.sliderDwellTimeMin.getIntValue();
        float second = (float)this.sliderDwellTimeSec.getIntValue() / 2.0f;
        int dwellTime = (int)((second + (float)(minutes * 60)) * 2.0f);
        ((Siding)this.savedRailBase).setUnlimitedTrains(this.buttonUnlimitedTrains.m_93840_(), maxTrains, isManual, maxManualSpeed, accelerationConstant, dwellTime, this.oldAcceleration != accelerationConstant || this.oldIsManual != isManual || this.oldMaxManualSpeed != maxManualSpeed || this.oldDwellTime != dwellTime, packet -> PacketTrainDataGuiClient.sendUpdate(this.getPacketIdentifier(), packet));
        super.m_7379_();
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.availableTrainsList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.availableTrainsList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    protected boolean shouldRenderExtra() {
        return this.isSelectingTrain;
    }

    @Override
    protected void renderExtra(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.availableTrainsList.render(matrices, this.f_96547_);
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.siding_number";
    }

    @Override
    protected ResourceLocation getPacketIdentifier() {
        return PACKET_UPDATE_SIDING;
    }

    private void onSelectingTrain() {
        ArrayList trainList = new ArrayList();
        TrainClientRegistry.forEach(this.transportMode, (id, trainProperties) -> trainList.add(new DataConverter(trainProperties.name.getString(), trainProperties.color)));
        this.availableTrainsList.setData(trainList, false, false, false, false, true, false);
        this.setIsSelectingTrain(true);
    }

    private void setIsSelectingTrain(boolean isSelectingTrain) {
        this.isSelectingTrain = isSelectingTrain;
        this.buttonSelectTrain.f_93624_ = !isSelectingTrain;
        this.buttonUnlimitedTrains.f_93624_ = !isSelectingTrain;
        this.textFieldMaxTrains.f_93624_ = !isSelectingTrain;
        this.sliderAccelerationConstant.f_93624_ = !isSelectingTrain;
        this.buttonIsManual.f_93624_ = !isSelectingTrain;
        this.sliderMaxManualSpeed.f_93624_ = !isSelectingTrain && this.buttonIsManual.m_93840_();
        this.sliderDwellTimeMin.f_93624_ = !isSelectingTrain && this.buttonIsManual.m_93840_();
        this.sliderDwellTimeSec.f_93624_ = !isSelectingTrain && this.buttonIsManual.m_93840_();
        this.buttonSelectTrain.m_93666_(TrainClientRegistry.getTrainProperties((String)((Siding)this.savedRailBase).getTrainId()).name);
        this.availableTrainsList.x = isSelectingTrain ? this.f_96543_ / 2 - 120 : this.f_96543_;
    }

    private void onAdd(NameColorDataBase data, int index) {
        ((Siding)this.savedRailBase).setTrainIdAndBaseType(TrainClientRegistry.getTrainId(this.transportMode, index), TrainClientRegistry.getTrainProperties((TransportMode)this.transportMode, (int)index).baseTrainType, packet -> PacketTrainDataGuiClient.sendUpdate(IPacket.PACKET_UPDATE_SIDING, packet));
        this.setIsSelectingTrain(false);
    }

    private String accelerationSliderFormatter(int value) {
        float valueMeterPerTickSquared = (float)value / 1000.0f + 0.001f;
        return String.format("%s m/s\u00b2 (%s km/h/s)", Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 400.0f, 1)), Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 1440.0f, 1)));
    }

    private String speedSliderFormatter(int value) {
        RailType railType = Train.convertMaxManualSpeed(value);
        return railType == null ? Text.translatable("gui.mtr.unlimited", new Object[0]).getString() : String.format("%s km/h", railType.speedLimit);
    }
}

