/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.block.BlockStationNameBase;
import mtr.block.BlockStationNameEntrance;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderStationNameBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RenderStationNameTiled<T extends BlockStationNameBase.TileEntityStationNameBase>
extends RenderStationNameBase<T> {
    private final boolean showLogo;

    public RenderStationNameTiled(BlockEntityRenderDispatcher dispatcher, boolean showLogo) {
        super(dispatcher);
        this.showLogo = showLogo;
    }

    @Override
    protected void drawStationName(BlockGetter world, BlockPos pos, BlockState state, Direction facing, PoseStack matrices, MultiBufferSource vertexConsumers, MultiBufferSource.BufferSource immediate, String stationName, int stationColor, int color, int light) {
        int lengthLeft = this.getLength(world, pos, false);
        int lengthRight = this.getLength(world, pos, true);
        if (this.showLogo) {
            if (lengthLeft == 1) {
                int propagateProperty = (Integer)IBlock.getStatePropertySafe(world, pos, BlockStationNameEntrance.STYLE);
                float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
                IDrawing.drawStringWithFont(matrices, Minecraft.m_91087_().f_91062_, immediate, IGui.insertTranslation("gui.mtr.station_cjk", "gui.mtr.station", 1, stationName), IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, ((float)lengthRight + logoSize) / 2.0f - 0.5f, 0.0f, (float)lengthRight - logoSize, logoSize - 0.125f, 40.0f / logoSize, propagateProperty < 2 || propagateProperty >= 4 ? -1 : -16777216, false, 0xF000F0, (x1, y1, x2, y2) -> {
                    VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getInterior(new ResourceLocation("mtr:textures/sign/logo.png")));
                    IDrawing.drawTexture(matrices, vertexConsumer, x1 - logoSize, -logoSize / 2.0f, logoSize, logoSize, facing, 0xF000F0);
                });
            }
        } else {
            int totalLength = lengthLeft + lengthRight - 1;
            IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getStationName((String)stationName, (float)((float)totalLength)).resourceLocation)), -0.5f, -0.5f, 1.0f, 1.0f, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
        }
    }

    private int getLength(BlockGetter world, BlockPos pos, boolean lookRight) {
        Block checkBlock;
        if (world == null) {
            return 1;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(world, pos, BlockStationNameBase.f_54117_);
        Block thisBlock = world.m_8055_(pos).m_60734_();
        int length = 1;
        while ((checkBlock = world.m_8055_(pos.m_5484_(lookRight ? facing.m_122427_() : facing.m_122428_(), length)).m_60734_()) instanceof BlockStationNameBase && checkBlock == thisBlock) {
            ++length;
        }
        return length;
    }
}

