/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import mtr.block.BlockNode;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.Rail;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RenderSignalBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    protected final boolean isSingleSided;

    public RenderSignalBase(BlockEntityRenderDispatcher dispatcher, boolean isSingleSided) {
        super(dispatcher);
        this.isSingleSided = isSingleSided;
    }

    public final void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BlockSignalLightBase) && !(state.m_60734_() instanceof BlockSignalSemaphoreBase)) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        BlockPos startPos = RenderSignalBase.getNodePos((BlockGetter)world, pos, facing);
        if (startPos == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        for (int i = 0; i < 2; ++i) {
            Direction newFacing = i == 1 ? facing.m_122424_() : facing;
            boolean isOccupied = false;
            boolean render = false;
            Map<BlockPos, Rail> railMap = ClientData.RAILS.get(startPos);
            if (railMap != null) {
                for (BlockPos endPos : railMap.keySet()) {
                    if (!railMap.get((Object)endPos).facingStart.similarFacing(newFacing.m_122435_() + 90.0f)) continue;
                    render = true;
                    if (!ClientData.SIGNAL_BLOCKS.isOccupied(PathData.getRailProduct(startPos, endPos))) continue;
                    isOccupied = true;
                    break;
                }
            }
            if (render) {
                matrices.m_85836_();
                matrices.m_85845_(Vector3f.f_122224_.m_122240_(newFacing.m_122435_()));
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
                this.render(matrices, vertexConsumers, vertexConsumer, entity, tickDelta, newFacing, isOccupied, i == 1);
                matrices.m_85849_();
            }
            if (this.isSingleSided) break;
        }
        matrices.m_85849_();
    }

    protected abstract void render(PoseStack var1, MultiBufferSource var2, VertexConsumer var3, T var4, float var5, Direction var6, boolean var7, boolean var8);

    private static BlockPos getNodePos(BlockGetter world, BlockPos pos, Direction facing) {
        int[] checkDistance;
        for (int z : checkDistance = new int[]{0, 1, -1, 2, -2, 3, -3, 4, -4}) {
            for (int x : checkDistance) {
                for (int y = -5; y <= 0; ++y) {
                    BlockPos checkPos = pos.m_6630_(y).m_5484_(facing.m_122427_(), x).m_5484_(facing, z);
                    BlockState checkState = world.m_8055_(checkPos);
                    if (!(checkState.m_60734_() instanceof BlockNode)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

