/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;

public class RenderDrivingOverlay
implements IGui {
    private static int accelerationSign;
    private static float doorValue;
    private static float speed;
    private static String thisStation;
    private static String nextStation;
    private static String thisRoute;
    private static String lastStation;
    private static int coolDown;
    private static final int HOT_BAR_WIDTH = 182;
    private static final int HOT_BAR_HEIGHT = 22;

    public static void render(Object matrices) {
        RenderDrivingOverlay.render((PoseStack)matrices);
    }

    public static void render(PoseStack matrices) {
        if (coolDown > 0) {
            --coolDown;
        } else {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        Window window = client.m_91268_();
        if (window == null || player == null) {
            return;
        }
        matrices.m_85836_();
        RenderSystem.m_69478_();
        UtilitiesClient.beginDrawingTexture(new ResourceLocation("textures/gui/widgets.png"));
        int startX = (window.m_85445_() - 182) / 2;
        int startY = window.m_85446_() - (player.m_7500_() ? 47 : 63);
        GuiComponent.m_93143_((PoseStack)matrices, (int)startX, (int)startY, (int)0, (float)0.0f, (float)0.0f, (int)61, (int)22, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(startX + 61), (int)startY, (int)0, (float)141.0f, (float)0.0f, (int)41, (int)22, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(startX + 120), (int)startY, (int)0, (float)0.0f, (float)0.0f, (int)21, (int)22, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(startX + 141), (int)startY, (int)0, (float)141.0f, (float)0.0f, (int)41, (int)22, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(startX + 39 + Math.max(accelerationSign, -2) * 20), (int)(startY - 1), (int)0, (float)0.0f, (float)22.0f, (int)24, (int)24, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(startX + (doorValue > 0.0f ? (doorValue < 1.0f ? 139 : 159) : 119)), (int)(startY - 1), (int)0, (float)0.0f, (float)22.0f, (int)24, (int)24, (int)256, (int)256);
        client.f_91062_.m_92750_(matrices, "B2", (float)startX + 5.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == -2 ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, "B1", (float)startX + 25.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == -1 ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, "N", (float)startX + 48.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == 0 ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, "P1", (float)startX + 65.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == 1 ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, "P2", (float)startX + 85.5f, (float)startY + 7.5f, doorValue == 0.0f && accelerationSign == 2 ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, "DC", (float)startX + 125.5f, (float)startY + 7.5f, speed == 0.0f && doorValue == 0.0f ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, String.valueOf((float)Math.round(doorValue * 10.0f) / 10.0f), (float)startX + 144.5f, (float)startY + 7.5f, doorValue > 0.0f && doorValue < 1.0f ? -1 : -10066330);
        client.f_91062_.m_92750_(matrices, "DO", (float)startX + 165.5f, (float)startY + 7.5f, speed == 0.0f && doorValue == 1.0f ? -1 : -10066330);
        String speedText = RailwayData.round(speed * 3.6f, 1) + " km/h";
        client.f_91062_.m_92750_(matrices, speedText, (float)(startX - client.f_91062_.m_92895_(speedText) - 6), (float)window.m_85446_() - 14.5f, -1);
        if (thisStation != null) {
            client.f_91062_.m_92750_(matrices, thisStation, (float)(startX + 182 + 6), (float)window.m_85446_() - 44.5f, -1);
        }
        if (nextStation != null) {
            client.f_91062_.m_92750_(matrices, "> " + nextStation, (float)(startX + 182 + 6), (float)window.m_85446_() - 34.5f, -1);
        }
        if (thisRoute != null) {
            client.f_91062_.m_92750_(matrices, thisRoute, (float)(startX + 182 + 6), (float)window.m_85446_() - 19.5f, -1);
        }
        if (lastStation != null) {
            client.f_91062_.m_92750_(matrices, "> " + lastStation, (float)(startX + 182 + 6), (float)window.m_85446_() - 9.5f, -1);
        }
        RenderSystem.m_69461_();
        matrices.m_85849_();
    }

    public static void setData(int accelerationSign, float doorValue, float speed, int stopIndex, List<Long> routeIds) {
        RenderDrivingOverlay.accelerationSign = accelerationSign;
        RenderDrivingOverlay.doorValue = doorValue;
        coolDown = 2;
        RenderDrivingOverlay.speed = speed;
        RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
            String string = RenderDrivingOverlay.thisStation = thisStation == null ? null : IGui.formatStationName(thisStation.name);
            RenderDrivingOverlay.nextStation = nextStation == null ? (nextRoute == null ? null : IGui.formatStationName(nextRoute.name)) : IGui.formatStationName(nextStation.name);
            RenderDrivingOverlay.thisRoute = thisRoute == null ? null : IGui.formatStationName(thisRoute.name);
            RenderDrivingOverlay.lastStation = lastStation == null ? null : IGui.formatStationName(lastStation.name);
        });
    }
}

