/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.block.BlockAPGGlass;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderRouteBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderAPGGlass
extends RenderRouteBase<BlockAPGGlass.TileEntityAPGGlass> {
    private static final float COLOR_STRIP_START = 0.75f;
    private static final float COLOR_STRIP_END = 0.78125f;

    public RenderAPGGlass(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher, 4.0f, 8.0f, false, (Property<Integer>)BlockAPGGlass.ARROW_DIRECTION);
        this.bottomPadding = 0.25f;
        this.topPadding = 0.5f;
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(BlockGetter world, BlockPos pos, BlockState state) {
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.LOWER) {
            return RenderRouteBase.RenderType.NONE;
        }
        if (Math.floorMod(pos.m_123341_(), 8) < 4 == Math.floorMod(pos.m_123343_(), 8) < 4) {
            return RenderRouteBase.RenderType.ARROW;
        }
        return RenderRouteBase.RenderType.ROUTE;
    }

    @Override
    protected void renderAdditional(PoseStack matrices, MultiBufferSource vertexConsumers, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            VertexConsumer vertexConsumer1 = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getColorStrip((long)platformId).resourceLocation));
            IDrawing.drawTexture(matrices, vertexConsumer1, isLeft ? this.sidePadding : 0.0f, 0.75f, 0.0f, isRight ? 1.0f - this.sidePadding : 1.0f, 0.78125f, 0.0f, facing, color, light);
            IDrawing.drawTexture(matrices, vertexConsumer1, isRight ? 1.0f - this.sidePadding : 1.0f, 0.75f, 0.125f, isLeft ? this.sidePadding : 0.0f, 0.78125f, 0.125f, facing, color, light);
            float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
            float height = 1.0f - this.topPadding - this.bottomPadding;
            VertexConsumer vertexConsumer2 = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getSingleRowStationName((long)platformId, (float)(width / height)).resourceLocation));
            IDrawing.drawTexture(matrices, vertexConsumer2, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), this.topPadding, 0.125f, leftBlocks == 0 ? this.sidePadding : 0.0f, 1.0f - this.bottomPadding, 0.125f, ((float)rightBlocks - (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)leftBlocks + (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing, color, light);
        }
    }
}

