/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import mtr.MTRClient;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.data.IGui;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelBogie;
import mtr.model.ModelCableCarGrip;
import mtr.model.ModelTrainBase;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import mtr.render.TrainRendererBase;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class JonModelTrainRenderer
extends TrainRendererBase
implements IGui {
    private final TrainClient train;
    public final ModelTrainBase model;
    public final String textureId;
    public final String gangwayConnectionId;
    public final String trainBarrierId;
    private static final EntityModel<Minecart> MODEL_MINECART = UtilitiesClient.getMinecartModel();
    private static final EntityModel<Boat> MODEL_BOAT = UtilitiesClient.getBoatModel();
    private static final Map<Long, FakeBoat> BOATS = new HashMap<Long, FakeBoat>();
    private static final ModelCableCarGrip MODEL_CABLE_CAR_GRIP = new ModelCableCarGrip();
    private static final ModelBogie MODEL_BOGIE = new ModelBogie();

    private JonModelTrainRenderer(ModelTrainBase model, String textureId, String gangwayConnectionId, String trainBarrierId, TrainClient train) {
        this.model = model;
        this.textureId = JonModelTrainRenderer.resolvePath(textureId);
        this.gangwayConnectionId = JonModelTrainRenderer.resolvePath(gangwayConnectionId);
        this.trainBarrierId = JonModelTrainRenderer.resolvePath(trainBarrierId);
        this.train = train;
    }

    public JonModelTrainRenderer(ModelTrainBase model, String textureId, String gangwayConnectionId, String trainBarrierId) {
        this(model, textureId, gangwayConnectionId, trainBarrierId, null);
    }

    @Override
    public TrainRendererBase createTrainInstance(TrainClient train) {
        return new JonModelTrainRenderer(this.model, this.textureId, this.gangwayConnectionId, this.trainBarrierId, train);
    }

    @Override
    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean isTranslucentBatch, float doorLeftValue, float doorRightValue, boolean opening, boolean head1IsFront) {
        String trainId = this.train.trainId;
        TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId);
        if (this.model == null && isTranslucentBatch) {
            return;
        }
        BlockPos posAverage = this.getPosAverage(this.train, x, y, z);
        if (posAverage == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(x, y, z);
        matrices.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI + yaw));
        matrices.m_85845_(Vector3f.f_122223_.m_122270_((float)Math.PI + (this.train.transportMode.hasPitch ? pitch : 0.0f)));
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        if (this.model == null || this.textureId == null) {
            boolean isBoat = this.train.transportMode == TransportMode.BOAT;
            matrices.m_85837_(0.0, isBoat ? 0.875 : 0.5, 0.0);
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            EntityModel<Boat> model = isBoat ? MODEL_BOAT : MODEL_MINECART;
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(model.m_103119_(this.resolveTexture(this.textureId, textureId -> textureId + ".png")));
            if (isBoat) {
                if (!BOATS.containsKey(this.train.id)) {
                    BOATS.put(this.train.id, new FakeBoat());
                }
                MODEL_BOAT.m_6973_((Entity)BOATS.get(this.train.id), (this.train.getSpeed() + 0.01f) * (doorLeftValue == 0.0f && doorRightValue == 0.0f ? lastFrameDuration : 0.0f), 0.0f, -0.1f, 0.0f, 0.0f);
            } else {
                model.m_6973_(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            }
            model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            boolean renderDetails = MTRClient.isReplayMod() || posAverage.m_123331_((Vec3i)camera.m_90588_()) <= 1024.0;
            this.model.render(matrices, vertexConsumers, this.resolveTexture(this.textureId, textureId -> textureId + ".png"), light, doorLeftValue, doorRightValue, opening, carIndex, this.train.trainCars, head1IsFront, this.train.getIsOnRoute(), isTranslucentBatch, renderDetails);
            if (trainProperties.bogiePosition != 0.0f && !isTranslucentBatch) {
                if (trainProperties.isJacobsBogie) {
                    if (carIndex == 0) {
                        MODEL_BOGIE.render(matrices, vertexConsumers, light, -((int)(trainProperties.bogiePosition * 16.0f)));
                    } else if (carIndex == this.train.trainCars - 1) {
                        MODEL_BOGIE.render(matrices, vertexConsumers, light, (int)(trainProperties.bogiePosition * 16.0f));
                    }
                } else {
                    MODEL_BOGIE.render(matrices, vertexConsumers, light, (int)(trainProperties.bogiePosition * 16.0f));
                    MODEL_BOGIE.render(matrices, vertexConsumers, light, -((int)(trainProperties.bogiePosition * 16.0f)));
                }
            }
        }
        if (this.train.transportMode == TransportMode.CABLE_CAR && !isTranslucentBatch) {
            matrices.m_85837_(0.0, (double)TransportMode.CABLE_CAR.railOffset + 0.5, 0.0);
            if (!this.train.transportMode.hasPitch) {
                matrices.m_85845_(Vector3f.f_122223_.m_122270_(pitch));
            }
            if (trainId.endsWith("_rht")) {
                matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            MODEL_CABLE_CAR_GRIP.render(matrices, vertexConsumers, light);
        }
        matrices.m_85849_();
        matrices.m_85849_();
    }

    @Override
    public void renderConnection(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
        BlockPos posAverage = this.getPosAverage(this.train, x, y, z);
        if (posAverage == null) {
            return;
        }
        String trainId = this.train.trainId;
        TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId);
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        if (!this.gangwayConnectionId.isEmpty()) {
            VertexConsumer vertexConsumerExterior = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(this.getConnectorTextureString(true, "exterior")));
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, light);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, light);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos3, prevPos2, light);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos1, thisPos4, thisPos1, prevPos4, light);
            int lightOnLevel = this.train.getIsOnRoute() ? 0xF000B0 : light;
            VertexConsumer vertexConsumerSide = vertexConsumers.m_6299_(MoreRenderLayers.getInterior(this.getConnectorTextureString(true, "side")));
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerSide, thisPos3, prevPos2, prevPos1, thisPos4, lightOnLevel);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumerSide, prevPos3, thisPos2, thisPos1, prevPos4, lightOnLevel);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getInterior(this.getConnectorTextureString(true, "roof"))), prevPos2, thisPos3, thisPos2, prevPos3, lightOnLevel);
            JonModelTrainRenderer.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getInterior(this.getConnectorTextureString(true, "floor"))), prevPos4, thisPos1, thisPos4, prevPos1, lightOnLevel);
        }
        if (trainProperties.isJacobsBogie) {
            matrices.m_85836_();
            matrices.m_85837_(x, y, z);
            matrices.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI + yaw));
            matrices.m_85845_(Vector3f.f_122223_.m_122270_((float)Math.PI + (this.train.transportMode.hasPitch ? pitch : 0.0f)));
            MODEL_BOGIE.render(matrices, vertexConsumers, light, 0);
            matrices.m_85849_();
        }
        matrices.m_85849_();
    }

    @Override
    public void renderBarrier(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
        if (StringUtils.isEmpty((CharSequence)this.trainBarrierId)) {
            return;
        }
        BlockPos posAverage = this.getPosAverage(this.train, x, y, z);
        if (posAverage == null) {
            return;
        }
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        VertexConsumer vertexConsumerExterior = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(this.getConnectorTextureString(false, "exterior")));
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, light);
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, light);
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, thisPos3, prevPos2, prevPos1, thisPos4, light);
        JonModelTrainRenderer.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos1, prevPos4, light);
        matrices.m_85849_();
    }

    @Override
    public void renderRidingPlayer(UUID playerId, Vec3 playerPositionOffset) {
        BlockPos posAverage = this.getPosAverage(this.train, playerPositionOffset.f_82479_, playerPositionOffset.f_82480_, playerPositionOffset.f_82481_);
        if (posAverage == null) {
            return;
        }
        matrices.m_85837_(0.0, 1000.0, 0.0);
        Player renderPlayer = world.m_46003_(playerId);
        if (renderPlayer != null && (!playerId.equals(player.m_142081_()) || camera.m_90594_())) {
            entityRenderDispatcher.m_114384_((Entity)renderPlayer, playerPositionOffset.f_82479_, playerPositionOffset.f_82480_, playerPositionOffset.f_82481_, 0.0f, 1.0f, matrices, vertexConsumers, 0xF000F0);
        }
        matrices.m_85849_();
    }

    public ResourceLocation resolveTexture(String textureId, Function<String, String> formatter) {
        boolean available;
        String textureString = formatter.apply(textureId);
        ResourceLocation id = new ResourceLocation(textureString);
        if (!RenderTrains.AVAILABLE_TEXTURES.contains(textureString) && !RenderTrains.UNAVAILABLE_TEXTURES.contains(textureString)) {
            available = UtilitiesClient.hasResource(id);
            (available ? RenderTrains.AVAILABLE_TEXTURES : RenderTrains.UNAVAILABLE_TEXTURES).add(textureString);
            if (!available) {
                System.out.println("Texture " + textureString + " not found, using default");
            }
        } else {
            available = RenderTrains.AVAILABLE_TEXTURES.contains(textureString);
        }
        if (available) {
            return id;
        }
        TrainRendererBase baseRenderer = TrainClientRegistry.getTrainProperties((String)this.train.baseTrainType).renderer;
        return new ResourceLocation(!(baseRenderer instanceof JonModelTrainRenderer) ? "mtr:textures/block/transparent.png" : formatter.apply(((JonModelTrainRenderer)baseRenderer).textureId));
    }

    private ResourceLocation getConnectorTextureString(boolean isConnector, String partName) {
        return this.resolveTexture(isConnector ? this.gangwayConnectionId : this.trainBarrierId, textureId -> String.format("%s_%s_%s.png", textureId, isConnector ? "connector" : "barrier", partName));
    }

    private static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, Vec3 pos1, Vec3 pos2, Vec3 pos3, Vec3 pos4, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, (float)pos1.f_82479_, (float)pos1.f_82480_, (float)pos1.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos3.f_82479_, (float)pos3.f_82480_, (float)pos3.f_82481_, (float)pos4.f_82479_, (float)pos4.f_82480_, (float)pos4.f_82481_, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -1, light);
    }

    private static String resolvePath(String path) {
        return path == null ? null : path.toLowerCase().split("\\.png")[0];
    }

    private static class FakeBoat
    extends Boat {
        private float progress;

        public FakeBoat() {
            super(EntityType.f_20552_, null);
        }

        public float m_38315_(int paddle, float newProgress) {
            this.progress += newProgress;
            return this.progress;
        }
    }
}

