/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.path.PathData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSignalModifier
extends ItemNodeModifierBase {
    private final DyeColor color;

    public ItemSignalModifier(boolean isConnector, DyeColor color) {
        super(true, false, isConnector);
        this.color = color;
    }

    @Override
    protected void onConnect(Level world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, Player player, RailwayData railwayData) {
        if (railwayData.containsRail(posStart, posEnd)) {
            PacketTrainDataGuiServer.createSignalS2C(world, railwayData.addSignal(this.color, posStart, posEnd), this.color, PathData.getRailProduct(posStart, posEnd));
        } else if (player != null) {
            player.m_5661_((Component)Text.translatable("gui.mtr.rail_not_found", new Object[0]), true);
        }
    }

    @Override
    protected void onRemove(Level world, BlockPos posStart, BlockPos posEnd, RailwayData railwayData) {
        PacketTrainDataGuiServer.removeSignalS2C(world, railwayData.removeSignal(this.color, posStart, posEnd), this.color, PathData.getRailProduct(posStart, posEnd));
    }
}

