/*
 * Decompiled with CFR 0.152.
 */
package mtr.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mtr.EntityTypes;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.IBlock;
import mtr.data.LiftInstructions;
import mtr.data.RailwayData;
import mtr.entity.EntityBase;
import mtr.mappings.Utilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class EntityLift
extends EntityBase {
    private LiftDirection liftDirection = LiftDirection.NONE;
    private double speed;
    private BlockPos trackPos = new BlockPos(0, 0, 0);
    private int scanCoolDown;
    private boolean doorOpen = true;
    private int doorValue = 24;
    private int trackCoolDown = 10;
    private int mountCoolDown;
    public final LiftInstructions liftInstructions = new LiftInstructions(instructionsString -> this.f_19804_.m_135381_(STOPPING_FLOORS, instructionsString));
    public final Map<Integer, String> floors = new HashMap<Integer, String>();
    public final EntityTypes.LiftType liftType;
    private static final int DOOR_MAX = 24;
    private static final int TRACK_COOL_DOWN_DEFAULT = 10;
    private static final int SCAN_COOL_DOWN_DEFAULT = 60;
    private static final float LIFT_WALKING_SPEED_MULTIPLIER = 0.25f;
    private static final EntityDataAccessor<Integer> DOOR_VALUE = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FRONT_OPEN = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BACK_OPEN = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DIRECTION = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> STOPPING_FLOORS = SynchedEntityData.m_135353_(EntityLift.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EntityLift(EntityTypes.LiftType liftType, EntityType<?> type, Level world) {
        super(type, world);
        this.liftType = liftType;
        this.f_19850_ = true;
    }

    public EntityLift(EntityTypes.LiftType liftType, Level world, double x, double y, double z) {
        this(liftType, liftType.registryObject.get(), world);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public void m_8119_() {
        if (!EntityLift.playerVerticallyNearby(this.f_19853_, this.m_142538_().m_123341_(), this.m_142538_().m_123343_())) {
            return;
        }
        BlockEntity blockEntity = this.f_19853_.m_7702_(this.trackPos);
        if (blockEntity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
            ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).setEntityLift(this);
            if (this.floors.isEmpty() || this.scanCoolDown >= 60) {
                ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).scanFloors(this.floors);
                this.scanCoolDown = 0;
            }
        }
        ++this.scanCoolDown;
        if (this.f_19853_.f_46443_) {
            this.setClientPosition();
        } else {
            if (this.liftInstructions.hasInstructions() && this.doorValue == 48) {
                this.doorOpen = false;
                this.liftInstructions.getTargetFloor(targetFloor -> this.f_19804_.m_135381_(DIRECTION, (Object)((double)targetFloor.intValue() > this.m_20186_() ? LiftDirection.UP : LiftDirection.DOWN).ordinal()));
            } else if (!this.liftInstructions.hasInstructions()) {
                this.f_19804_.m_135381_(DIRECTION, (Object)LiftDirection.NONE.ordinal());
            }
            if (this.floors.isEmpty() && this.scanCoolDown >= 60) {
                this.doorOpen = false;
                this.doorValue = 0;
                this.f_19804_.m_135381_(DOOR_VALUE, (Object)0);
                int currentFloor = (int)Math.round(this.m_20186_());
                this.liftInstructions.addInstruction(currentFloor, true, currentFloor + 1);
            }
            if (!this.doorOpen && this.doorValue == 0) {
                this.liftInstructions.getTargetFloor(targetFloor -> {
                    double stoppingDistance = Math.abs((double)targetFloor.intValue() - this.m_20186_());
                    LiftDirection liftDirection = stoppingDistance < (double)0.01f ? LiftDirection.NONE : (this.liftDirection = (double)targetFloor.intValue() > this.m_20186_() ? LiftDirection.UP : LiftDirection.DOWN);
                    if (this.liftDirection == LiftDirection.NONE) {
                        this.speed = 0.0;
                        this.doorOpen = true;
                        this.m_20334_(0.0, 0.0, 0.0);
                        this.m_6034_(this.m_20185_(), targetFloor.intValue(), this.m_20189_());
                        this.liftInstructions.arrived();
                        if (blockEntity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor && ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getShouldDing()) {
                            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12216_, SoundSource.BLOCKS, 16.0f, 2.0f);
                        }
                    } else {
                        this.speed = stoppingDistance < 0.5 * this.speed * this.speed / (double)0.01f ? Math.max(this.speed - 0.5 * this.speed * this.speed / stoppingDistance, (double)0.01f) : Math.min(this.speed + (double)0.01f, 1.0);
                        double velocity = this.speed * (double)this.liftDirection.speedMultiplier;
                        this.m_20334_(0.0, velocity, 0.0);
                        this.m_6034_(this.m_20185_(), this.m_20186_() + velocity, this.m_20189_());
                    }
                });
            } else if (!this.doorOpen && this.doorValue > 0 || this.doorOpen && this.doorValue < 48 || this.f_19853_.m_45930_((Entity)this, 8.0) != null) {
                this.doorValue = this.doorOpen ? Math.min(this.doorValue + 1, 48) : Math.max(this.doorValue - 1, 0);
                this.f_19804_.m_135381_(DOOR_VALUE, (Object)this.doorValue);
                this.f_19804_.m_135381_(FRONT_OPEN, (Object)this.checkDoor(true));
                if (this.liftType.isDoubleSided) {
                    this.f_19804_.m_135381_(BACK_OPEN, (Object)this.checkDoor(false));
                }
            }
            if (this.trackCoolDown == 0) {
                this.m_6074_();
            } else {
                --this.trackCoolDown;
            }
        }
        this.m_20101_();
    }

    public void m_6123_(Player player) {
        if (!this.f_19853_.f_46443_) {
            boolean hasPassenger = this.m_20363_((Entity)player);
            if (this.playerInBounds((Entity)player)) {
                if (!hasPassenger) {
                    player.m_20329_((Entity)this);
                    this.mountCoolDown = 10;
                }
            } else if (this.mountCoolDown == 0 && hasPassenger) {
                player.m_8127_();
            }
            if (this.mountCoolDown > 0) {
                --this.mountCoolDown;
            }
        }
    }

    public void m_7332_(Entity entity) {
        if (entity instanceof Player && this.m_20363_(entity)) {
            Vec3 movement = new Vec3((double)(Math.signum(((Player)entity).f_20900_) * 0.25f), 0.0, (double)(Math.signum(((Player)entity).f_20902_) * 0.25f)).m_82524_((float)(-Math.toRadians(Utilities.getYaw(entity))));
            double movementX = Mth.m_14008_((double)(entity.m_20185_() - this.m_20185_() + movement.f_82479_), (double)(this.getNegativeXBound(true) + 0.5), (double)(this.getPositiveXBound(true) - 0.5));
            double movementZ = Mth.m_14008_((double)(entity.m_20189_() - this.m_20189_() + movement.f_82481_), (double)(this.getNegativeZBound(true) + 0.5), (double)(this.getPositiveZBound(true) - 0.5));
            entity.m_6034_(this.m_20185_() + movementX, this.m_20186_(), this.m_20189_() + movementZ);
        } else {
            entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        return livingEntity.m_20182_().m_82520_(0.0, this.playerInBounds((Entity)livingEntity) ? (this.liftDirection == LiftDirection.UP ? this.speed : 0.0) + 3.0 : 0.0, 0.0);
    }

    protected boolean m_7310_(Entity entity) {
        return !this.m_20363_(entity);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DOOR_VALUE, (Object)24);
        this.f_19804_.m_135372_(FRONT_OPEN, (Object)false);
        this.f_19804_.m_135372_(BACK_OPEN, (Object)false);
        this.f_19804_.m_135372_(DIRECTION, (Object)0);
        this.f_19804_.m_135372_(STOPPING_FLOORS, (Object)"");
    }

    public LiftDirection getLiftDirection() {
        return this.liftDirection;
    }

    public void pressLiftButton(int floor) {
        this.liftInstructions.addInstruction((int)Math.round(this.m_20186_()), this.liftDirection == LiftDirection.UP, floor);
    }

    public int getFrontDoorValueClient() {
        return (Boolean)this.f_19804_.m_135370_(FRONT_OPEN) != false ? Math.min(24, (Integer)this.f_19804_.m_135370_(DOOR_VALUE)) : 0;
    }

    public int getBackDoorValueClient() {
        return this.liftType.isDoubleSided && (Boolean)this.f_19804_.m_135370_(BACK_OPEN) != false ? Math.min(24, (Integer)this.f_19804_.m_135370_(DOOR_VALUE)) : 0;
    }

    public LiftDirection getLiftDirectionClient() {
        return LiftDirection.values()[Math.abs((Integer)this.f_19804_.m_135370_(DIRECTION)) % LiftDirection.values().length];
    }

    public boolean hasStoppingFloorsClient(int floor, boolean movingUp) {
        return ((String)this.f_19804_.m_135370_(STOPPING_FLOORS)).contains(LiftInstructions.getStringPart(floor, movingUp));
    }

    public void updateByTrack(BlockPos pos) {
        this.trackCoolDown = 10;
        this.trackPos = new BlockPos((double)pos.m_123341_(), (double)Math.round(this.m_20186_()), (double)pos.m_123343_());
    }

    public void hasButton(int floor, boolean[] hasButton) {
        this.floors.keySet().forEach(checkFloor -> {
            if (checkFloor > floor) {
                hasButton[0] = true;
            }
            if (checkFloor < floor) {
                hasButton[1] = true;
            }
        });
    }

    public String[] getCurrentFloorDisplay() {
        String[] result = new String[]{"", ""};
        String[] resultTemp = this.floors.keySet().stream().min(Comparator.comparingInt(a -> (int)Math.abs(this.m_20186_() - (double)a.intValue()))).map(this.floors::get).orElse("").split("\\|\\|");
        System.arraycopy(resultTemp, 0, result, 0, Math.min(resultTemp.length, 2));
        return result;
    }

    private double getNegativeXBound(boolean includeDoorCheck) {
        switch ((Math.round(Utilities.getYaw(this)) + 360) % 360) {
            case 0: 
            case 180: {
                return (double)(-this.liftType.width) / 2.0;
            }
            case 90: {
                return (double)(this.getFrontDoorValueClient() > 0 && includeDoorCheck ? -5 : 0) - (double)this.liftType.depth / 2.0;
            }
            case 270: {
                return (double)(this.getBackDoorValueClient() > 0 && includeDoorCheck ? -5 : 0) - (double)this.liftType.depth / 2.0;
            }
        }
        return 0.0;
    }

    private double getNegativeZBound(boolean includeDoorCheck) {
        switch ((Math.round(Utilities.getYaw(this)) + 360) % 360) {
            case 0: {
                return (double)(this.getFrontDoorValueClient() > 0 && includeDoorCheck ? -5 : 0) - (double)this.liftType.depth / 2.0;
            }
            case 180: {
                return (double)(this.getBackDoorValueClient() > 0 && includeDoorCheck ? -5 : 0) - (double)this.liftType.depth / 2.0;
            }
            case 90: 
            case 270: {
                return (double)(-this.liftType.width) / 2.0;
            }
        }
        return 0.0;
    }

    private double getPositiveXBound(boolean includeDoorCheck) {
        switch ((Math.round(Utilities.getYaw(this)) + 360) % 360) {
            case 0: 
            case 180: {
                return (double)this.liftType.width / 2.0;
            }
            case 90: {
                return (double)(this.getBackDoorValueClient() > 0 && includeDoorCheck ? 5 : 0) + (double)this.liftType.depth / 2.0;
            }
            case 270: {
                return (double)(this.getFrontDoorValueClient() > 0 && includeDoorCheck ? 5 : 0) + (double)this.liftType.depth / 2.0;
            }
        }
        return 0.0;
    }

    private double getPositiveZBound(boolean includeDoorCheck) {
        switch ((Math.round(Utilities.getYaw(this)) + 360) % 360) {
            case 0: {
                return (double)(this.getBackDoorValueClient() > 0 && includeDoorCheck ? 5 : 0) + (double)this.liftType.depth / 2.0;
            }
            case 180: {
                return (double)(this.getFrontDoorValueClient() > 0 && includeDoorCheck ? 5 : 0) + (double)this.liftType.depth / 2.0;
            }
            case 90: 
            case 270: {
                return (double)this.liftType.width / 2.0;
            }
        }
        return 0.0;
    }

    private boolean checkDoor(boolean front) {
        Direction direction = Direction.m_122364_((double)(-Utilities.getYaw(this)));
        Direction directionClockwise = direction.m_122427_();
        int sign = front ? 1 : -1;
        boolean hasDoor = false;
        for (int i = -1; i <= 1; ++i) {
            BlockPos checkPos = new BlockPos(this.m_20182_().m_82520_((double)(-direction.m_122429_() * sign) * ((double)((float)this.liftType.depth / 2.0f) + 0.5) + (double)(directionClockwise.m_122429_() * i), 0.0, (double)(-direction.m_122431_() * sign) * ((double)((float)this.liftType.depth / 2.0f) + 0.5) + (double)(directionClockwise.m_122431_() * i)));
            BlockEntity entity1 = this.f_19853_.m_7702_(checkPos);
            BlockEntity entity2 = this.f_19853_.m_7702_(checkPos.m_7494_());
            if (!(entity1 instanceof BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase) || !(entity2 instanceof BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase) || !((Boolean)IBlock.getStatePropertySafe((BlockGetter)this.f_19853_, this.m_142538_(), BlockPSDAPGDoorBase.UNLOCKED)).booleanValue()) continue;
            ((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity1).setOpen(Math.min(this.doorValue, 24));
            ((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity2).setOpen(Math.min(this.doorValue, 24));
            hasDoor = true;
        }
        return hasDoor;
    }

    private boolean playerInBounds(Entity entity) {
        return RailwayData.isBetween(entity.m_20185_() - this.m_20185_(), this.getNegativeXBound(false), this.getPositiveXBound(false)) && RailwayData.isBetween(entity.m_20189_() - this.m_20189_(), this.getNegativeZBound(false), this.getPositiveZBound(false));
    }

    public static boolean playerVerticallyNearby(Level world, int x, int z) {
        for (Player player : world.m_6907_()) {
            int differenceZ;
            int differenceX = Math.abs(player.m_142538_().m_123341_() - x);
            if (differenceX + (differenceZ = Math.abs(player.m_142538_().m_123343_() - z)) > 16) continue;
            return true;
        }
        return false;
    }

    public static enum LiftDirection {
        NONE(0),
        UP(1),
        DOWN(-1);

        private final int speedMultiplier;

        private LiftDirection(int speedMultiplier) {
            this.speedMultiplier = speedMultiplier;
        }
    }

    public static class EntityLift44DoubleSided
    extends EntityLift {
        public EntityLift44DoubleSided(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_4_4_DOUBLE_SIDED, type, world);
        }

        public EntityLift44DoubleSided(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_4_4_DOUBLE_SIDED, world, x, y, z);
        }
    }

    public static class EntityLift44
    extends EntityLift {
        public EntityLift44(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_4_4, type, world);
        }

        public EntityLift44(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_4_4, world, x, y, z);
        }
    }

    public static class EntityLift43DoubleSided
    extends EntityLift {
        public EntityLift43DoubleSided(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_4_3_DOUBLE_SIDED, type, world);
        }

        public EntityLift43DoubleSided(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_4_3_DOUBLE_SIDED, world, x, y, z);
        }
    }

    public static class EntityLift43
    extends EntityLift {
        public EntityLift43(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_4_3, type, world);
        }

        public EntityLift43(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_4_3, world, x, y, z);
        }
    }

    public static class EntityLift33DoubleSided
    extends EntityLift {
        public EntityLift33DoubleSided(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_3_3_DOUBLE_SIDED, type, world);
        }

        public EntityLift33DoubleSided(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_3_3_DOUBLE_SIDED, world, x, y, z);
        }
    }

    public static class EntityLift33
    extends EntityLift {
        public EntityLift33(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_3_3, type, world);
        }

        public EntityLift33(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_3_3, world, x, y, z);
        }
    }

    public static class EntityLift32DoubleSided
    extends EntityLift {
        public EntityLift32DoubleSided(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_3_2_DOUBLE_SIDED, type, world);
        }

        public EntityLift32DoubleSided(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_3_2_DOUBLE_SIDED, world, x, y, z);
        }
    }

    public static class EntityLift32
    extends EntityLift {
        public EntityLift32(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_3_2, type, world);
        }

        public EntityLift32(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_3_2, world, x, y, z);
        }
    }

    public static class EntityLift22DoubleSided
    extends EntityLift {
        public EntityLift22DoubleSided(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_2_2_DOUBLE_SIDED, type, world);
        }

        public EntityLift22DoubleSided(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_2_2_DOUBLE_SIDED, world, x, y, z);
        }
    }

    public static class EntityLift22
    extends EntityLift {
        public EntityLift22(EntityType<?> type, Level world) {
            super(EntityTypes.LiftType.SIZE_2_2, type, world);
        }

        public EntityLift22(Level world, double x, double y, double z) {
            super(EntityTypes.LiftType.SIZE_2_2, world, x, y, z);
        }
    }
}

