/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.IReducedSaveData;
import mtr.data.MessagePackHelper;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.RailwayDataDriveTrainModule;
import mtr.data.SavedRailBase;
import mtr.data.ScheduleEntry;
import mtr.data.SignalBlocks;
import mtr.data.TrainDelay;
import mtr.data.TrainServer;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import mtr.path.PathData;
import mtr.path.PathFinder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class Siding
extends SavedRailBase
implements IPacket,
IReducedSaveData {
    private Level world;
    private Depot depot;
    private String trainId;
    private String baseTrainType;
    private int trainCars;
    private boolean unlimitedTrains;
    private int maxTrains;
    private boolean isManual;
    private int maxManualSpeed;
    private int repeatIndex1;
    private int repeatIndex2;
    private float accelerationConstant;
    private final float railLength;
    private final List<PathData> path = new ArrayList<PathData>();
    private final List<Double> distances = new ArrayList<Double>();
    private final List<TimeSegment> timeSegments = new ArrayList<TimeSegment>();
    private final Map<Long, Map<Long, Float>> platformTimes = new HashMap<Long, Map<Long, Float>>();
    private final Set<TrainServer> trains = new HashSet<TrainServer>();
    private static final String KEY_RAIL_LENGTH = "rail_length";
    private static final String KEY_BASE_TRAIN_TYPE = "train_type";
    private static final String KEY_TRAIN_ID = "train_custom_id";
    private static final String KEY_UNLIMITED_TRAINS = "unlimited_trains";
    private static final String KEY_MAX_TRAINS = "max_trains";
    private static final String KEY_IS_MANUAL = "is_manual";
    private static final String KEY_MAX_MANUAL_SPEED = "max_manual_speed";
    private static final String KEY_PATH = "path";
    private static final String KEY_REPEAT_INDEX_1 = "repeat_index_1";
    private static final String KEY_REPEAT_INDEX_2 = "repeat_index_2";
    private static final String KEY_TRAINS = "trains";
    private static final String KEY_ACCELERATION_CONSTANT = "acceleration_constant";

    public Siding(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2, float railLength) {
        super(id, transportMode, pos1, pos2);
        this.railLength = railLength;
        this.setTrainDetails();
        this.unlimitedTrains = transportMode.continuousMovement;
        this.accelerationConstant = transportMode.continuousMovement ? 0.05f : 0.01f;
    }

    public Siding(TransportMode transportMode, BlockPos pos1, BlockPos pos2, float railLength) {
        super(transportMode, pos1, pos2);
        this.railLength = railLength;
        this.setTrainDetails();
        this.unlimitedTrains = transportMode.continuousMovement;
        this.accelerationConstant = transportMode.continuousMovement ? 0.05f : 0.01f;
    }

    public Siding(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.railLength = messagePackHelper.getFloat(KEY_RAIL_LENGTH);
        this.setTrainDetails(messagePackHelper.getString(KEY_TRAIN_ID), messagePackHelper.getString(KEY_BASE_TRAIN_TYPE));
        this.unlimitedTrains = this.transportMode.continuousMovement || messagePackHelper.getBoolean(KEY_UNLIMITED_TRAINS);
        this.maxTrains = messagePackHelper.getInt(KEY_MAX_TRAINS);
        this.isManual = messagePackHelper.getBoolean(KEY_IS_MANUAL);
        this.maxManualSpeed = messagePackHelper.getInt(KEY_MAX_MANUAL_SPEED);
        this.repeatIndex1 = messagePackHelper.getInt(KEY_REPEAT_INDEX_1);
        this.repeatIndex2 = messagePackHelper.getInt(KEY_REPEAT_INDEX_2);
        float tempAccelerationConstant = RailwayData.round(messagePackHelper.getFloat(KEY_ACCELERATION_CONSTANT, 0.01f), 3);
        this.accelerationConstant = this.transportMode.continuousMovement ? 0.05f : (tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant);
        messagePackHelper.iterateArrayValue(KEY_PATH, pathSection -> this.path.add(new PathData(RailwayData.castMessagePackValueToSKMap(pathSection))));
        this.generateTimeSegments(this.path, this.timeSegments, this.platformTimes);
        messagePackHelper.iterateArrayValue(KEY_TRAINS, value -> this.trains.add(new TrainServer(this.id, this.railLength, this.timeSegments, this.path, this.distances, this.repeatIndex1, this.repeatIndex2, this.accelerationConstant, this.isManual, this.maxManualSpeed, this.dwellTime, RailwayData.castMessagePackValueToSKMap(value))));
        this.generateDistances();
    }

    @Deprecated
    public Siding(CompoundTag compoundTag) {
        super(compoundTag);
        this.railLength = compoundTag.m_128457_(KEY_RAIL_LENGTH);
        this.setTrainDetails(compoundTag.m_128461_(KEY_TRAIN_ID), compoundTag.m_128461_(KEY_BASE_TRAIN_TYPE));
        this.unlimitedTrains = this.transportMode.continuousMovement || compoundTag.m_128471_(KEY_UNLIMITED_TRAINS);
        this.maxTrains = compoundTag.m_128451_(KEY_MAX_TRAINS);
        this.isManual = compoundTag.m_128471_(KEY_IS_MANUAL);
        this.maxManualSpeed = compoundTag.m_128451_(KEY_MAX_MANUAL_SPEED);
        this.repeatIndex1 = compoundTag.m_128451_(KEY_REPEAT_INDEX_1);
        this.repeatIndex2 = compoundTag.m_128451_(KEY_REPEAT_INDEX_2);
        this.accelerationConstant = this.transportMode.continuousMovement ? 0.05f : 0.01f;
        CompoundTag tagPath = compoundTag.m_128469_(KEY_PATH);
        int pathCount = tagPath.m_128431_().size();
        for (int i = 0; i < pathCount; ++i) {
            this.path.add(new PathData(tagPath.m_128469_(KEY_PATH + i)));
        }
        this.generateTimeSegments(this.path, this.timeSegments, this.platformTimes);
        CompoundTag tagTrains = compoundTag.m_128469_(KEY_TRAINS);
        tagTrains.m_128431_().forEach(key -> this.trains.add(new TrainServer(this.id, this.railLength, this.timeSegments, this.path, this.distances, this.repeatIndex1, this.repeatIndex2, this.accelerationConstant, this.isManual, this.maxManualSpeed, this.dwellTime, tagTrains.m_128469_(key))));
        this.generateDistances();
    }

    public Siding(FriendlyByteBuf packet) {
        super(packet);
        this.railLength = packet.readFloat();
        this.setTrainDetails(packet.m_130136_(Short.MAX_VALUE), packet.m_130136_(Short.MAX_VALUE));
        this.unlimitedTrains = packet.readBoolean() || this.transportMode.continuousMovement;
        this.maxTrains = packet.readInt();
        this.isManual = packet.readBoolean();
        this.maxManualSpeed = packet.readInt();
        float tempAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
        this.accelerationConstant = this.transportMode.continuousMovement ? 0.05f : (tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant);
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        this.toReducedMessagePack(messagePacker);
        RailwayData.writeMessagePackDataset(messagePacker, this.trains, KEY_TRAINS);
    }

    @Override
    public void toReducedMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_RAIL_LENGTH).packFloat(this.railLength);
        messagePacker.packString(KEY_TRAIN_ID).packString(this.trainId);
        messagePacker.packString(KEY_BASE_TRAIN_TYPE).packString(this.baseTrainType);
        messagePacker.packString(KEY_UNLIMITED_TRAINS).packBoolean(this.unlimitedTrains);
        messagePacker.packString(KEY_MAX_TRAINS).packInt(this.maxTrains);
        messagePacker.packString(KEY_IS_MANUAL).packBoolean(this.isManual);
        messagePacker.packString(KEY_MAX_MANUAL_SPEED).packInt(this.maxManualSpeed);
        messagePacker.packString(KEY_REPEAT_INDEX_1).packInt(this.repeatIndex1);
        messagePacker.packString(KEY_REPEAT_INDEX_2).packInt(this.repeatIndex2);
        messagePacker.packString(KEY_ACCELERATION_CONSTANT).packFloat(this.accelerationConstant);
        RailwayData.writeMessagePackDataset(messagePacker, this.path, KEY_PATH);
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 12;
    }

    @Override
    public int reducedMessagePackLength() {
        return this.messagePackLength() - 1;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        super.writePacket(packet);
        packet.writeFloat(this.railLength);
        packet.m_130070_(this.trainId);
        packet.m_130070_(this.baseTrainType);
        packet.writeBoolean(this.unlimitedTrains);
        packet.writeInt(this.maxTrains);
        packet.writeBoolean(this.isManual);
        packet.writeInt(this.maxManualSpeed);
        packet.writeFloat(this.accelerationConstant);
    }

    @Override
    public void update(String key, FriendlyByteBuf packet) {
        switch (key) {
            case "train_type": {
                this.setTrainDetails(packet.m_130136_(Short.MAX_VALUE), packet.m_130136_(Short.MAX_VALUE));
                this.trains.clear();
                break;
            }
            case "unlimited_trains": {
                this.name = packet.m_130136_(Short.MAX_VALUE);
                this.color = packet.readInt();
                this.dwellTime = packet.readInt();
                this.dwellTime = this.transportMode.continuousMovement ? 1 : this.dwellTime;
                this.unlimitedTrains = packet.readBoolean() || this.transportMode.continuousMovement;
                this.maxTrains = packet.readInt();
                this.isManual = packet.readBoolean();
                this.maxManualSpeed = packet.readInt();
                float newAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
                float f = this.accelerationConstant = this.transportMode.continuousMovement ? 0.05f : newAccelerationConstant;
                if (!packet.readBoolean()) break;
                this.trains.clear();
                break;
            }
            default: {
                super.update(key, packet);
            }
        }
    }

    public void setTrainIdAndBaseType(String customId, String trainType, Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_BASE_TRAIN_TYPE);
        packet.m_130070_(customId);
        packet.m_130070_(trainType);
        sendPacket.accept(packet);
        this.setTrainDetails(customId, trainType);
    }

    public void setUnlimitedTrains(boolean unlimitedTrains, int maxTrains, boolean isManual, int maxManualSpeed, float accelerationConstant, int newDwellTime, boolean clearTrains, Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_UNLIMITED_TRAINS);
        packet.m_130070_(this.name);
        packet.writeInt(this.color);
        this.writeDwellTimePacket(packet, newDwellTime);
        packet.writeBoolean(unlimitedTrains);
        packet.writeInt(maxTrains);
        packet.writeBoolean(isManual);
        packet.writeInt(maxManualSpeed);
        float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
        packet.writeFloat(tempAccelerationConstant);
        packet.writeBoolean(clearTrains);
        sendPacket.accept(packet);
        this.unlimitedTrains = this.transportMode.continuousMovement || unlimitedTrains;
        this.maxTrains = maxTrains;
        this.isManual = isManual;
        this.maxManualSpeed = maxManualSpeed;
        float f = this.accelerationConstant = this.transportMode.continuousMovement ? 0.05f : tempAccelerationConstant;
        if (clearTrains) {
            this.trains.clear();
        }
    }

    public String getTrainId() {
        return this.trainId;
    }

    public float getAccelerationConstant() {
        return this.accelerationConstant;
    }

    public void setSidingData(Level world, Depot depot, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        this.world = world;
        this.depot = depot;
        if (depot == null) {
            this.trains.clear();
            this.path.clear();
            this.distances.clear();
        } else {
            if (this.path.isEmpty()) {
                this.generateDefaultPath(rails);
                this.generateDistances();
            }
            depot.platformTimes.clear();
            depot.platformTimes.putAll(this.platformTimes);
        }
    }

    public int generateRoute(MinecraftServer minecraftServer, List<PathData> mainPath, int successfulSegmentsMain, Map<BlockPos, Map<BlockPos, Rail>> rails, SavedRailBase firstPlatform, SavedRailBase lastPlatform, boolean repeatInfinitely) {
        int tempRepeatIndex2;
        int tempRepeatIndex1;
        int successfulSegments;
        ArrayList<PathData> tempPath = new ArrayList<PathData>();
        if (firstPlatform == null || lastPlatform == null) {
            successfulSegments = 0;
            tempRepeatIndex1 = 0;
            tempRepeatIndex2 = 0;
        } else {
            ArrayList<SavedRailBase> depotAndFirstPlatform = new ArrayList<SavedRailBase>();
            depotAndFirstPlatform.add(this);
            depotAndFirstPlatform.add(firstPlatform);
            PathFinder.findPath(tempPath, rails, depotAndFirstPlatform, 0);
            if (tempPath.isEmpty()) {
                successfulSegments = 1;
                tempRepeatIndex1 = 0;
                tempRepeatIndex2 = 0;
            } else if (mainPath.isEmpty()) {
                tempPath.clear();
                successfulSegments = successfulSegmentsMain + 1;
                tempRepeatIndex1 = 0;
                tempRepeatIndex2 = 0;
            } else {
                tempRepeatIndex1 = repeatInfinitely ? tempPath.size() - (((PathData)tempPath.get(tempPath.size() - 1)).isOppositeRail(mainPath.get(0)) ? 0 : 1) : 0;
                PathFinder.appendPath(tempPath, mainPath);
                ArrayList<SavedRailBase> lastPlatformAndDepot = new ArrayList<SavedRailBase>();
                lastPlatformAndDepot.add(lastPlatform);
                lastPlatformAndDepot.add(this);
                ArrayList<PathData> pathLastPlatformToDepot = new ArrayList<PathData>();
                PathFinder.findPath(pathLastPlatformToDepot, rails, lastPlatformAndDepot, successfulSegmentsMain);
                if (pathLastPlatformToDepot.isEmpty()) {
                    successfulSegments = successfulSegmentsMain + 1;
                    tempPath.clear();
                    tempRepeatIndex2 = 0;
                } else {
                    tempRepeatIndex2 = repeatInfinitely ? tempPath.size() - 1 : 0;
                    PathFinder.appendPath(tempPath, pathLastPlatformToDepot);
                    successfulSegments = successfulSegmentsMain + 2;
                }
            }
        }
        ArrayList<TimeSegment> tempTimeSegments = new ArrayList<TimeSegment>();
        HashMap<Long, Map<Long, Float>> tempPlatformTimes = new HashMap<Long, Map<Long, Float>>();
        this.generateTimeSegments(tempPath, tempTimeSegments, tempPlatformTimes);
        minecraftServer.execute(() -> {
            try {
                this.path.clear();
                if (tempPath.isEmpty()) {
                    this.generateDefaultPath(rails);
                } else {
                    this.path.addAll(tempPath);
                }
                this.timeSegments.clear();
                this.timeSegments.addAll(tempTimeSegments);
                this.platformTimes.clear();
                this.platformTimes.putAll(tempPlatformTimes);
                this.generateDistances();
                if (tempRepeatIndex1 != this.repeatIndex1 || tempRepeatIndex2 != this.repeatIndex2) {
                    this.trains.clear();
                }
                this.repeatIndex1 = tempRepeatIndex1;
                this.repeatIndex2 = tempRepeatIndex2;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return successfulSegments;
    }

    public void simulateTrain(DataCache dataCache, RailwayDataDriveTrainModule railwayDataDriveTrainModule, List<Map<UUID, Long>> trainPositions, SignalBlocks signalBlocks, Map<Player, Set<TrainServer>> trainsInPlayerRange, Set<TrainServer> trainsToSync, Map<Long, List<ScheduleEntry>> schedulesForPlatform, Map<Long, Map<BlockPos, TrainDelay>> trainDelays) {
        if (this.depot == null) {
            return;
        }
        int trainsAtDepot = 0;
        boolean spawnTrain = true;
        HashSet<Long> railProgressSet = new HashSet<Long>();
        HashSet<TrainServer> trainsToRemove = new HashSet<TrainServer>();
        for (TrainServer train : this.trains) {
            long roundedRailProgress;
            if (train.isCurrentlyManual() && railwayDataDriveTrainModule.drive(train)) {
                trainsToSync.add(train);
            }
            if (train.simulateTrain(this.world, 1.0f, this.depot, dataCache, trainPositions, trainsInPlayerRange, schedulesForPlatform, trainDelays)) {
                trainsToSync.add(train);
            }
            if (train.closeToDepot(train.spacing * this.trainCars)) {
                spawnTrain = false;
            }
            if (!train.getIsOnRoute() && ++trainsAtDepot > 1) {
                trainsToRemove.add(train);
            }
            if (railProgressSet.contains(roundedRailProgress = Math.round(train.getRailProgress() * 10.0))) {
                trainsToRemove.add(train);
            }
            railProgressSet.add(roundedRailProgress);
            if (trainPositions == null || this.transportMode.continuousMovement) continue;
            train.writeTrainPositions(trainPositions, signalBlocks);
        }
        if (this.trainCars > 0 && (this.trains.isEmpty() || spawnTrain && (this.unlimitedTrains || this.trains.size() <= this.maxTrains))) {
            TrainServer train = new TrainServer(this.unlimitedTrains || this.maxTrains > 0 ? new Random().nextLong() : this.id, this.id, this.railLength, this.trainId, this.baseTrainType, this.trainCars, this.path, this.distances, this.repeatIndex1, this.repeatIndex2, this.accelerationConstant, this.timeSegments, this.isManual, this.maxManualSpeed, this.dwellTime);
            this.trains.add(train);
        }
        if (!trainsToRemove.isEmpty()) {
            trainsToRemove.forEach(this.trains::remove);
        }
    }

    public int getMaxTrains() {
        return this.maxTrains;
    }

    public boolean getIsManual() {
        return this.isManual;
    }

    public int getMaxManualSpeed() {
        return this.maxManualSpeed;
    }

    public boolean getUnlimitedTrains() {
        return this.unlimitedTrains;
    }

    public void clearTrains() {
        this.trains.clear();
    }

    private void setTrainDetails() {
        for (TrainType trainType : TrainType.values()) {
            if (TrainType.getTransportMode(trainType.baseTrainType) != this.transportMode) continue;
            this.setTrainDetails(trainType.toString(), trainType.baseTrainType);
            return;
        }
        this.setTrainDetails(TrainType.values()[0].toString(), TrainType.values()[0].baseTrainType);
    }

    private void setTrainDetails(String trainId, String baseTrainType) {
        String baseTrainType2 = baseTrainType.startsWith("base_") ? baseTrainType.replace("base_", "train_") : baseTrainType;
        this.baseTrainType = baseTrainType2.toLowerCase();
        this.trainId = trainId.isEmpty() ? this.baseTrainType : trainId.toLowerCase();
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(this.railLength / (float)TrainType.getSpacing(baseTrainType) + 0.01f));
    }

    private void generateDefaultPath(Map<BlockPos, Map<BlockPos, Rail>> rails) {
        this.trains.clear();
        List<BlockPos> orderedPositions = this.getOrderedPositions(new BlockPos(0, 0, 0), false);
        BlockPos pos1 = orderedPositions.get(0);
        BlockPos pos2 = orderedPositions.get(1);
        if (RailwayData.containsRail(rails, pos1, pos2)) {
            this.path.add(new PathData(rails.get(pos1).get(pos2), this.id, 0, pos1, pos2, -1));
        }
        this.trains.add(new TrainServer(this.id, this.id, this.railLength, this.trainId, this.baseTrainType, this.trainCars, this.path, this.distances, this.repeatIndex1, this.repeatIndex2, this.accelerationConstant, this.timeSegments, this.isManual, this.maxManualSpeed, this.dwellTime));
    }

    private void generateDistances() {
        this.distances.clear();
        double distanceSum = 0.0;
        for (PathData pathData : this.path) {
            this.distances.add(distanceSum += pathData.rail.getLength());
        }
        if (this.path.size() != 1) {
            this.trains.removeIf(train -> train.id == this.id == this.unlimitedTrains);
        }
    }

    private void generateTimeSegments(List<PathData> path, List<TimeSegment> timeSegments, Map<Long, Map<Long, Float>> platformTimes) {
        timeSegments.clear();
        double distanceSum1 = 0.0;
        ArrayList<Double> stoppingDistances = new ArrayList<Double>();
        for (PathData pathData : path) {
            distanceSum1 += pathData.rail.getLength();
            if (pathData.dwellTime <= 0) continue;
            stoppingDistances.add(distanceSum1);
        }
        int spacing = TrainType.getSpacing(this.baseTrainType);
        double railProgress = (this.railLength + (float)(this.trainCars * spacing)) / 2.0f;
        double nextStoppingDistance = 0.0;
        float speed = 0.0f;
        float time = 0.0f;
        float timeOld = 0.0f;
        long savedRailBaseIdOld = 0L;
        double distanceSum2 = 0.0;
        for (int i = 0; i < path.size(); ++i) {
            if (railProgress >= nextStoppingDistance) {
                nextStoppingDistance = stoppingDistances.isEmpty() ? distanceSum1 : (Double)stoppingDistances.remove(0);
            }
            PathData pathData = path.get(i);
            float railSpeed = pathData.rail.railType.canAccelerate ? pathData.rail.railType.maxBlocksPerTick : Math.max(speed, RailType.getDefaultMaxBlocksPerTick(this.transportMode));
            distanceSum2 += pathData.rail.getLength();
            while (railProgress < distanceSum2) {
                int speedChange;
                if (speed > railSpeed || nextStoppingDistance - railProgress + 1.0 < 0.5 * (double)speed * (double)speed / (double)this.accelerationConstant) {
                    speed = Math.max(speed - this.accelerationConstant, this.accelerationConstant);
                    speedChange = -1;
                } else if (speed < railSpeed) {
                    speed = Math.min(speed + this.accelerationConstant, railSpeed);
                    speedChange = 1;
                } else {
                    speedChange = 0;
                }
                if (timeSegments.isEmpty() || timeSegments.get((int)(timeSegments.size() - 1)).speedChange != speedChange) {
                    timeSegments.add(new TimeSegment(railProgress, speed, time, speedChange, this.accelerationConstant));
                }
                railProgress = Math.min(railProgress + (double)speed, distanceSum2);
                TimeSegment timeSegment = timeSegments.get(timeSegments.size() - 1);
                timeSegment.endRailProgress = railProgress;
                timeSegment.endTime = time += 1.0f;
                timeSegment.savedRailBaseId = nextStoppingDistance != distanceSum1 && railProgress == distanceSum2 && pathData.dwellTime > 0 ? pathData.savedRailBaseId : 0L;
            }
            time += (float)(pathData.dwellTime * 5);
            if (pathData.savedRailBaseId != 0L) {
                if (savedRailBaseIdOld != 0L) {
                    if (!platformTimes.containsKey(savedRailBaseIdOld)) {
                        platformTimes.put(savedRailBaseIdOld, new HashMap());
                    }
                    platformTimes.get(savedRailBaseIdOld).put(pathData.savedRailBaseId, Float.valueOf(time - timeOld));
                }
                savedRailBaseIdOld = pathData.savedRailBaseId;
                timeOld = time;
            }
            time += (float)(pathData.dwellTime * 5);
            if (i + 1 >= path.size() || !pathData.isOppositeRail(path.get(i + 1))) continue;
            railProgress += (double)(spacing * this.trainCars);
        }
    }

    public static class TimeSegment {
        public double endRailProgress;
        public long savedRailBaseId;
        public long routeId;
        public int currentStationIndex;
        public float endTime;
        public final double startRailProgress;
        private final float startSpeed;
        private final float startTime;
        private final int speedChange;
        private final float accelerationConstant;

        private TimeSegment(double startRailProgress, float startSpeed, float startTime, int speedChange, float accelerationConstant) {
            this.startRailProgress = startRailProgress;
            this.startSpeed = startSpeed;
            this.startTime = startTime;
            this.speedChange = Integer.compare(speedChange, 0);
            float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
            this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        }

        public double getTime(double railProgress) {
            double distance = railProgress - this.startRailProgress;
            if (this.speedChange == 0) {
                return (double)this.startTime + distance / (double)this.startSpeed;
            }
            float acceleration = (float)this.speedChange * this.accelerationConstant;
            return (double)this.startTime + (distance == 0.0 ? 0.0 : (Math.sqrt((double)(2.0f * acceleration) * distance + (double)(this.startSpeed * this.startSpeed)) - (double)this.startSpeed) / (double)acceleration);
        }
    }
}

