/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.data.Depot;
import mtr.data.IReducedSaveData;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.data.Route;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TrainDelay;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;

public class RailwayDataFileSaveModule
extends RailwayDataModuleBase {
    private boolean canAutoSave = false;
    private boolean dataLoaded = false;
    private boolean useReducedHash = true;
    private int filesWritten;
    private int filesDeleted;
    private long autoSaveStartMillis;
    private final SignalBlocks signalBlocks;
    private final List<Long> dirtyStationIds = new ArrayList<Long>();
    private final List<Long> dirtyPlatformIds = new ArrayList<Long>();
    private final List<Long> dirtySidingIds = new ArrayList<Long>();
    private final List<Long> dirtyRouteIds = new ArrayList<Long>();
    private final List<Long> dirtyDepotIds = new ArrayList<Long>();
    private final List<BlockPos> dirtyRailPositions = new ArrayList<BlockPos>();
    private final List<SignalBlocks.SignalBlock> dirtySignalBlocks = new ArrayList<SignalBlocks.SignalBlock>();
    private final Map<Path, Integer> existingFiles = new HashMap<Path, Integer>();
    private final List<Path> checkFilesToDelete = new ArrayList<Path>();
    private final Path stationsPath;
    private final Path platformsPath;
    private final Path sidingsPath;
    private final Path routesPath;
    private final Path depotsPath;
    private final Path railsPath;
    private final Path signalBlocksPath;

    public RailwayDataFileSaveModule(RailwayData railwayData, Level world, Map<BlockPos, Map<BlockPos, Rail>> rails, SignalBlocks signalBlocks) {
        super(railwayData, world, rails);
        this.signalBlocks = signalBlocks;
        ResourceLocation dimensionLocation = world.m_46472_().m_135782_();
        Path savePath = ((ServerLevel)world).m_142572_().m_129843_(LevelResource.f_78182_).resolve("mtr").resolve(dimensionLocation.m_135827_()).resolve(dimensionLocation.m_135815_());
        this.stationsPath = savePath.resolve("stations");
        this.platformsPath = savePath.resolve("platforms");
        this.sidingsPath = savePath.resolve("sidings");
        this.routesPath = savePath.resolve("routes");
        this.depotsPath = savePath.resolve("depots");
        this.railsPath = savePath.resolve("rails");
        this.signalBlocksPath = savePath.resolve("signal-blocks");
        try {
            Files.createDirectories(this.stationsPath, new FileAttribute[0]);
            Files.createDirectories(this.platformsPath, new FileAttribute[0]);
            Files.createDirectories(this.sidingsPath, new FileAttribute[0]);
            Files.createDirectories(this.routesPath, new FileAttribute[0]);
            Files.createDirectories(this.depotsPath, new FileAttribute[0]);
            Files.createDirectories(this.railsPath, new FileAttribute[0]);
            Files.createDirectories(this.signalBlocksPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        this.existingFiles.clear();
        this.readMessagePackFromFile(this.stationsPath, Station::new, this.railwayData.stations::add, false);
        this.readMessagePackFromFile(this.platformsPath, Platform::new, this.railwayData.platforms::add, true);
        this.readMessagePackFromFile(this.sidingsPath, Siding::new, this.railwayData.sidings::add, true);
        this.readMessagePackFromFile(this.routesPath, Route::new, this.railwayData.routes::add, false);
        this.readMessagePackFromFile(this.depotsPath, Depot::new, this.railwayData.depots::add, false);
        this.readMessagePackFromFile(this.railsPath, RailEntry::new, railEntry -> this.rails.put(railEntry.pos, railEntry.connections), true);
        this.readMessagePackFromFile(this.signalBlocksPath, SignalBlocks.SignalBlock::new, this.signalBlocks.signalBlocks::add, true);
        System.out.println("Minecraft Transit Railway data successfully loaded for " + this.world.m_46472_().m_135782_());
        this.canAutoSave = true;
        this.dataLoaded = true;
    }

    public void fullSave() {
        this.useReducedHash = false;
        this.dirtyStationIds.clear();
        this.dirtyPlatformIds.clear();
        this.dirtySidingIds.clear();
        this.dirtyRouteIds.clear();
        this.dirtyDepotIds.clear();
        this.dirtyRailPositions.clear();
        this.dirtySignalBlocks.clear();
        this.checkFilesToDelete.clear();
        this.autoSave();
        while (!this.autoSaveTick()) {
        }
        this.canAutoSave = false;
    }

    public void autoSave() {
        if (!this.dataLoaded) {
            this.dataLoaded = true;
            this.canAutoSave = true;
        }
        if (this.canAutoSave && this.checkFilesToDelete.isEmpty()) {
            this.autoSaveStartMillis = System.currentTimeMillis();
            this.filesWritten = 0;
            this.filesDeleted = 0;
            this.dirtyStationIds.addAll(this.railwayData.dataCache.stationIdMap.keySet());
            this.dirtyPlatformIds.addAll(this.railwayData.dataCache.platformIdMap.keySet());
            this.dirtySidingIds.addAll(this.railwayData.dataCache.sidingIdMap.keySet());
            this.dirtyRouteIds.addAll(this.railwayData.dataCache.routeIdMap.keySet());
            this.dirtyDepotIds.addAll(this.railwayData.dataCache.depotIdMap.keySet());
            this.dirtyRailPositions.addAll(this.rails.keySet());
            this.dirtySignalBlocks.addAll(this.signalBlocks.signalBlocks);
            this.checkFilesToDelete.addAll(this.existingFiles.keySet());
        }
    }

    public boolean autoSaveTick() {
        if (this.canAutoSave) {
            boolean doneWriting;
            boolean deleteEmptyOld = this.checkFilesToDelete.isEmpty();
            boolean hasSpareTime = this.writeDirtyDataToFile(this.dirtyStationIds, this.railwayData.dataCache.stationIdMap::get, id -> id, this.stationsPath);
            if (hasSpareTime) {
                hasSpareTime = this.writeDirtyDataToFile(this.dirtyPlatformIds, this.railwayData.dataCache.platformIdMap::get, id -> id, this.platformsPath);
            }
            if (hasSpareTime) {
                hasSpareTime = this.writeDirtyDataToFile(this.dirtySidingIds, this.railwayData.dataCache.sidingIdMap::get, id -> id, this.sidingsPath);
            }
            if (hasSpareTime) {
                hasSpareTime = this.writeDirtyDataToFile(this.dirtyRouteIds, this.railwayData.dataCache.routeIdMap::get, id -> id, this.routesPath);
            }
            if (hasSpareTime) {
                hasSpareTime = this.writeDirtyDataToFile(this.dirtyDepotIds, this.railwayData.dataCache.depotIdMap::get, id -> id, this.depotsPath);
            }
            if (hasSpareTime) {
                hasSpareTime = this.writeDirtyDataToFile(this.dirtyRailPositions, pos -> this.rails.containsKey(pos) ? new RailEntry((BlockPos)pos, (Map)this.rails.get(pos)) : null, BlockPos::m_121878_, this.railsPath);
            }
            if (hasSpareTime) {
                hasSpareTime = this.writeDirtyDataToFile(this.dirtySignalBlocks, signalBlock -> signalBlock, signalBlock -> signalBlock.id, this.signalBlocksPath);
            }
            boolean bl = doneWriting = this.dirtyStationIds.isEmpty() && this.dirtyPlatformIds.isEmpty() && this.dirtySidingIds.isEmpty() && this.dirtyRouteIds.isEmpty() && this.dirtyDepotIds.isEmpty() && this.dirtyRailPositions.isEmpty() && this.dirtySignalBlocks.isEmpty();
            if (hasSpareTime && !this.checkFilesToDelete.isEmpty() && doneWriting) {
                Path path = this.checkFilesToDelete.remove(0);
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.existingFiles.remove(path);
                ++this.filesDeleted;
            }
            if (!deleteEmptyOld && this.checkFilesToDelete.isEmpty()) {
                Map<Long, Map<BlockPos, TrainDelay>> trainDelays = this.railwayData.getTrainDelays();
                ArrayList routeIdsToRemove = new ArrayList();
                ArrayList posToRemove = new ArrayList();
                trainDelays.forEach((routeId, trainDelaysForRouteId) -> trainDelaysForRouteId.forEach((pos, trainDelay) -> {
                    if (trainDelay.isExpired()) {
                        routeIdsToRemove.add(routeId);
                        posToRemove.add(pos);
                    }
                }));
                if (!this.useReducedHash || this.filesWritten > 0 || this.filesDeleted > 0) {
                    System.out.println("Minecraft Transit Railway save complete for " + this.world.m_46472_().m_135782_() + " in " + (System.currentTimeMillis() - this.autoSaveStartMillis) / 1000L + " second(s)");
                    if (this.filesWritten > 0) {
                        System.out.println("- Changed: " + this.filesWritten);
                    }
                    if (this.filesDeleted > 0) {
                        System.out.println("- Deleted: " + this.filesDeleted);
                    }
                    if (!routeIdsToRemove.isEmpty()) {
                        System.out.println("- Delays Cleared: " + routeIdsToRemove.size());
                    }
                }
                for (int i = 0; i < routeIdsToRemove.size(); ++i) {
                    long routeId2 = (Long)routeIdsToRemove.get(i);
                    trainDelays.get(routeId2).remove(posToRemove.get(i));
                    if (!trainDelays.get(routeId2).isEmpty()) continue;
                    trainDelays.remove(routeId2);
                }
            }
            return doneWriting && this.checkFilesToDelete.isEmpty();
        }
        return true;
    }

    private <T extends SerializedDataBase> void readMessagePackFromFile(Path path, Function<Map<String, Value>, T> getData, Consumer<T> callback, boolean skipVerify) {
        try {
            Files.list(path).forEach(idFolder -> {
                try {
                    Files.list(idFolder).forEach(idFile -> {
                        try {
                            MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(Files.newInputStream(idFile, new OpenOption[0]));
                            int size = messageUnpacker.unpackMapHeader();
                            HashMap<String, ImmutableValue> result = new HashMap<String, ImmutableValue>(size);
                            for (int i = 0; i < size; ++i) {
                                result.put(messageUnpacker.unpackString(), messageUnpacker.unpackValue());
                            }
                            SerializedDataBase data = (SerializedDataBase)getData.apply(result);
                            if (skipVerify || !(data instanceof NameColorDataBase) || !((NameColorDataBase)data).name.isEmpty()) {
                                callback.accept(data);
                            }
                            this.existingFiles.put((Path)idFile, RailwayDataFileSaveModule.getHash(data, true));
                            messageUnpacker.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path writeMessagePackToFile(SerializedDataBase data, long id, Path path) {
        Path parentPath = path.resolve(String.valueOf(id % 100L));
        try {
            Files.createDirectories(parentPath, new FileAttribute[0]);
            Path dataPath = parentPath.resolve(String.valueOf(id));
            int hash = RailwayDataFileSaveModule.getHash(data, this.useReducedHash);
            if (!this.existingFiles.containsKey(dataPath) || hash != this.existingFiles.get(dataPath)) {
                MessagePacker messagePacker = MessagePack.newDefaultPacker(Files.newOutputStream(dataPath, StandardOpenOption.CREATE));
                messagePacker.packMapHeader(data.messagePackLength());
                data.toMessagePack(messagePacker);
                messagePacker.close();
                this.existingFiles.put(dataPath, hash);
                ++this.filesWritten;
            }
            return dataPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T extends SerializedDataBase, U> boolean writeDirtyDataToFile(List<U> dirtyData, Function<U, T> getId, Function<U, Long> idToLong, Path path) {
        long millis = System.currentTimeMillis();
        while (!dirtyData.isEmpty()) {
            Path newPath;
            U id = dirtyData.remove(0);
            SerializedDataBase data = (SerializedDataBase)getId.apply(id);
            if (data != null && (newPath = this.writeMessagePackToFile(data, idToLong.apply(id), path)) != null) {
                this.checkFilesToDelete.remove(newPath);
            }
            if (System.currentTimeMillis() - millis < 2L) continue;
            return false;
        }
        return true;
    }

    private static int getHash(SerializedDataBase data, boolean useReducedHash) {
        try {
            MessageBufferPacker messageBufferPacker = MessagePack.newDefaultBufferPacker();
            if (useReducedHash && data instanceof IReducedSaveData) {
                messageBufferPacker.packMapHeader(((IReducedSaveData)((Object)data)).reducedMessagePackLength());
                ((IReducedSaveData)((Object)data)).toReducedMessagePack(messageBufferPacker);
            } else {
                messageBufferPacker.packMapHeader(data.messagePackLength());
                data.toMessagePack(messageBufferPacker);
            }
            int hash = Arrays.hashCode(messageBufferPacker.toByteArray());
            messageBufferPacker.close();
            return hash;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static class RailEntry
    extends SerializedDataBase {
        public final BlockPos pos;
        public final Map<BlockPos, Rail> connections;
        private static final String KEY_NODE_POS = "node_pos";
        private static final String KEY_RAIL_CONNECTIONS = "rail_connections";

        public RailEntry(BlockPos pos, Map<BlockPos, Rail> connections) {
            this.pos = pos;
            this.connections = connections;
        }

        public RailEntry(Map<String, Value> map) {
            MessagePackHelper messagePackHelper = new MessagePackHelper(map);
            this.pos = BlockPos.m_122022_((long)messagePackHelper.getLong(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, Rail>();
            messagePackHelper.iterateArrayValue(KEY_RAIL_CONNECTIONS, value -> {
                Map<String, Value> mapSK = RailwayData.castMessagePackValueToSKMap(value);
                this.connections.put(BlockPos.m_122022_((long)new MessagePackHelper(mapSK).getLong(KEY_NODE_POS)), new Rail(mapSK));
            });
        }

        @Override
        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            messagePacker.packString(KEY_NODE_POS).packLong(this.pos.m_121878_());
            messagePacker.packString(KEY_RAIL_CONNECTIONS).packArrayHeader(this.connections.size());
            for (Map.Entry<BlockPos, Rail> entry : this.connections.entrySet()) {
                BlockPos endNodePos = entry.getKey();
                messagePacker.packMapHeader(entry.getValue().messagePackLength() + 1);
                messagePacker.packString(KEY_NODE_POS).packLong(endNodePos.m_121878_());
                entry.getValue().toMessagePack(messagePacker);
            }
        }

        @Override
        public int messagePackLength() {
            return 2;
        }

        @Override
        public void writePacket(FriendlyByteBuf packet) {
        }
    }
}

