/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import mtr.data.EnumHelper;
import mtr.data.MessagePackHelper;
import mtr.data.SerializedDataBase;
import mtr.data.TransportMode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class NameColorDataBase
extends SerializedDataBase
implements Comparable<NameColorDataBase> {
    public final long id;
    public final TransportMode transportMode;
    public String name;
    public int color;
    private static final String KEY_ID = "id";
    private static final String KEY_TRANSPORT_MODE = "transport_mode";
    private static final String KEY_NAME = "name";
    private static final String KEY_COLOR = "color";

    public NameColorDataBase() {
        this(0L);
    }

    public NameColorDataBase(long id) {
        this(id, TransportMode.TRAIN);
    }

    public NameColorDataBase(TransportMode transportMode) {
        this(0L, transportMode);
    }

    public NameColorDataBase(long id, TransportMode transportMode) {
        this.id = id == 0L ? new Random().nextLong() : id;
        this.transportMode = transportMode;
        this.name = "";
    }

    public NameColorDataBase(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.id = messagePackHelper.getLong(KEY_ID);
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, messagePackHelper.getString(KEY_TRANSPORT_MODE));
        this.name = messagePackHelper.getString(KEY_NAME);
        this.color = messagePackHelper.getInt(KEY_COLOR);
    }

    @Deprecated
    public NameColorDataBase(CompoundTag compoundTag) {
        this.id = compoundTag.m_128454_(KEY_ID);
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, compoundTag.m_128461_(KEY_TRANSPORT_MODE));
        this.name = compoundTag.m_128461_(KEY_NAME);
        this.color = compoundTag.m_128451_(KEY_COLOR);
    }

    public NameColorDataBase(FriendlyByteBuf packet) {
        this.id = packet.readLong();
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.m_130136_(Short.MAX_VALUE));
        this.name = packet.m_130136_(Short.MAX_VALUE).replace(" |", "|").replace("| ", "|");
        this.color = packet.readInt();
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_ID).packLong(this.id);
        messagePacker.packString(KEY_TRANSPORT_MODE).packString(this.transportMode.toString());
        messagePacker.packString(KEY_NAME).packString(this.name);
        messagePacker.packString(KEY_COLOR).packInt(this.color);
    }

    @Override
    public int messagePackLength() {
        return 4;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(this.name);
        packet.writeInt(this.color);
    }

    public void update(String key, FriendlyByteBuf packet) {
        if (key.equals(KEY_NAME)) {
            this.name = packet.m_130136_(Short.MAX_VALUE);
            this.color = packet.readInt();
        }
    }

    public void setNameColor(Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_NAME);
        packet.m_130070_(this.name);
        packet.writeInt(this.color);
        if (sendPacket != null) {
            sendPacket.accept(packet);
        }
    }

    public final boolean isTransportMode(TransportMode transportMode) {
        return !this.hasTransportMode() || this.transportMode == transportMode;
    }

    protected abstract boolean hasTransportMode();

    @Override
    public int compareTo(NameColorDataBase compare) {
        return (this.name.toLowerCase() + this.color).compareTo((compare.name + compare.color).toLowerCase());
    }
}

