/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mtr.data.AreaBase;
import mtr.data.Depot;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import net.minecraft.core.BlockPos;

public class DataCache {
    public final Map<Long, Station> stationIdMap = new HashMap<Long, Station>();
    public final Map<Long, Platform> platformIdMap = new HashMap<Long, Platform>();
    public final Map<Long, Siding> sidingIdMap = new HashMap<Long, Siding>();
    public final Map<Long, Route> routeIdMap = new HashMap<Long, Route>();
    public final Map<Long, Depot> depotIdMap = new HashMap<Long, Depot>();
    public final Map<Long, Station> platformIdToStation = new HashMap<Long, Station>();
    public final Map<Long, Depot> sidingIdToDepot = new HashMap<Long, Depot>();
    public final Map<Long, Depot> routeIdToOneDepot = new HashMap<Long, Depot>();
    public final Map<BlockPos, Station> blockPosToStation = new HashMap<BlockPos, Station>();
    public final Map<BlockPos, Long> blockPosToPlatformId = new HashMap<BlockPos, Long>();
    public final Map<BlockPos, Map<BlockPos, Integer>> platformConnections = new HashMap<BlockPos, Map<BlockPos, Integer>>();
    protected final Set<Station> stations;
    protected final Set<Platform> platforms;
    protected final Set<Siding> sidings;
    protected final Set<Route> routes;
    protected final Set<Depot> depots;

    public DataCache(Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots) {
        this.stations = stations;
        this.platforms = platforms;
        this.sidings = sidings;
        this.routes = routes;
        this.depots = depots;
    }

    public final void sync() {
        try {
            DataCache.mapIds(this.stationIdMap, this.stations);
            DataCache.mapIds(this.platformIdMap, this.platforms);
            DataCache.mapIds(this.sidingIdMap, this.sidings);
            DataCache.mapIds(this.routeIdMap, this.routes);
            DataCache.mapIds(this.depotIdMap, this.depots);
            this.routeIdToOneDepot.clear();
            this.routes.forEach(route -> route.platformIds.removeIf(platformId -> this.platformIdMap.get(platformId) == null));
            this.depots.forEach(depot -> {
                depot.routeIds.removeIf(routeId -> this.routeIdMap.get(routeId) == null);
                depot.routeIds.forEach(routeId -> this.routeIdToOneDepot.put((Long)routeId, (Depot)depot));
            });
            this.platformConnections.clear();
            this.routes.forEach(route -> {
                Depot depot = this.routeIdToOneDepot.get(route.id);
                if (depot != null) {
                    for (int i = 1; i < route.platformIds.size(); ++i) {
                        float duration;
                        long prevPlatformId = route.platformIds.get(i - 1);
                        long thisPlatformId = route.platformIds.get(i);
                        Platform prevPlatform = this.platformIdMap.get(prevPlatformId);
                        Platform thisPlatform = this.platformIdMap.get(thisPlatformId);
                        if (prevPlatform == null || thisPlatform == null || !((duration = DataCache.tryGet(depot.platformTimes, prevPlatformId, thisPlatformId, Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
                        DataCache.put(this.platformConnections, prevPlatform.getMidPos(), thisPlatform.getMidPos(), oldValue -> {
                            int newValue = Math.round(duration);
                            if (oldValue == null) {
                                return newValue;
                            }
                            return Math.min(oldValue, newValue);
                        });
                    }
                }
            });
            DataCache.mapSavedRailIdToStation(this.platformIdToStation, this.platforms, this.stations);
            DataCache.mapSavedRailIdToStation(this.sidingIdToDepot, this.sidings, this.depots);
            this.blockPosToPlatformId.clear();
            this.blockPosToStation.clear();
            this.syncAdditional();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void syncAdditional() {
    }

    public static <T, U> U tryGet(Map<T, Map<T, U>> map, T key1, T key2, U defaultValue) {
        U result = DataCache.tryGet(map, key1, key2);
        return result == null ? defaultValue : result;
    }

    public static <T, U> U tryGet(Map<T, Map<T, U>> map, T key1, T key2) {
        Map<T, U> innerMap = map.get(key1);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(key2);
    }

    public static <T, U> void put(Map<T, Map<T, U>> map, T key1, T key2, Function<U, U> putValue) {
        Map<T, U> newInnerMap;
        Map<T, U> innerMap = map.get(key1);
        if (innerMap == null) {
            newInnerMap = new HashMap<T, U>();
            map.put(key1, newInnerMap);
        } else {
            newInnerMap = innerMap;
        }
        newInnerMap.put(key2, putValue.apply(newInnerMap.get(key2)));
    }

    private static <U extends SavedRailBase, V extends AreaBase> void mapSavedRailIdToStation(Map<Long, V> map, Set<U> savedRails, Set<V> areas) {
        map.clear();
        savedRails.forEach(savedRail -> {
            BlockPos pos = savedRail.getMidPos();
            for (AreaBase area : areas) {
                if (!area.isTransportMode(savedRail.transportMode) || !area.inArea(pos.m_123341_(), pos.m_123343_())) continue;
                map.put(savedRail.id, area);
                break;
            }
        });
    }

    private static <U extends NameColorDataBase> void mapIds(Map<Long, U> map, Set<U> source) {
        map.clear();
        source.forEach(data -> map.put(data.id, data));
    }
}

