/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Station;
import mtr.mappings.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;

public class RouteMapGenerator
implements IGui {
    private static int scale;
    private static int lineSize;
    private static int lineSpacing;
    private static int fontSizeBig;
    private static int fontSizeSmall;
    private static final int MIN_VERTICAL_SIZE = 5;
    private static final String ARROW_RESOURCE = "textures/sign/arrow.png";
    private static final String CIRCLE_RESOURCE = "textures/sign/circle.png";
    private static final String TEMP_CIRCULAR_MARKER = "temp_circular_marker";

    public static void setConstants() {
        scale = (int)Math.pow(2.0, Config.dynamicTextureResolution() + 5);
        lineSize = scale / 8;
        lineSpacing = lineSize * 3 / 2;
        fontSizeBig = lineSize * 2;
        fontSizeSmall = fontSizeBig / 2;
    }

    public static DynamicTexture generateColorStrip(long platformId) {
        try {
            List<Integer> colors = RouteMapGenerator.getRouteStream(platformId, (route, currentStationIndex) -> {});
            if (colors.isEmpty()) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, 1, colors.size(), false);
            for (int i = 0; i < colors.size(); ++i) {
                RouteMapGenerator.drawPixelSafe(nativeImage, 0, i, 0xFF000000 | colors.get(i));
            }
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateStationName(String stationName, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int height = scale * 2;
            int width = Math.round((float)height * aspectRatio);
            int padding = scale / 16;
            int[] dimensions = new int[2];
            byte[] pixels = ClientData.DATA_CACHE.getTextPixels(stationName, dimensions, width - padding * 2, height - padding * 2, fontSizeBig * 2, fontSizeSmall * 2, padding, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            nativeImage.m_84997_(0, 0, width, height, 0);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateTallStationName(int textColor, String stationName, int stationColor, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int width = Math.round((float)scale * 1.6f);
            int height = Math.round((float)width / aspectRatio);
            int[] dimensions = new int[2];
            byte[] pixels = ClientData.DATA_CACHE.getTextPixels(IGui.formatVerticalChinese(stationName), dimensions, width, height, fontSizeBig * 2, fontSizeSmall * 2, 0, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            nativeImage.m_84997_(0, 0, width, height, 0);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0xFF000000 | stationColor, textColor, false);
            RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(0xFF000000 | stationColor));
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateSingleRowStationName(long platformId, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int[] dimensions = new int[2];
            byte[] pixels = ClientData.DATA_CACHE.getTextPixels(RouteMapGenerator.getStationName(platformId).replace("|", " | "), dimensions, fontSizeBig, fontSizeSmall);
            int padding = dimensions[1] / 2;
            int height = dimensions[1] + padding;
            int width = Math.max(Math.round((float)height * aspectRatio), dimensions[0] + padding);
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            nativeImage.m_84997_(0, 0, width, height, -1);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateSignText(String text, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        try {
            int height = scale;
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            int tilePadding = tileSize / 4;
            int[] dimensions = new int[2];
            byte[] pixels = ClientData.DATA_CACHE.getTextPixels(text, dimensions, Integer.MAX_VALUE, (int)((float)tileSize * 1.25f), tileSize * 3 / 5, tileSize * 3 / 10, tilePadding, horizontalAlignment);
            int width = dimensions[0] - tilePadding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(backgroundColor));
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        try {
            int padding = scale / 32;
            int[] dimensions = new int[2];
            byte[] pixels = ClientData.DATA_CACHE.getTextPixels(routeName, dimensions, Integer.MAX_VALUE, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f), fontSizeBig, fontSizeSmall, padding, horizontalAlignment);
            int width = dimensions[0] + padding * 2;
            int height = dimensions[1] + padding * 2;
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            nativeImage.m_84997_(0, 0, width, height, RouteMapGenerator.invertColor(0xFF000000 | color));
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int circleX;
            ArrayList<String> destinations = new ArrayList<String>();
            List<Integer> colors = RouteMapGenerator.getRouteStream(platformId, (route, currentStationIndex) -> destinations.add(ClientData.DATA_CACHE.getFormattedRouteDestination((Route)route, (int)currentStationIndex, TEMP_CIRCULAR_MARKER)));
            boolean isTerminating = destinations.isEmpty();
            boolean leftToRight = horizontalAlignment == IGui.HorizontalAlignment.CENTER ? hasLeft || !hasRight : horizontalAlignment != IGui.HorizontalAlignment.RIGHT;
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            ClientCache clientCache = ClientData.DATA_CACHE;
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            nativeImage.m_84997_(0, 0, width, height, RouteMapGenerator.invertColor(backgroundColor));
            if (isTerminating) {
                circleX = (int)horizontalAlignment.getOffset(0.0f, tileSize - width);
            } else {
                String destinationString = IGui.mergeStations(destinations);
                boolean noToString = destinationString.startsWith(TEMP_CIRCULAR_MARKER);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER, "")).isEmpty() && showToString && !noToString) {
                    destinationString = IGui.insertTranslation("gui.mtr.to_cjk", "gui.mtr.to", 1, destinationString);
                }
                int tilePadding = tileSize / 4;
                int leftSize = ((hasLeft ? 1 : 0) + (leftToRight ? 1 : 0)) * (tileSize + tilePadding);
                int rightSize = ((hasRight ? 1 : 0) + (leftToRight ? 0 : 1)) * (tileSize + tilePadding);
                int[] dimensionsDestination = new int[2];
                byte[] pixelsDestination = clientCache.getTextPixels(destinationString, dimensionsDestination, width - leftSize - rightSize - padding * (showToString ? 2 : 1), (int)((float)tileSize * 1.25f), tileSize * 3 / 5, tileSize * 3 / 10, tilePadding, leftToRight ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                int leftPadding = (int)horizontalAlignment.getOffset(0.0f, leftSize + rightSize + dimensionsDestination[0] - tilePadding * 2 - width);
                RouteMapGenerator.drawString(nativeImage, pixelsDestination, leftPadding + leftSize - tilePadding, height / 2, dimensionsDestination, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
                if (hasLeft) {
                    RouteMapGenerator.drawResource(nativeImage, ARROW_RESOURCE, leftPadding, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor);
                }
                if (hasRight) {
                    RouteMapGenerator.drawResource(nativeImage, ARROW_RESOURCE, leftPadding + leftSize + dimensionsDestination[0] - tilePadding * 2 + rightSize - tileSize, padding, tileSize, tileSize, true, 0.0f, 1.0f, textColor);
                }
                circleX = leftPadding + leftSize + (leftToRight ? -tileSize - tilePadding : dimensionsDestination[0] - tilePadding);
            }
            for (int i = 0; i < colors.size(); ++i) {
                RouteMapGenerator.drawResource(nativeImage, CIRCLE_RESOURCE, circleX, padding, tileSize, tileSize, false, (float)i / (float)colors.size(), ((float)i + 1.0f) / (float)colors.size(), colors.get(i));
            }
            Platform platform = (Platform)clientCache.platformIdMap.get(platformId);
            if (platform != null) {
                int[] dimensionsPlatformNumber = new int[2];
                byte[] pixelsPlatformNumber = clientCache.getTextPixels(platform.name, dimensionsPlatformNumber, tileSize, (int)((float)tileSize * 1.25f * 3.0f / 4.0f), tileSize * 3 / 4, tileSize * 3 / 4, 0, IGui.HorizontalAlignment.CENTER);
                RouteMapGenerator.drawString(nativeImage, pixelsPlatformNumber, circleX + tileSize / 2, padding + tileSize / 2, dimensionsPlatformNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            }
            if (transparentColor != 0) {
                RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(transparentColor));
            }
            return new DynamicTexture(nativeImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DynamicTexture generateRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            ArrayList routeDetails = new ArrayList();
            RouteMapGenerator.getRouteStream(platformId, (route, currentStationIndex) -> routeDetails.add(new Tuple(route, currentStationIndex)));
            int routeCount = routeDetails.size();
            if (routeCount > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                float yOffset;
                float extraPadding;
                float rawHeight;
                int routeIndex;
                ClientCache clientCache = ClientData.DATA_CACHE;
                ArrayList<List<Long>> stationsIdsBefore = new ArrayList<List<Long>>();
                ArrayList stationsIdsAfter = new ArrayList();
                ArrayList<Map<Integer, StationPosition>> stationPositions = new ArrayList<Map<Integer, StationPosition>>();
                int[] colorIndices = new int[routeCount];
                HashSet<Integer> currentRouteColors = new HashSet<Integer>();
                HashSet<String> currentRouteNames = new HashSet<String>();
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add(new ArrayList());
                    stationsIdsAfter.add(new ArrayList());
                    stationPositions.add(new HashMap());
                    Tuple routeDetail = (Tuple)routeDetails.get(routeIndex);
                    List<Long> platformIds = ((Route)routeDetail.m_14418_()).platformIds;
                    int currentIndex = (Integer)routeDetail.m_14419_();
                    for (int stationIndex = 0; stationIndex < platformIds.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId2 = RouteMapGenerator.getStationId(platformIds.get(stationIndex));
                        if (stationIndex < currentIndex) {
                            ((List)stationsIdsBefore.get(stationsIdsBefore.size() - 1)).add(0, stationId2);
                            continue;
                        }
                        ((List)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId2);
                    }
                    int color2 = ((Route)routeDetail.m_14418_()).color;
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                    currentRouteColors.add(color2);
                    currentRouteNames.add(((Route)routeDetail.m_14418_()).name.split("\\|\\|")[0]);
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Map)stationPositions.get(routeIndex)).put(0, new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                float[] bounds = new float[3];
                RouteMapGenerator.setup(stationPositions, flip ? stationsIdsBefore : stationsIdsAfter, colorIndices, bounds, flip, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup(stationPositions, flip ? stationsIdsAfter : stationsIdsBefore, colorIndices, bounds, !flip, false);
                float rawHeightPart = Math.abs(bounds[1]) + (vertical ? 0.6f : 1.0f);
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeightTotal = rawHeightPart + bounds[2] + (vertical ? 0.6f : 1.0f);
                if (vertical && rawHeightTotal < 5.0f) {
                    rawHeight = 5.0f;
                    extraPadding = (5.0f - rawHeightTotal) / 2.0f;
                    yOffset = rawHeightPart + extraPadding;
                } else {
                    rawHeight = rawHeightTotal;
                    extraPadding = 0.0f;
                    yOffset = rawHeightPart;
                }
                if (rawWidth / rawHeight > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeight / (float)scale;
                } else {
                    height = Math.round(rawHeight * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
                nativeImage.m_84997_(0, 0, width, height, -1);
                HashMap<Long, Set> stationPositionsGrouped = new HashMap<Long, Set>();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    Route route2 = (Route)((Tuple)routeDetails.get(routeIndex2)).m_14418_();
                    int currentIndex = (Integer)((Tuple)routeDetails.get(routeIndex2)).m_14419_();
                    Map routeStationPositions = (Map)stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < route2.platformIds.size(); ++stationIndex) {
                        long stationId3;
                        StationPosition stationPosition = (StationPosition)routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < route2.platformIds.size() - 1) {
                            RouteMapGenerator.drawLine(nativeImage, stationPosition, (StationPosition)routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, yOffset, stationIndex < currentIndex ? -5592406 : 0xFF000000 | route2.color);
                        }
                        if (!stationPositionsGrouped.containsKey(stationId3 = RouteMapGenerator.getStationId(route2.platformIds.get(stationIndex)))) {
                            stationPositionsGrouped.put(stationId3, new HashSet());
                        }
                        if (stationPosition.isCommon && !((Set)stationPositionsGrouped.get(stationId3)).stream().noneMatch(stationPosition2 -> stationPosition2.stationPosition.x == stationPosition.x)) continue;
                        Map<Integer, ClientCache.ColorNameTuple> interchangeRoutes = RouteMapGenerator.getInterchangeRoutes(stationId3);
                        ArrayList<Integer> allColors = new ArrayList<Integer>(interchangeRoutes.keySet());
                        allColors.sort(Integer::compareTo);
                        ArrayList<Integer> interchangeColors = new ArrayList<Integer>();
                        ArrayList<String> interchangeNames = new ArrayList<String>();
                        allColors.forEach(color -> {
                            String name = ((ClientCache.ColorNameTuple)interchangeRoutes.get((Object)color)).name;
                            if (!currentRouteColors.contains(color) && !currentRouteNames.contains(name)) {
                                if (!interchangeColors.contains(color)) {
                                    interchangeColors.add((Integer)color);
                                }
                                if (!interchangeNames.contains(name)) {
                                    interchangeNames.add(name);
                                }
                            }
                        });
                        ((Set)stationPositionsGrouped.get(stationId3)).add(new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, interchangeNames));
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)((vertical ? heightScale : widthScale) / 2.0f + extraPadding / (float)routeCount));
                stationPositionsGrouped.forEach((stationId, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    int lines;
                    int x = Math.round((stationPositionGrouped.stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((stationPositionGrouped.stationPosition.y + yOffset) * (float)scale * heightScale);
                    int n = lines = stationPositionGrouped.stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean textBelow = vertical || (stationPositionGrouped.stationPosition.isCommon ? Math.abs(stationPositionGrouped.stationOffset) % 2 == 0 : (float)y >= yOffset * (float)scale);
                    boolean currentStation = stationPositionGrouped.stationOffset == 0;
                    boolean passed = stationPositionGrouped.stationOffset < 0;
                    List<Integer> interchangeColors = stationPositionGrouped.interchangeColors;
                    if (!interchangeColors.isEmpty() && !currentStation) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / (float)interchangeColors.size());
                        for (int i = 0; i < interchangeColors.size(); ++i) {
                            for (int drawX = 0; drawX < lineWidth; ++drawX) {
                                for (int drawY = 0; drawY < lineHeight; ++drawY) {
                                    RouteMapGenerator.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + (textBelow ? -1 : lines * lineSpacing) + (textBelow ? -drawY : drawY), passed ? -5592406 : 0xFF000000 | interchangeColors.get(i));
                                }
                            }
                        }
                        int[] dimensions = new int[2];
                        byte[] pixels = clientCache.getTextPixels(IGui.mergeStations(stationPositionGrouped.interchangeNames), dimensions, maxStringWidth - (vertical ? lineHeight : 0), (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, vertical ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER);
                        RouteMapGenerator.drawString(nativeImage, pixels, x, y + (textBelow ? -1 - lineHeight : lines * lineSpacing + lineHeight), dimensions, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.BOTTOM : IGui.VerticalAlignment.TOP, 0, passed ? -5592406 : -16777216, vertical);
                    }
                    RouteMapGenerator.drawStation(nativeImage, x, y, heightScale, lines, passed);
                    Station station = (Station)clientCache.stationIdMap.get(stationId);
                    int[] dimensions = new int[2];
                    byte[] pixels = clientCache.getTextPixels(station == null ? "" : station.name, dimensions, maxStringWidth, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f), fontSizeBig, fontSizeSmall, fontSizeSmall / 4, vertical ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.CENTER);
                    RouteMapGenerator.drawString(nativeImage, pixels, x, y + (textBelow ? lines * lineSpacing : -1) + (textBelow ? 1 : -1) * lineSize * 5 / 4, dimensions, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM, currentStation ? -16777216 : 0, passed ? -5592406 : (currentStation ? -1 : -16777216), vertical);
                }));
                if (transparentWhite) {
                    RouteMapGenerator.clearColor(nativeImage, -1);
                }
                return new DynamicTexture(nativeImage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setup(List<Map<Integer, StationPosition>> stationPositions, List<List<Long>> stationsIdLists, int[] colorIndices, float[] bounds, boolean passed, boolean reverse) {
        int passedMultiplier = passed ? -1 : 1;
        int reverseMultiplier = reverse ? -1 : 1;
        bounds[0] = 0.0f;
        ArrayList commonStationIds = new ArrayList();
        stationsIdLists.get(0).forEach(stationId -> {
            if (stationId != 0L && !commonStationIds.contains(stationId) && stationsIdLists.stream().allMatch(stationsIds -> stationsIds.contains(stationId))) {
                commonStationIds.add(stationId);
            }
        });
        int positionXOffset = 0;
        int routeCount = stationsIdLists.size();
        int[] traverseIndex = new int[routeCount];
        for (int commonStationIndex = 0; commonStationIndex <= commonStationIds.size(); ++commonStationIndex) {
            int routeIndex;
            boolean lastStation = commonStationIndex == commonStationIds.size();
            long commonStationId = lastStation ? -1L : (Long)commonStationIds.get(commonStationIndex);
            int intermediateSegmentsMaxCount = 0;
            int[] intermediateSegmentsCounts = new int[routeCount];
            for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                intermediateSegmentsCounts[routeIndex2] = (lastStation ? stationsIdLists.get(routeIndex2).size() : stationsIdLists.get(routeIndex2).indexOf(commonStationId) + 1) - traverseIndex[routeIndex2];
                intermediateSegmentsMaxCount = Math.max(intermediateSegmentsMaxCount, intermediateSegmentsCounts[routeIndex2]);
            }
            ArrayList<Integer> routesIndicesInSection = new ArrayList<Integer>();
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                if (lastStation && intermediateSegmentsCounts[routeIndex] <= 0) continue;
                routesIndicesInSection.add(routeIndex);
            }
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                if (intermediateSegmentsCounts[routeIndex] <= 0) continue;
                float increment = (float)intermediateSegmentsMaxCount / (float)intermediateSegmentsCounts[routeIndex];
                for (int j = 0; j < intermediateSegmentsCounts[routeIndex] - (lastStation ? 0 : 1); ++j) {
                    float stationX = (float)positionXOffset + increment * (float)(j + 1);
                    bounds[0] = Math.max(bounds[0], stationX / 2.0f);
                    float stationY = (float)routesIndicesInSection.indexOf(routeIndex) - (float)(routesIndicesInSection.size() - 1) / 2.0f + RouteMapGenerator.getLineOffset(routeIndex, colorIndices);
                    bounds[1] = Math.min(bounds[1], stationY);
                    bounds[2] = Math.max(bounds[2], stationY);
                    stationPositions.get(routeIndex).put(passedMultiplier * (j + traverseIndex[routeIndex] + 1), new StationPosition((float)reverseMultiplier * stationX / 2.0f, stationY, false));
                }
                int n = routeIndex;
                traverseIndex[n] = traverseIndex[n] + intermediateSegmentsCounts[routeIndex];
            }
            if (lastStation) continue;
            positionXOffset += intermediateSegmentsMaxCount;
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                float stationY = RouteMapGenerator.getLineOffset(routeIndex, colorIndices);
                bounds[1] = Math.min(bounds[1], stationY);
                bounds[2] = Math.max(bounds[2], stationY);
                stationPositions.get(routeIndex).put(passedMultiplier * traverseIndex[routeIndex], new StationPosition((float)(reverseMultiplier * positionXOffset) / 2.0f, stationY, true));
            }
            bounds[0] = (float)positionXOffset / 2.0f;
        }
    }

    private static float getLineOffset(int routeIndex, int[] colorIndices) {
        return (float)lineSpacing / (float)scale * ((float)colorIndices[routeIndex] - (float)colorIndices[colorIndices.length - 1] / 2.0f);
    }

    private static List<Integer> getRouteStream(long platformId, BiConsumer<Route, Integer> nonTerminatingCallback) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        ArrayList terminatingColors = new ArrayList();
        ClientData.ROUTES.stream().filter(route -> route.platformIds.contains(platformId) && !route.isHidden).sorted((a, b) -> a.color == b.color ? a.compareTo((NameColorDataBase)b) : a.color - b.color).forEach(route -> {
            int currentStationIndex = route.platformIds.indexOf(platformId);
            if (currentStationIndex < route.platformIds.size() - 1) {
                nonTerminatingCallback.accept((Route)route, currentStationIndex);
                if (!colors.contains(route.color)) {
                    colors.add(route.color);
                }
            } else if (!terminatingColors.contains(route.color)) {
                terminatingColors.add(route.color);
            }
        });
        if (colors.isEmpty()) {
            colors.addAll(terminatingColors);
        }
        return colors;
    }

    private static long getStationId(long platformId) {
        Station station = (Station)ClientData.DATA_CACHE.platformIdToStation.get(platformId);
        return station == null ? -1L : station.id;
    }

    private static String getStationName(long platformId) {
        Station station = (Station)ClientData.DATA_CACHE.platformIdToStation.get(platformId);
        return station == null ? "" : station.name;
    }

    private static Map<Integer, ClientCache.ColorNameTuple> getInterchangeRoutes(long stationId) {
        return ClientData.DATA_CACHE.stationIdToRoutes.get(stationId);
    }

    private static void drawLine(NativeImage nativeImage, StationPosition stationPosition1, StationPosition stationPosition2, float widthScale, float heightScale, float xOffset, float yOffset, int color) {
        int x1 = Math.round((stationPosition1.x + xOffset) * (float)scale * widthScale);
        int x2 = Math.round((stationPosition2.x + xOffset) * (float)scale * widthScale);
        int y1 = Math.round((stationPosition1.y + yOffset) * (float)scale * heightScale);
        int y2 = Math.round((stationPosition2.y + yOffset) * (float)scale * heightScale);
        int xChange = x2 - x1;
        int yChange = y2 - y1;
        int xChangeAbs = Math.abs(xChange);
        int yChangeAbs = Math.abs(yChange);
        int changeDifference = Math.abs(yChangeAbs - xChangeAbs);
        if (xChangeAbs > yChangeAbs) {
            boolean y1OffsetGreater = Math.abs((float)y1 - yOffset * (float)scale) > Math.abs((float)y2 - yOffset * (float)scale);
            RouteMapGenerator.drawLine(nativeImage, x1, y1, x2 - x1, y1OffsetGreater ? 0 : y2 - y1, y1OffsetGreater ? changeDifference : yChangeAbs, color);
            RouteMapGenerator.drawLine(nativeImage, x2, y2, x1 - x2, y1OffsetGreater ? y1 - y2 : 0, y1OffsetGreater ? yChangeAbs : changeDifference, color);
        } else {
            int halfXChangeAbs = xChangeAbs / 2;
            RouteMapGenerator.drawLine(nativeImage, x1, y1, x2 - x1, y2 - y1, halfXChangeAbs, color);
            RouteMapGenerator.drawLine(nativeImage, x2, y2, x1 - x2, y1 - y2, halfXChangeAbs, color);
            RouteMapGenerator.drawLine(nativeImage, (x1 + x2) / 2, y1 + (int)Math.copySign(halfXChangeAbs, y2 - y1), 0, y2 - y1, changeDifference, color);
        }
    }

    private static void drawLine(NativeImage nativeImage, int x, int y, int directionX, int directionY, int length, int color) {
        int xWidth;
        int halfLineHeight = lineSize / 2;
        int n = xWidth = directionX == 0 ? halfLineHeight : 0;
        int yWidth = directionX == 0 ? 0 : (directionY == 0 ? halfLineHeight : Math.round((float)lineSize * Mth.f_13994_ / 2.0f));
        int yMin = y - halfLineHeight - (directionY < 0 ? length : 0) + 1;
        int yMax = y + halfLineHeight + (directionY > 0 ? length : 0) - 1;
        int drawOffset = directionX != 0 && directionY != 0 ? halfLineHeight : 0;
        for (int i = -drawOffset; i < Math.abs(length) + drawOffset; ++i) {
            int drawX = x + (directionX == 0 ? 0 : (int)Math.copySign(i, directionX)) + (directionX < 0 ? -1 : 0);
            int drawY = y + (directionY == 0 ? 0 : (int)Math.copySign(i, directionY)) + (directionY < 0 ? -1 : 0);
            for (int xOffset = 0; xOffset < xWidth; ++xOffset) {
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX - xOffset - 1, drawY, color);
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX + xOffset, drawY, color);
            }
            for (int yOffset = 0; yOffset < yWidth; ++yOffset) {
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX, Math.max(drawY - yOffset, yMin) - 1, color);
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX, Math.min(drawY + yOffset, yMax), color);
            }
        }
    }

    private static void drawStation(NativeImage nativeImage, int x, int y, float heightScale, int lines, boolean passed) {
        for (int offsetX = -lineSize; offsetX < lineSize; ++offsetX) {
            for (int offsetY = -lineSize; offsetY < lineSize; ++offsetY) {
                int i;
                int extraOffsetY = offsetY > 0 ? (int)((float)(lines * lineSpacing) * heightScale) : 0;
                int repeatDraw = offsetY == 0 ? (int)((float)(lines * lineSpacing) * heightScale) : 0;
                double squareSum = ((double)offsetX + 0.5) * ((double)offsetX + 0.5) + ((double)offsetY + 0.5) * ((double)offsetY + 0.5);
                if (squareSum <= 0.5 * (double)lineSize * (double)lineSize) {
                    for (i = 0; i <= repeatDraw; ++i) {
                        RouteMapGenerator.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, -1);
                    }
                    continue;
                }
                if (!(squareSum <= (double)(lineSize * lineSize))) continue;
                for (i = 0; i <= repeatDraw; ++i) {
                    RouteMapGenerator.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, passed ? -5592406 : -16777216);
                }
            }
        }
    }

    private static void drawString(NativeImage nativeImage, byte[] pixels, int x, int y, int[] textDimensions, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, int backgroundColor, int textColor, boolean rotate90) {
        int drawY;
        int drawX;
        if ((backgroundColor >> 24 & 0xFF) > 0) {
            for (drawX = 0; drawX < textDimensions[rotate90 ? 1 : 0]; ++drawX) {
                for (drawY = 0; drawY < textDimensions[rotate90 ? 0 : 1]; ++drawY) {
                    RouteMapGenerator.drawPixelSafe(nativeImage, (int)horizontalAlignment.getOffset(drawX + x, textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset(drawY + y, textDimensions[rotate90 ? 0 : 1]), backgroundColor);
                }
            }
        }
        drawX = 0;
        drawY = rotate90 ? textDimensions[0] - 1 : 0;
        for (int i = 0; i < textDimensions[0] * textDimensions[1]; ++i) {
            RouteMapGenerator.blendPixel(nativeImage, (int)horizontalAlignment.getOffset(x + drawX, textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset(y + drawY, textDimensions[rotate90 ? 0 : 1]), ((pixels[i] & 0xFF) << 24) + (textColor & 0xFFFFFF));
            if (rotate90) {
                if (--drawY >= 0) continue;
                drawY = textDimensions[0] - 1;
                ++drawX;
                continue;
            }
            if (++drawX != textDimensions[0]) continue;
            drawX = 0;
            ++drawY;
        }
    }

    private static void drawResource(NativeImage nativeImage, String resource, int x, int y, int width, int height, boolean flipX, float v1, float v2, int color) throws IOException {
        NativeImage nativeImageResource = NativeImage.m_85048_((NativeImage.Format)NativeImage.Format.RGBA, (InputStream)Utilities.getInputStream(Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation("mtr", resource))));
        int resourceWidth = nativeImageResource.m_84982_();
        int resourceHeight = nativeImageResource.m_85084_();
        for (int drawX = 0; drawX < width; ++drawX) {
            for (int drawY = Math.round(v1 * (float)height); drawY < Math.round(v2 * (float)height); ++drawY) {
                float pixelX = (float)drawX / (float)width * (float)resourceWidth;
                float pixelY = (float)drawY / (float)height * (float)resourceHeight;
                int floorX = (int)pixelX;
                int floorY = (int)pixelY;
                int ceilX = floorX + 1;
                int ceilY = floorY + 1;
                float percentX1 = (float)ceilX - pixelX;
                float percentY1 = (float)ceilY - pixelY;
                float percentX2 = pixelX - (float)floorX;
                float percentY2 = pixelY - (float)floorY;
                float luminance1 = (float)(nativeImageResource.m_84985_(Mth.m_14045_((int)floorX, (int)0, (int)(resourceWidth - 1)), Mth.m_14045_((int)floorY, (int)0, (int)(resourceHeight - 1))) >> 24 & 0xFF) * percentX1 * percentY1;
                float luminance2 = (float)(nativeImageResource.m_84985_(Mth.m_14045_((int)ceilX, (int)0, (int)(resourceWidth - 1)), Mth.m_14045_((int)floorY, (int)0, (int)(resourceHeight - 1))) >> 24 & 0xFF) * percentX2 * percentY1;
                float luminance3 = (float)(nativeImageResource.m_84985_(Mth.m_14045_((int)floorX, (int)0, (int)(resourceWidth - 1)), Mth.m_14045_((int)ceilY, (int)0, (int)(resourceHeight - 1))) >> 24 & 0xFF) * percentX1 * percentY2;
                float luminance4 = (float)(nativeImageResource.m_84985_(Mth.m_14045_((int)ceilX, (int)0, (int)(resourceWidth - 1)), Mth.m_14045_((int)ceilY, (int)0, (int)(resourceHeight - 1))) >> 24 & 0xFF) * percentX2 * percentY2;
                RouteMapGenerator.blendPixel(nativeImage, (flipX ? width - drawX - 1 : drawX) + x, drawY + y, (color & 0xFFFFFF) + ((int)(luminance1 + luminance2 + luminance3 + luminance4) << 24));
            }
        }
    }

    private static void blendPixel(NativeImage nativeImage, int x, int y, int color) {
        float percent;
        if (RailwayData.isBetween(x, 0.0, nativeImage.m_84982_() - 1) && RailwayData.isBetween(y, 0.0, nativeImage.m_85084_() - 1) && (percent = (float)(color >> 24 & 0xFF) / 255.0f) > 0.0f) {
            int existingPixel = nativeImage.m_84985_(x, y);
            boolean existingTransparent = (existingPixel >> 24 & 0xFF) == 0;
            int r1 = existingTransparent ? 255 : existingPixel & 0xFF;
            int g1 = existingTransparent ? 255 : existingPixel >> 8 & 0xFF;
            int b1 = existingTransparent ? 255 : existingPixel >> 16 & 0xFF;
            int r2 = color >> 16 & 0xFF;
            int g2 = color >> 8 & 0xFF;
            int b2 = color & 0xFF;
            float inversePercent = 1.0f - percent;
            int finalColor = 0xFF000000 | ((int)((float)r1 * inversePercent + (float)r2 * percent) << 16) + ((int)((float)g1 * inversePercent + (float)g2 * percent) << 8) + (int)((float)b1 * inversePercent + (float)b2 * percent);
            RouteMapGenerator.drawPixelSafe(nativeImage, x, y, finalColor);
        }
    }

    private static void drawPixelSafe(NativeImage nativeImage, int x, int y, int color) {
        if (RailwayData.isBetween(x, 0.0, nativeImage.m_84982_() - 1) && RailwayData.isBetween(y, 0.0, nativeImage.m_85084_() - 1)) {
            nativeImage.m_84988_(x, y, RouteMapGenerator.invertColor(color));
        }
    }

    private static int invertColor(int color) {
        return ((color & 0xFF000000) != 0 ? -16777216 : 0) + ((color & 0xFF) << 16) + (color & 0xFF00) + ((color & 0xFF0000) >> 16);
    }

    private static void clearColor(NativeImage nativeImage, int color) {
        for (int x = 0; x < nativeImage.m_84982_(); ++x) {
            for (int y = 0; y < nativeImage.m_85084_(); ++y) {
                if (nativeImage.m_84985_(x, y) != color) continue;
                nativeImage.m_84988_(x, y, 0);
            }
        }
    }

    private static class StationPosition {
        private final float x;
        private final float y;
        private final boolean isCommon;

        private StationPosition(float x, float y, boolean isCommon) {
            this.x = x;
            this.y = y;
            this.isCommon = isCommon;
        }
    }

    private static class StationPositionGrouped {
        private final StationPosition stationPosition;
        private final int stationOffset;
        private final List<Integer> interchangeColors;
        private final List<String> interchangeNames;

        private StationPositionGrouped(StationPosition stationPosition, int stationOffset, List<Integer> interchangeColors, List<String> interchangeNames) {
            this.stationPosition = stationPosition;
            this.stationOffset = stationOffset;
            this.interchangeColors = interchangeColors;
            this.interchangeNames = interchangeNames;
        }
    }
}

