/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockArrivalProjectorBase
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public BlockArrivalProjectorBase() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 5).m_60955_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityArrivalProjectorBase) {
                ((TileEntityArrivalProjectorBase)entity).syncData();
                PacketTrainDataGuiServer.openArrivalProjectorConfigScreenS2C((ServerPlayer)player, pos);
            }
        });
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        if (side != Direction.UP && side != Direction.DOWN) {
            return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)side.m_122424_());
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 1.0, facing);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public static class TileEntityArrivalProjectorBase
    extends BlockEntityClientSerializableMapper {
        private final Set<Long> platformIds = new HashSet<Long>();
        private static final String KEY_PLATFORM_IDS = "platform_ids";

        public TileEntityArrivalProjectorBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            long[] platformIdsArray;
            for (long platformId : platformIdsArray = compoundTag.m_128467_(KEY_PLATFORM_IDS)) {
                this.platformIds.add(platformId);
            }
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128428_(KEY_PLATFORM_IDS, new ArrayList<Long>(this.platformIds));
        }

        public Set<Long> getPlatformIds() {
            return this.platformIds;
        }

        public void setData(Set<Long> platformIds) {
            this.platformIds.clear();
            this.platformIds.addAll(platformIds);
            this.m_6596_();
            this.syncData();
        }
    }
}

