/*
 * Decompiled with CFR 0.152.
 */
package mtr;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mtr.Keys;
import mtr.data.IGui;
import mtr.data.RailType;

public class Patreon
implements Keys,
IGui,
Comparable<Patreon> {
    public final String name;
    public final String tierTitle;
    public final int tierAmount;
    public final int tierColor;
    private final String joinedDate;

    public Patreon(JsonObject jsonObjectPatron, JsonObject jsonObjectReward, String joinedDate) {
        this.name = jsonObjectPatron.get("full_name").getAsString();
        this.tierTitle = jsonObjectReward.get("title").getAsString();
        this.tierAmount = jsonObjectReward.get("amount_cents").getAsInt();
        this.joinedDate = joinedDate;
        int color = -1;
        try {
            color = RailType.valueOf((String)this.tierTitle.toUpperCase()).color | 0xFF000000;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tierColor = color;
    }

    public static List<Patreon> getPatreonList() {
        ArrayList<Patreon> patreonList = new ArrayList<Patreon>();
        try {
            String inputLine;
            HttpURLConnection connection = (HttpURLConnection)new URL("https://www.patreon.com/api/oauth2/api/campaigns/7782318/pledges").openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer WsUaKiBd15QZw-aAaJ3kUvQVe0-AToD5YyC3Ok-lPL8");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = bufferedReader.readLine()) != null) {
                content.append(inputLine);
            }
            JsonObject jsonObjectData = new JsonParser().parse(content.toString()).getAsJsonObject();
            HashMap idMap = new HashMap();
            jsonObjectData.getAsJsonArray("included").forEach(jsonElement -> {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                idMap.put(jsonObject.get("id").getAsString(), jsonObject);
            });
            jsonObjectData.getAsJsonArray("data").forEach(jsonElement -> {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                JsonObject jsonObjectRelationships = jsonObject.getAsJsonObject("relationships");
                JsonObject jsonObjectPatron = ((JsonObject)idMap.get(jsonObjectRelationships.get("patron").getAsJsonObject().get("data").getAsJsonObject().get("id").getAsString())).getAsJsonObject("attributes");
                JsonObject jsonObjectReward = ((JsonObject)idMap.get(jsonObjectRelationships.get("reward").getAsJsonObject().get("data").getAsJsonObject().get("id").getAsString())).getAsJsonObject("attributes");
                String joinedDate = jsonObject.getAsJsonObject("attributes").get("created_at").getAsString();
                patreonList.add(new Patreon(jsonObjectPatron, jsonObjectReward, joinedDate));
            });
            Collections.sort(patreonList);
            bufferedReader.close();
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return patreonList;
    }

    @Override
    public int compareTo(Patreon patreon) {
        return patreon.tierAmount == this.tierAmount ? this.joinedDate.compareTo(patreon.joinedDate) : patreon.tierAmount - this.tierAmount;
    }
}

