/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mtr.data.DataCache;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Station;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class DelaysServletHandler
extends HttpServlet {
    public static MinecraftServer SERVER;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        SERVER.execute(() -> {
            JsonArray dataArray = new JsonArray();
            SERVER.m_129785_().forEach(world -> {
                RailwayData railwayData = RailwayData.getInstance((Level)world);
                JsonArray delayArray = new JsonArray();
                if (railwayData != null) {
                    DataCache dataCache = railwayData.dataCache;
                    railwayData.getTrainDelays().forEach((routeId, trainDelaysForRoute) -> trainDelaysForRoute.forEach((pos, trainDelay) -> {
                        int color;
                        String circular;
                        String destination;
                        String routeNumber;
                        String routeName;
                        Route route = dataCache.routeIdMap.get(routeId);
                        if (route == null) {
                            routeName = "";
                            routeNumber = "";
                            destination = "";
                            circular = "";
                            color = 0;
                        } else {
                            routeName = route.name;
                            routeNumber = route.isLightRailRoute ? route.lightRailRouteNumber : "";
                            Station station = dataCache.platformIdToStation.get(route.platformIds.get(route.platformIds.size() - 1));
                            String string = destination = station == null ? "" : station.name;
                            circular = route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw");
                            color = route.color;
                        }
                        JsonObject delayObject = new JsonObject();
                        delayObject.addProperty("name", routeName);
                        delayObject.addProperty("number", routeNumber);
                        delayObject.addProperty("destination", destination);
                        delayObject.addProperty("circular", circular);
                        delayObject.addProperty("color", (Number)color);
                        delayObject.addProperty("delay", (Number)trainDelay.getDelayTicks());
                        delayObject.addProperty("time", (Number)trainDelay.getLastDelayTime());
                        delayObject.addProperty("x", (Number)pos.m_123341_());
                        delayObject.addProperty("y", (Number)pos.m_123342_());
                        delayObject.addProperty("z", (Number)pos.m_123343_());
                        delayArray.add((JsonElement)delayObject);
                    }));
                }
                dataArray.add((JsonElement)delayArray);
            });
            IServletHandler.sendResponse(response, asyncContext, dataArray.toString());
        });
    }
}

