/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.function.Consumer;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class WidgetBetterTextField
extends EditBox
implements IGui {
    private final String filter;
    private final String suggestion;
    private final int newMaxLength;
    private static final int DEFAULT_MAX_LENGTH = 128;

    public WidgetBetterTextField(String suggestion) {
        this("", suggestion, 128);
    }

    public WidgetBetterTextField(String suggestion, int maxLength) {
        this("", suggestion, maxLength);
    }

    public WidgetBetterTextField(TextFieldFilter textFieldFilter, String suggestion, int maxLength) {
        this(textFieldFilter.filter, suggestion, maxLength);
    }

    public WidgetBetterTextField(String filter, String suggestion, int maxLength) {
        super(Minecraft.m_91087_().f_91062_, 0, 0, 0, 20, (Component)Text.literal(""));
        this.filter = filter;
        this.suggestion = suggestion;
        this.newMaxLength = maxLength;
        this.m_94151_(text -> {});
        this.m_94199_(0);
    }

    public void m_94151_(Consumer<String> changedListener) {
        super.m_94151_(text -> {
            String newText;
            if (this.filter.isEmpty()) {
                newText = this.trySetLength((String)text);
            } else {
                newText = this.trySetLength(text.toUpperCase().replaceAll(this.filter, ""));
                if (!newText.equals(text)) {
                    this.m_94144_(newText);
                }
            }
            this.m_94167_(newText.isEmpty() && this.suggestion != null ? this.suggestion : "");
            changedListener.accept(newText);
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_94213_() && RailwayData.isBetween(mouseX, this.f_93620_, this.f_93620_ + this.f_93618_) && RailwayData.isBetween(mouseY, this.f_93621_, this.f_93621_ + this.f_93619_)) {
            if (button == 1) {
                this.m_94144_("");
            }
            return super.m_6375_(mouseX, mouseY, 0);
        }
        this.m_93692_(false);
        return false;
    }

    public void m_94199_(int maxLength) {
        super.m_94199_(Integer.MAX_VALUE);
    }

    private String trySetLength(String text) {
        return text.isEmpty() ? "" : text.substring(0, Math.min(this.newMaxLength, text.length()));
    }

    public static enum TextFieldFilter {
        POSITIVE_INTEGER("\\D"),
        INTEGER("[^-\\d]"),
        HEX("[^\\dA-F]"),
        LETTER("[^A-Z]");

        private final String filter;

        private TextFieldFilter(String filter) {
            this.filter = filter;
        }
    }
}

