/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.file.Path;
import java.util.function.Consumer;
import mtr.client.CustomResources;
import mtr.client.ICustomResources;
import mtr.client.IDrawing;
import mtr.client.IResourcePackCreatorProperties;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.screen.FileUploaderScreen;
import mtr.screen.ResourcePackCreatorScreen;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetColorSelector;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ResourcePackCreatorOptionsScreen
extends ScreenMapper
implements IResourcePackCreatorProperties,
ICustomResources,
IGui {
    private final ResourcePackCreatorScreen resourcePackCreatorScreen;
    private final Button buttonChooseModelFile;
    private final Button buttonChoosePropertiesFile;
    private final Button buttonChooseTextureFile;
    private final WidgetBetterTextField textFieldId;
    private final WidgetBetterTextField textFieldName;
    private final WidgetColorSelector colorSelector;
    private final WidgetBetterTextField textFieldGangwayConnectionId;
    private final WidgetBetterTextField textFieldTrainBarrierId;
    private final WidgetShorterSlider sliderRiderOffset;
    private final Button buttonDone;
    private final Button buttonExport;
    private static final Component FILE_MODEL_TEXT = Text.translatable("gui.mtr.file_model", new Object[0]);
    private static final Component FILE_PROPERTIES_TEXT = Text.translatable("gui.mtr.file_properties", new Object[0]);
    private static final Component FILE_TEXTURE_TEXT = Text.translatable("gui.mtr.file_texture", new Object[0]);
    private static final Component NAME_TEXT = Text.translatable("gui.mtr.custom_resources_name", new Object[0]);
    private static final Component ID_TEXT = Text.translatable("gui.mtr.custom_resources_id", new Object[0]);
    private static final Component GANGWAY_CONNECTION_ID_TEXT = Text.translatable("gui.mtr.custom_resources_gangway_connection_id", new Object[0]);
    private static final Component TRAIN_BARRIER_ID_TEXT = Text.translatable("gui.mtr.custom_resources_train_barrier_id", new Object[0]);

    public ResourcePackCreatorOptionsScreen(ResourcePackCreatorScreen resourcePackCreatorScreen) {
        super((Component)Text.literal(""));
        this.resourcePackCreatorScreen = resourcePackCreatorScreen;
        this.buttonChooseModelFile = new Button(0, 0, 0, 20, (Component)Text.literal(""), button -> this.buttonCallback(path -> {
            RenderTrains.creatorProperties.loadModelFile((Path)path);
            this.updateControls(false);
        }));
        this.buttonChoosePropertiesFile = new Button(0, 0, 0, 20, (Component)Text.literal(""), button -> this.buttonCallback(path -> {
            RenderTrains.creatorProperties.loadPropertiesFile((Path)path);
            this.updateControls(false);
        }));
        this.buttonChooseTextureFile = new Button(0, 0, 0, 20, (Component)Text.literal(""), button -> this.buttonCallback(path -> {
            RenderTrains.creatorProperties.loadTextureFile((Path)path);
            this.updateControls(false);
        }));
        this.textFieldId = new WidgetBetterTextField("my_custom_train_id");
        this.textFieldName = new WidgetBetterTextField("My Custom Train Name");
        this.colorSelector = new WidgetColorSelector(this, this::onUpdateColor);
        this.textFieldGangwayConnectionId = new WidgetBetterTextField("mtr:textures/entity/sp1900");
        this.textFieldTrainBarrierId = new WidgetBetterTextField("mtr:textures/entity/r211");
        this.sliderRiderOffset = new WidgetShorterSlider(0, 144, 18, value -> {
            RenderTrains.creatorProperties.editCustomResourcesRiderOffset((float)(value - 2) / 4.0f);
            this.updateControls(true);
            return Text.translatable("gui.mtr.custom_resources_rider_offset", Float.valueOf((float)(value - 2) / 4.0f)).getString();
        }, null);
        this.buttonDone = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.done", new Object[0]), button -> this.m_7379_());
        this.buttonExport = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.custom_resources_export_resource_pack", new Object[0]), button -> RenderTrains.creatorProperties.export());
    }

    protected void m_7856_() {
        super.m_7856_();
        int newWidth = this.f_96543_ - 40;
        int yStart = (this.f_96544_ - 200 - 16) / 2;
        int textWidth = Math.max(Math.max(this.f_96547_.m_92852_((FormattedText)FILE_MODEL_TEXT), Math.max(this.f_96547_.m_92852_((FormattedText)FILE_PROPERTIES_TEXT), this.f_96547_.m_92852_((FormattedText)FILE_TEXTURE_TEXT))), Math.max(Math.max(this.f_96547_.m_92852_((FormattedText)NAME_TEXT), this.f_96547_.m_92852_((FormattedText)ID_TEXT)), Math.max(this.f_96547_.m_92852_((FormattedText)GANGWAY_CONNECTION_ID_TEXT), this.f_96547_.m_92852_((FormattedText)TRAIN_BARRIER_ID_TEXT)))) + 6;
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonChooseModelFile, 20 + textWidth, yStart, newWidth - textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonChoosePropertiesFile, 20 + textWidth, yStart + 20, newWidth - textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonChooseTextureFile, 20 + textWidth, yStart + 40, newWidth - textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldId, 20 + textWidth + 2, yStart + 70 + 2, newWidth - 40 - 4 - textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.colorSelector, 20 + newWidth + 2 - 40, yStart + 70 + 2, 36);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldName, 20 + textWidth + 2, yStart + 90 + 6, newWidth - 4 - textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldGangwayConnectionId, 20 + textWidth + 2, yStart + 110 + 10, newWidth - 4 - textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldTrainBarrierId, 20 + textWidth + 2, yStart + 130 + 14, newWidth - 4 - textWidth);
        this.textFieldId.m_94151_(text -> {
            RenderTrains.creatorProperties.editCustomResourcesId(ResourcePackCreatorOptionsScreen.formatText(this.textFieldId, text, false));
            this.updateControls(false);
        });
        this.textFieldName.m_94151_(text -> {
            RenderTrains.creatorProperties.editCustomResourcesName((String)text);
            this.updateControls(false);
        });
        this.textFieldGangwayConnectionId.m_94151_(text -> {
            RenderTrains.creatorProperties.editCustomResourcesGangwayConnectionId(ResourcePackCreatorOptionsScreen.formatText(this.textFieldGangwayConnectionId, text, true));
            this.updateControls(false);
        });
        this.textFieldTrainBarrierId.m_94151_(text -> {
            RenderTrains.creatorProperties.editCustomResourcesTrainBarrierId(ResourcePackCreatorOptionsScreen.formatText(this.textFieldTrainBarrierId, text, true));
            this.updateControls(false);
        });
        IDrawing.setPositionAndWidth((AbstractWidget)this.sliderRiderOffset, 20, yStart + 150 + 16, textWidth);
        this.sliderRiderOffset.setHeight(20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDone, 20, yStart + 180 + 16, textWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonExport, 20 + textWidth, yStart + 180 + 16, newWidth - textWidth);
        this.updateControls(true);
        this.addDrawableChild(this.buttonChooseModelFile);
        this.addDrawableChild(this.buttonChoosePropertiesFile);
        this.addDrawableChild(this.buttonChooseTextureFile);
        this.addDrawableChild(this.textFieldId);
        this.addDrawableChild(this.colorSelector);
        this.addDrawableChild(this.textFieldName);
        this.addDrawableChild(this.textFieldGangwayConnectionId);
        this.addDrawableChild(this.textFieldTrainBarrierId);
        this.addDrawableChild(this.sliderRiderOffset);
        this.addDrawableChild(this.buttonDone);
        this.addDrawableChild(this.buttonExport);
    }

    public void m_96624_() {
        this.textFieldId.m_94120_();
        this.textFieldName.m_94120_();
        this.textFieldGangwayConnectionId.m_94120_();
        this.textFieldTrainBarrierId.m_94120_();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            super.m_6305_(matrices, mouseX, mouseY, delta);
            int yStart = (this.f_96544_ - 200 - 16) / 2;
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)FILE_MODEL_TEXT, (int)20, (int)(yStart + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)FILE_PROPERTIES_TEXT, (int)20, (int)(yStart + 20 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)FILE_TEXTURE_TEXT, (int)20, (int)(yStart + 40 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)ID_TEXT, (int)20, (int)(yStart + 70 + 2 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)NAME_TEXT, (int)20, (int)(yStart + 90 + 6 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)GANGWAY_CONNECTION_ID_TEXT, (int)20, (int)(yStart + 110 + 10 + 6), (int)-1);
            ResourcePackCreatorOptionsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)TRAIN_BARRIER_ID_TEXT, (int)20, (int)(yStart + 130 + 14 + 6), (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.f_96541_ != null) {
            UtilitiesClient.setScreen(this.f_96541_, this.resourcePackCreatorScreen);
        }
    }

    private void updateControls(boolean formatTextFields) {
        String modelFileName = RenderTrains.creatorProperties.getModelFileName();
        this.buttonChooseModelFile.m_93666_((Component)(modelFileName.isEmpty() ? Text.translatable("gui.mtr.file_upload", new Object[0]) : Text.literal(modelFileName)));
        String propertiesFileName = RenderTrains.creatorProperties.getPropertiesFileName();
        this.buttonChoosePropertiesFile.m_93666_((Component)(propertiesFileName.isEmpty() ? Text.translatable("gui.mtr.file_upload", new Object[0]) : Text.literal(propertiesFileName)));
        String textureFileName = RenderTrains.creatorProperties.getTextureFileName();
        this.buttonChooseTextureFile.m_93666_((Component)(textureFileName.isEmpty() ? Text.translatable("gui.mtr.file_upload", new Object[0]) : Text.literal(textureFileName)));
        JsonObject customTrainObject = RenderTrains.creatorProperties.getCustomTrainObject();
        int sliderRiderOffsetValue = Math.round(customTrainObject.get("rider_offset").getAsFloat() * 4.0f + 2.0f);
        if (sliderRiderOffsetValue != this.sliderRiderOffset.getIntValue()) {
            this.sliderRiderOffset.setValue(sliderRiderOffsetValue);
        }
        if (formatTextFields) {
            this.textFieldId.m_94144_(RenderTrains.creatorProperties.getCustomTrainId());
            int color = CustomResources.colorStringToInt(customTrainObject.get("color").getAsString());
            this.colorSelector.setColor(color);
            if (color == 0) {
                RenderTrains.creatorProperties.editCustomResourcesColor(this.colorSelector.getColor());
            }
            this.textFieldName.m_94144_(customTrainObject.get("name").getAsString());
            this.textFieldGangwayConnectionId.m_94144_(customTrainObject.get("gangway_connection_id").getAsString());
            this.textFieldTrainBarrierId.m_94144_(customTrainObject.get("train_barrier_id").getAsString());
        }
        this.buttonExport.f_93623_ = !this.textFieldId.m_94155_().isEmpty() && !this.textFieldName.m_94155_().isEmpty() && !RenderTrains.creatorProperties.getModelFileName().isEmpty() && !RenderTrains.creatorProperties.getTextureFileName().isEmpty();
    }

    private void onUpdateColor() {
        RenderTrains.creatorProperties.editCustomResourcesColor(this.colorSelector.getColor());
        this.updateControls(false);
    }

    private void buttonCallback(Consumer<Path> callback) {
        if (this.f_96541_ != null) {
            UtilitiesClient.setScreen(this.f_96541_, new FileUploaderScreen(this, paths -> {
                if (!paths.isEmpty()) {
                    try {
                        callback.accept((Path)paths.get(0));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
    }

    private static String formatText(WidgetBetterTextField textField, String text, boolean isFileName) {
        String cutText = text.toLowerCase().replaceAll(isFileName ? "[^\\w:/]" : "\\W", "");
        while (!cutText.isEmpty() && cutText.substring(0, 1).replaceAll("[^a-z]", "").isEmpty()) {
            cutText = cutText.substring(1);
        }
        if (!cutText.equals(text)) {
            textField.m_94144_(cutText);
        }
        return cutText;
    }
}

