/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockRouteSignBase;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.CustomResources;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.render.RenderRailwaySign;
import mtr.screen.DashboardListSelectorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RailwaySignScreen
extends ScreenMapper
implements IGui {
    private int editingIndex = -1;
    private int page;
    private int totalPages;
    private int columns;
    private int rows;
    private final BlockPos signPos;
    private final boolean isRailwaySign;
    private final int length;
    private final String[] signIds;
    private final Set<Long> selectedIds;
    private final List<NameColorDataBase> exitsForList = new ArrayList<NameColorDataBase>();
    private final List<NameColorDataBase> platformsForList = new ArrayList<NameColorDataBase>();
    private final List<NameColorDataBase> routesForList = new ArrayList<NameColorDataBase>();
    private final List<String> allSignIds = new ArrayList<String>();
    private final Button[] buttonsEdit;
    private final Button[] buttonsSelection;
    private final Button buttonClear;
    private final ImageButton buttonPrevPage;
    private final ImageButton buttonNextPage;
    private static final int SIGN_SIZE = 32;
    private static final int SIGN_BUTTON_SIZE = 16;
    private static final int BUTTON_Y_START = 62;

    public RailwaySignScreen(BlockPos signPos) {
        super((Component)Text.literal(""));
        int i;
        this.signPos = signPos;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        for (BlockRailwaySign.SignType signType : BlockRailwaySign.SignType.values()) {
            this.allSignIds.add(signType.toString());
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(CustomResources.CUSTOM_SIGNS.keySet());
        Collections.sort(sortedKeys);
        this.allSignIds.addAll(sortedKeys);
        try {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, signPos);
            if (station != null) {
                Map<String, List<String>> exits = station.getGeneratedExits();
                ArrayList<String> exitParents = new ArrayList<String>(exits.keySet());
                exitParents.sort(String::compareTo);
                exitParents.forEach(exitParent -> {
                    List destinations = (List)exits.get(exitParent);
                    this.exitsForList.add(new DataConverter(Station.serializeExit(exitParent), exitParent + " " + (destinations.size() > 0 ? (String)destinations.get(0) : ""), 0));
                });
                ArrayList<Platform> platforms = new ArrayList<Platform>(ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id).values());
                Collections.sort(platforms);
                platforms.stream().map(platform -> new DataConverter(platform.id, platform.name + " " + IGui.mergeStations(ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id).stream().map(route -> route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName).collect(Collectors.toList())), 0)).forEach(this.platformsForList::add);
                Map<Integer, ClientCache.ColorNameTuple> routeMap = ClientData.DATA_CACHE.stationIdToRoutes.get(station.id);
                routeMap.forEach((color, route) -> this.routesForList.add(new DataConverter(route.color, route.name, route.color)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (world != null) {
            BlockEntity entity = world.m_7702_(signPos);
            if (entity instanceof BlockRailwaySign.TileEntityRailwaySign) {
                this.signIds = ((BlockRailwaySign.TileEntityRailwaySign)entity).getSignIds();
                this.selectedIds = ((BlockRailwaySign.TileEntityRailwaySign)entity).getSelectedIds();
                this.isRailwaySign = true;
            } else {
                this.signIds = new String[0];
                this.selectedIds = new HashSet<Long>();
                this.isRailwaySign = false;
                if (entity instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                    this.selectedIds.add(((BlockRouteSignBase.TileEntityRouteSignBase)entity).getPlatformId());
                }
            }
            this.length = world.m_8055_(signPos).m_60734_() instanceof BlockRailwaySign ? ((BlockRailwaySign)world.m_8055_((BlockPos)signPos).m_60734_()).length : 0;
        } else {
            this.length = 0;
            this.signIds = new String[0];
            this.selectedIds = new HashSet<Long>();
            this.isRailwaySign = false;
        }
        this.buttonsEdit = new Button[this.length];
        for (i = 0; i < this.buttonsEdit.length; ++i) {
            int index = i;
            this.buttonsEdit[i] = new Button(0, 0, 0, 20, (Component)Text.translatable("selectWorld.edit", new Object[0]), button -> this.edit(index));
        }
        this.buttonsSelection = new Button[this.allSignIds.size()];
        for (i = 0; i < this.allSignIds.size(); ++i) {
            int index = i;
            this.buttonsSelection[i] = new Button(0, 0, 0, 16, (Component)Text.literal(""), button -> this.setNewSignId(this.allSignIds.get(index)));
        }
        this.buttonClear = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.reset_sign", new Object[0]), button -> this.setNewSignId(null));
        this.buttonPrevPage = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_left.png"), 20, 40, button -> this.setPage(this.page - 1));
        this.buttonNextPage = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_right.png"), 20, 40, button -> this.setPage(this.page + 1));
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < this.buttonsEdit.length; ++i) {
            IDrawing.setPositionAndWidth((AbstractWidget)this.buttonsEdit[i], (this.f_96543_ - 32 * this.length) / 2 + i * 32, 32, 32);
            this.addDrawableChild(this.buttonsEdit[i]);
        }
        this.columns = Math.max((this.f_96543_ - 48) / 128 * 2, 1);
        this.rows = Math.max((this.f_96544_ - 32 - 80) / 16, 1);
        int xOffsetSmall = (this.f_96543_ - 16 * (this.columns * 4 + 3)) / 2 + 16;
        int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
        this.totalPages = this.loopSigns((index, x, y, isBig) -> {
            IDrawing.setPositionAndWidth((AbstractWidget)this.buttonsSelection[index], (isBig ? xOffsetBig : xOffsetSmall) + x, 62 + y, isBig ? 48 : 16);
            this.buttonsSelection[index].f_93624_ = false;
            this.addDrawableChild(this.buttonsSelection[index]);
        }, true);
        int buttonClearX = (this.f_96543_ - 144 - 80) / 2;
        int buttonY = this.f_96544_ - 40;
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonClear, buttonClearX, buttonY, 144);
        this.buttonClear.f_93624_ = false;
        this.addDrawableChild(this.buttonClear);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonPrevPage, buttonClearX + 144, buttonY, 20);
        this.buttonPrevPage.f_93624_ = false;
        this.addDrawableChild(this.buttonPrevPage);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonNextPage, buttonClearX + 144 + 60, buttonY, 20);
        this.buttonNextPage.f_93624_ = false;
        this.addDrawableChild(this.buttonNextPage);
        if (!this.isRailwaySign && this.f_96541_ != null) {
            UtilitiesClient.setScreen(this.f_96541_, new DashboardListSelectorScreen(this::m_7379_, this.platformsForList, this.selectedIds, true, false));
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            super.m_6305_(matrices, mouseX, mouseY, delta);
            if (this.f_96541_ == null) {
                return;
            }
            for (int i = 0; i < this.signIds.length; ++i) {
                if (this.signIds[i] == null) continue;
                RenderRailwaySign.drawSign(matrices, null, this.f_96547_, this.signPos, this.signIds[i], (float)(this.f_96543_ - 32 * this.length) / 2.0f + (float)(i * 32), 0.0f, 32.0f, i, this.signIds.length - i - 1, this.selectedIds, Direction.UP, (textureId, x, y, size, flipTexture) -> {
                    UtilitiesClient.beginDrawingTexture(textureId);
                    RailwaySignScreen.m_93133_((PoseStack)matrices, (int)((int)x), (int)((int)y), (float)0.0f, (float)0.0f, (int)((int)size), (int)((int)size), (int)((int)(flipTexture ? -size : size)), (int)((int)size));
                });
            }
            if (this.editingIndex >= 0) {
                int xOffsetSmall = (this.f_96543_ - 16 * (this.columns * 4 + 3)) / 2 + 16;
                int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
                this.loopSigns((index, x, y, isBig) -> {
                    String signId = this.allSignIds.get(index);
                    CustomResources.CustomSign sign = RenderRailwaySign.getSign(signId);
                    if (sign != null) {
                        boolean moveRight = sign.hasCustomText() && sign.flipCustomText;
                        UtilitiesClient.beginDrawingTexture(sign.textureId);
                        RenderRailwaySign.drawSign(matrices, null, this.f_96547_, this.signPos, signId, (isBig ? xOffsetBig : xOffsetSmall) + x + (moveRight ? 32 : 0), 62 + y, 16.0f, 2.0f, 2.0f, this.selectedIds, Direction.UP, (textureId, x1, y1, size, flipTexture) -> RailwaySignScreen.m_93133_((PoseStack)matrices, (int)((int)x1), (int)((int)y1), (float)0.0f, (float)0.0f, (int)((int)size), (int)((int)size), (int)((int)(flipTexture ? -size : size)), (int)((int)size)));
                    }
                }, false);
                Gui.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)String.format("%s/%s", this.page + 1, this.totalPages), (int)((this.f_96543_ - 144 - 80) / 2 + 144 + 40), (int)(this.f_96544_ - 40 + 6), (int)-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.setPage(this.page + (int)Math.signum(-amount));
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_7379_() {
        PacketTrainDataGuiClient.sendSignIdsC2S(this.signPos, this.selectedIds, this.signIds);
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6574_(Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        for (Button button : this.buttonsEdit) {
            button.f_93623_ = true;
        }
        for (Button button : this.buttonsSelection) {
            button.f_93624_ = false;
        }
        this.editingIndex = -1;
    }

    private int loopSigns(LoopSignsCallback loopSignsCallback, boolean ignorePage) {
        int pageCount = this.rows * this.columns;
        int indexSmall = 0;
        int indexBig = 0;
        int columnSmall = 0;
        int columnBig = 0;
        int rowSmall = 0;
        int rowBig = 0;
        int totalPagesSmallCount = 1;
        int totalPagesBigCount = 1;
        for (int i = 0; i < this.allSignIds.size(); ++i) {
            boolean onPage;
            CustomResources.CustomSign sign = RenderRailwaySign.getSign(this.allSignIds.get(i));
            boolean isBig = sign != null && sign.hasCustomText();
            this.buttonsSelection[i].f_93624_ = onPage = (isBig ? indexBig : indexSmall) / pageCount == this.page;
            if (ignorePage || onPage) {
                loopSignsCallback.loopSignsCallback(i, (isBig ? columnBig * 3 : columnSmall) * 16, (isBig ? rowBig : rowSmall) * 16, isBig);
            }
            if (isBig) {
                ++columnBig;
                if (totalPagesBigCount < 0) {
                    totalPagesBigCount = -totalPagesBigCount + 1;
                }
                if (columnBig >= this.columns) {
                    columnBig = 0;
                    if (++rowBig >= this.rows) {
                        rowBig = 0;
                        totalPagesBigCount = -totalPagesBigCount;
                    }
                }
                ++indexBig;
                continue;
            }
            ++columnSmall;
            if (totalPagesSmallCount < 0) {
                totalPagesSmallCount = -totalPagesSmallCount + 1;
            }
            if (columnSmall >= this.columns) {
                columnSmall = 0;
                if (++rowSmall >= this.rows) {
                    rowSmall = 0;
                    totalPagesSmallCount = -totalPagesSmallCount;
                }
            }
            ++indexSmall;
        }
        return Math.max(Math.abs(totalPagesBigCount), Math.abs(totalPagesSmallCount));
    }

    private void edit(int editingIndex) {
        this.editingIndex = editingIndex;
        for (Button button : this.buttonsEdit) {
            button.f_93623_ = true;
        }
        this.buttonClear.f_93624_ = true;
        this.setPage(this.page);
        this.buttonsEdit[editingIndex].f_93623_ = false;
    }

    private void setNewSignId(String newSignId) {
        if (this.editingIndex >= 0 && this.editingIndex < this.signIds.length) {
            boolean isLine;
            int i;
            CustomResources.CustomSign newSign = RenderRailwaySign.getSign(newSignId);
            if (newSign != null && newSign.hasCustomText()) {
                if (newSign.flipCustomText) {
                    for (i = this.editingIndex - 1; i >= 0; --i) {
                        this.signIds[i] = null;
                    }
                } else {
                    for (i = this.editingIndex + 1; i < this.signIds.length; ++i) {
                        this.signIds[i] = null;
                    }
                }
            }
            for (i = 0; i < this.signIds.length; ++i) {
                CustomResources.CustomSign sign = RenderRailwaySign.getSign(this.signIds[i]);
                if (this.signIds[i] == null || sign == null || !sign.hasCustomText() || (i >= this.editingIndex || sign.flipCustomText) && (i <= this.editingIndex || !sign.flipCustomText)) continue;
                this.signIds[i] = null;
            }
            this.signIds[this.editingIndex] = newSignId;
            boolean isExitLetter = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.EXIT_LETTER.toString()) || newSignId.equals(BlockRailwaySign.SignType.EXIT_LETTER_FLIPPED.toString()));
            boolean isPlatform = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.PLATFORM.toString()) || newSignId.equals(BlockRailwaySign.SignType.PLATFORM_FLIPPED.toString()));
            boolean bl = isLine = newSignId != null && (newSignId.equals(BlockRailwaySign.SignType.LINE.toString()) || newSignId.equals(BlockRailwaySign.SignType.LINE_FLIPPED.toString()));
            if ((isExitLetter || isPlatform || isLine) && this.f_96541_ != null) {
                UtilitiesClient.setScreen(this.f_96541_, new DashboardListSelectorScreen(this, isExitLetter ? this.exitsForList : (isPlatform ? this.platformsForList : this.routesForList), this.selectedIds, false, false));
            }
        }
    }

    private void setPage(int newPage) {
        this.page = Mth.m_14045_((int)newPage, (int)0, (int)(this.totalPages - 1));
        this.buttonPrevPage.f_93624_ = this.editingIndex >= 0 && this.page > 0;
        this.buttonNextPage.f_93624_ = this.editingIndex >= 0 && this.page < this.totalPages - 1;
    }

    @FunctionalInterface
    private static interface LoopSignsCallback {
        public void loopSignsCallback(int var1, int var2, int var3, boolean var4);
    }
}

