/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.block.BlockArrivalProjectorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.WidgetBetterCheckbox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ArrivalProjectorConfigScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final BlockPos pos;
    private final Set<Long> filterPlatformIds;
    private final WidgetBetterCheckbox selectAllCheckbox;
    private final Button filterButton;

    public ArrivalProjectorConfigScreen(BlockPos pos) {
        super((Component)Text.literal(""));
        BlockEntity entity;
        this.pos = pos;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.filterPlatformIds = world == null ? new HashSet<Long>() : ((entity = world.m_7702_(pos)) instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase ? ((BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity).getPlatformIds() : new HashSet<Long>());
        this.selectAllCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.select_all_platforms", new Object[0]), checked -> {});
        this.filterButton = new Button(0, 0, 0, 20, (Component)Text.literal(""), button -> {
            Station station;
            if (this.f_96541_ != null && (station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos)) != null) {
                ArrayList<NameColorDataBase> platformsForList = new ArrayList<NameColorDataBase>();
                ArrayList<Platform> platforms = new ArrayList<Platform>(ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id).values());
                Collections.sort(platforms);
                platforms.stream().map(platform -> new DataConverter(platform.id, platform.name + " " + IGui.mergeStations(ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id).stream().map(route -> route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName).collect(Collectors.toList())), 0)).forEach(platformsForList::add);
                if (this.selectAllCheckbox.m_93840_()) {
                    this.filterPlatformIds.clear();
                }
                UtilitiesClient.setScreen(this.f_96541_, new DashboardListSelectorScreen(() -> {
                    UtilitiesClient.setScreen(this.f_96541_, this);
                    this.selectAllCheckbox.setChecked(this.filterPlatformIds.isEmpty());
                }, platformsForList, this.filterPlatformIds, false, false));
            }
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        IDrawing.setPositionAndWidth((AbstractWidget)this.selectAllCheckbox, 20, 20, 144);
        this.selectAllCheckbox.setChecked(this.filterPlatformIds.isEmpty());
        this.addDrawableChild(this.selectAllCheckbox);
        IDrawing.setPositionAndWidth((AbstractWidget)this.filterButton, 20, 60, 72);
        this.filterButton.m_93666_((Component)Text.translatable("selectWorld.edit", new Object[0]));
        this.addDrawableChild(this.filterButton);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.f_96547_.m_92889_(matrices, (Component)Text.translatable("gui.mtr.filtered_platforms", this.selectAllCheckbox.m_93840_() ? 0 : this.filterPlatformIds.size()), 20.0f, 46.0f, -1);
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7379_() {
        if (this.selectAllCheckbox.m_93840_()) {
            this.filterPlatformIds.clear();
        }
        PacketTrainDataGuiClient.sendArrivalProjectorConfigC2S(this.pos, this.filterPlatformIds);
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

