/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.Route;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RouteRenderer
implements IGui {
    private final PoseStack matrices;
    private final MultiBufferSource vertexConsumers;
    private final MultiBufferSource.BufferSource immediate;
    private final Font textRenderer;
    private final List<ClientCache.PlatformRouteDetails> routeData;
    private final String platformNumber;
    private final boolean vertical;
    private final boolean glowing;
    private static final int PASSED_STATION_COLOR = -6710887;
    private static final int STATION_CIRCLE_SIZE = 16;
    private static final int STATION_TEXT_PADDING = 14;
    private static final int STATION_NAME_BACKGROUND_PADDING = 3;
    private static final float COLOR_LINE_HALF_HEIGHT = 4.5f;
    private static final int INTERCHANGE_HALF_HEIGHT = 8;
    private static final int INTERCHANGE_LINE_SIZE = 10;
    private static final float PLATFORM_NUMBER_OFFSET_TOP = 0.63f;
    private static final String TEMP_CIRCULAR_MARKER = "temp_circular_marker";

    public RouteRenderer(PoseStack matrices, MultiBufferSource vertexConsumers, MultiBufferSource.BufferSource immediate, Platform platform, boolean vertical, boolean glowing) {
        this.matrices = matrices;
        this.vertexConsumers = vertexConsumers;
        this.immediate = immediate;
        ArrayList platformRouteDetails = platform == null ? null : ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id);
        this.routeData = platformRouteDetails == null ? new ArrayList() : platformRouteDetails;
        this.platformNumber = platform == null ? "1" : platform.name;
        this.vertical = vertical;
        this.glowing = glowing;
        this.textRenderer = Minecraft.m_91087_().f_91062_;
    }

    public void renderColorStrip(float x1, float y1, float z1, float x2, float y2, float z2, Direction facing, int light) {
        int routeCount = this.routeData.size();
        if (routeCount <= 0) {
            return;
        }
        this.matrices.m_85836_();
        int newLight = this.convertLight(light);
        VertexConsumer vertexConsumer = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/block/white.png", newLight, false));
        float lineHeightSmall = (y2 - y1) / (float)routeCount;
        for (int i = 0; i < routeCount; ++i) {
            int routeColor = this.routeData.get((int)i).routeColor | 0xFF000000;
            IDrawing.drawTexture(this.matrices, vertexConsumer, x1, y1 + lineHeightSmall * (float)i, z1, x2, y1 + lineHeightSmall * (float)(i + 1), z2, facing, routeColor, newLight);
        }
        this.matrices.m_85849_();
    }

    public void renderLine(float start, float end, float side1, float side2, int scale, Direction facing, int light, boolean skipText) {
        List filteredRouteData = this.routeData.stream().filter(platformRouteDetails -> platformRouteDetails.currentStationIndex < platformRouteDetails.stationDetails.size() - 1).collect(Collectors.toList());
        int routeCount = filteredRouteData.size();
        if (routeCount <= 0) {
            return;
        }
        int scaleSmaller = scale * routeCount;
        float routeHeight = (side2 - side1) * (float)scaleSmaller / (float)routeCount;
        float startScaled = start * (float)scaleSmaller;
        float endScaled = end * (float)scaleSmaller;
        float smallOffset = 0.003125f * (float)scaleSmaller;
        int newLight = this.convertLight(light);
        MultiBufferSource.BufferSource immediateFiltered = skipText ? null : this.immediate;
        for (int i = 0; i < routeCount; ++i) {
            int routeColor = ((ClientCache.PlatformRouteDetails)filteredRouteData.get((int)i)).routeColor | 0xFF000000;
            int currentStationIndex = ((ClientCache.PlatformRouteDetails)filteredRouteData.get((int)i)).currentStationIndex;
            List<ClientCache.PlatformRouteDetails.StationDetails> stationDetails = ((ClientCache.PlatformRouteDetails)filteredRouteData.get((int)i)).stationDetails;
            int routeLength = stationDetails.size();
            float routePosition = routeHeight * ((float)i + 0.5f) + side1 * (float)scaleSmaller;
            this.matrices.m_85836_();
            this.matrices.m_85841_(1.0f / (float)scaleSmaller, 1.0f / (float)scaleSmaller, 1.0f / (float)scaleSmaller);
            float thisStationPosition = this.getStationPosition(currentStationIndex, routeLength, startScaled, endScaled);
            VertexConsumer vertexConsumer = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/block/white.png", newLight, false));
            if (this.vertical) {
                IDrawing.drawTexture(this.matrices, vertexConsumer, routePosition - 4.5f, Math.min(thisStationPosition, endScaled), smallOffset, routePosition + 4.5f, Math.max(thisStationPosition, endScaled), smallOffset, facing, -6710887, newLight);
                IDrawing.drawTexture(this.matrices, vertexConsumer, routePosition - 4.5f, Math.min(startScaled, thisStationPosition), smallOffset, routePosition + 4.5f, Math.max(startScaled, thisStationPosition), smallOffset, facing, routeColor, newLight);
                IDrawing.drawStringWithFont(this.matrices, this.textRenderer, immediateFiltered, ((ClientCache.PlatformRouteDetails)filteredRouteData.get((int)i)).routeName, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, routePosition - routeHeight / 2.0f, startScaled, 0.125f * (float)scale, -1.0f, 1.0f, -16777216, false, newLight, null);
            } else {
                IDrawing.drawTexture(this.matrices, vertexConsumer, Math.min(startScaled, thisStationPosition), routePosition - 4.5f, smallOffset, Math.max(startScaled, thisStationPosition), routePosition + 4.5f, smallOffset, facing, -6710887, newLight);
                IDrawing.drawTexture(this.matrices, vertexConsumer, Math.min(thisStationPosition, endScaled), routePosition - 4.5f, smallOffset, Math.max(thisStationPosition, endScaled), routePosition + 4.5f, smallOffset, facing, routeColor, newLight);
            }
            for (int j = 0; j < routeLength; ++j) {
                IGui.HorizontalAlignment horizontalAlignment;
                IGui.VerticalAlignment verticalAlignment;
                float x = this.vertical ? routePosition : this.getStationPosition(j, routeLength, startScaled, endScaled);
                float y = this.vertical ? this.getStationPosition(j, routeLength, startScaled, endScaled) : routePosition;
                boolean onOrAfterStation = j >= currentStationIndex;
                boolean onStation = j == currentStationIndex;
                boolean bottomText = j % 2 == 0;
                List<ClientCache.ColorNameTuple> interchangeRoutes = stationDetails.get((int)j).interchangeRoutes;
                int interchangeCount = interchangeRoutes.size();
                VertexConsumer vertexConsumerStationCircle = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer(onOrAfterStation ? "mtr:textures/block/station_circle.png" : "mtr:textures/block/station_circle_passed.png", newLight, true));
                if (interchangeCount <= 1 || onStation) {
                    IDrawing.drawTexture(this.matrices, vertexConsumerStationCircle, x - 8.0f, y - 8.0f, 16.0f, 16.0f, facing, newLight);
                    if (!onStation && interchangeCount == 1) {
                        VertexConsumer vertexConsumerInterchange = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/block/interchange.png", newLight, true));
                        if (this.vertical) {
                            IDrawing.drawTexture(this.matrices, vertexConsumerInterchange, x + 8.0f, y - 5.0f, 10.0f, 10.0f, 0.625f, 0.3125f, 1.0f, 0.6875f, facing, onOrAfterStation ? interchangeRoutes.get((int)0).color | 0xFF000000 : -6710887, newLight);
                            IDrawing.drawStringWithFont(this.matrices, this.textRenderer, immediateFiltered, interchangeRoutes.get((int)0).name, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, x + 20.0f, y, 2.0f, onOrAfterStation ? -16777216 : -6710887, false, newLight, null);
                        } else {
                            verticalAlignment = bottomText ? IGui.VerticalAlignment.BOTTOM : IGui.VerticalAlignment.TOP;
                            float yLine = y + (bottomText ? -18.0f : 8.0f);
                            float yText = yLine + (float)(bottomText ? 0 : 10);
                            IDrawing.drawTexture(this.matrices, vertexConsumerInterchange, x - 5.0f, yLine, 10.0f, 10.0f, 0.3125f, bottomText ? 0.0f : 0.625f, 0.6875f, bottomText ? 0.375f : 1.0f, facing, onOrAfterStation ? interchangeRoutes.get((int)0).color | 0xFF000000 : -6710887, newLight);
                            IDrawing.drawStringWithFont(this.matrices, this.textRenderer, immediateFiltered, interchangeRoutes.get((int)0).name, IGui.HorizontalAlignment.CENTER, verticalAlignment, x, yText, 2.0f, onOrAfterStation ? -16777216 : -6710887, false, newLight, null);
                        }
                    }
                } else {
                    int totalHeight = (interchangeCount - (this.vertical ? 1 : 0)) * 8 * 2;
                    float y22 = this.vertical ? y - (float)totalHeight / 2.0f : (bottomText ? y - (float)totalHeight : y);
                    float y12 = y22 - 8.0f;
                    float y3 = y22 + (float)totalHeight;
                    IDrawing.drawTexture(this.matrices, vertexConsumerStationCircle, x - 8.0f, y12, 16.0f, 8.0f, 0.0f, 0.0f, 1.0f, 0.5f, facing, -1, newLight);
                    IDrawing.drawTexture(this.matrices, vertexConsumerStationCircle, x - 8.0f, y22, 16.0f, totalHeight, 0.0f, 0.49f, 1.0f, 0.51f, facing, -1, newLight);
                    IDrawing.drawTexture(this.matrices, vertexConsumerStationCircle, x - 8.0f, y3, 16.0f, 8.0f, 0.0f, 0.5f, 1.0f, 1.0f, facing, -1, newLight);
                    VertexConsumer vertexConsumerInterchange = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/block/interchange.png", newLight, true));
                    for (int k = 0; k < interchangeCount; ++k) {
                        float yLine = y22 + (float)((k + (this.vertical ? 0 : (bottomText ? 0 : 1))) * 8 * 2);
                        IDrawing.drawStringWithFont(this.matrices, this.textRenderer, immediateFiltered, interchangeRoutes.get((int)k).name, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, x + 20.0f, yLine, 2.0f, onOrAfterStation ? -16777216 : -6710887, false, newLight, null);
                        IDrawing.drawTexture(this.matrices, vertexConsumerInterchange, x + 8.0f, yLine - 5.0f, 10.0f, 10.0f, 0.625f, 0.3125f, 1.0f, 0.6875f, facing, onOrAfterStation ? interchangeRoutes.get((int)k).color | 0xFF000000 : -6710887, newLight);
                    }
                }
                IGui.HorizontalAlignment horizontalAlignment2 = horizontalAlignment = this.vertical ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.CENTER;
                verticalAlignment = this.vertical ? IGui.VerticalAlignment.CENTER : (bottomText ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM);
                IDrawing.drawStringWithFont(this.matrices, this.textRenderer, immediateFiltered, IGui.textOrUntitled(stationDetails.get((int)j).stationName), horizontalAlignment, verticalAlignment, x - (float)(this.vertical ? 14 : 0), y + (float)(this.vertical ? 0 : (bottomText ? 14 : -14)), 1.0f, onStation ? -1 : (onOrAfterStation ? -16777216 : -6710887), false, newLight, (x1, y1, x2, y2) -> {
                    if (onStation) {
                        this.matrices.m_85836_();
                        IDrawing.drawTexture(this.matrices, this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/block/white.png", newLight, false)), x1 - 3.0f, y1 - 3.0f, smallOffset, x2 + 3.0f, y2 + 3.0f, smallOffset, facing, -16777216, newLight);
                        this.matrices.m_85849_();
                    }
                });
            }
            this.matrices.m_85849_();
        }
    }

    public void renderArrow(float left, float right, float top, float bottom, boolean hasRight, boolean hasLeft, Direction facing, int light) {
    }

    public void renderArrow(float left, float right, float top, float bottom, boolean hasRight, boolean hasLeft, Direction facing, int light, boolean visibleArrow) {
        int routeCount = this.routeData.size();
        if (routeCount <= 0) {
            return;
        }
        float arrowSize = bottom - top;
        float arrowPadding = arrowSize / 4.0f;
        String destinationString = IGui.mergeStations(this.routeData.stream().filter(route -> route.currentStationIndex < route.stationDetails.size() - 1).map(route -> {
            if (route.circularState == Route.CircularState.NONE) {
                return route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName;
            }
            boolean isVia = false;
            String text = "";
            for (int i = route.currentStationIndex + 1; i < route.stationDetails.size() - 1; ++i) {
                if (route.stationDetails.get((int)i).interchangeRoutes.isEmpty()) continue;
                text = route.stationDetails.get((int)i).stationName;
                isVia = true;
                break;
            }
            if (!isVia) {
                text = route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName;
            }
            String translationString = String.format("%s_%s", route.circularState == Route.CircularState.CLOCKWISE ? "clockwise" : "anticlockwise", isVia ? "via" : "to");
            return TEMP_CIRCULAR_MARKER + IGui.insertTranslation("gui.mtr." + translationString + "_cjk", "gui.mtr." + translationString, 1, text);
        }).collect(Collectors.toList()));
        boolean noToString = destinationString.startsWith(TEMP_CIRCULAR_MARKER);
        if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER, "")).isEmpty() && visibleArrow && !noToString) {
            destinationString = IGui.insertTranslation("gui.mtr.to_cjk", "gui.mtr.to", 1, destinationString);
        }
        boolean leftToRight = hasLeft || !hasRight;
        float centerX = (left + right) / 2.0f;
        this.matrices.m_85836_();
        int newLight = this.convertLight(light);
        if (destinationString.isEmpty() && visibleArrow) {
            float chunkHeight = arrowSize / (float)routeCount;
            VertexConsumer vertexConsumerCircle = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/sign/circle.png", newLight, true));
            for (int i = 0; i < routeCount; ++i) {
                IDrawing.drawTexture(this.matrices, vertexConsumerCircle, centerX - arrowSize / 2.0f, top + (float)i * chunkHeight, arrowSize, chunkHeight, 0.0f, (float)i / (float)routeCount, 1.0f, (float)(i + 1) / (float)routeCount, facing, 0xFF000000 | this.routeData.get((int)i).routeColor, newLight);
            }
            this.matrices.m_85836_();
            this.matrices.m_85837_(0.0, 0.0, (double)-0.003125f);
            IDrawing.drawStringWithFont(this.matrices, this.textRenderer, this.immediate, this.platformNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, centerX, top + arrowSize * 0.63f, 27.0f / arrowSize / 2.2f, -1, false, newLight, null);
            this.matrices.m_85849_();
        } else {
            float textX;
            IGui.HorizontalAlignment horizontalAlignment2;
            IGui.HorizontalAlignment horizontalAlignment1;
            IGui.HorizontalAlignment horizontalAlignment = horizontalAlignment1 = leftToRight ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT;
            if (this.vertical && hasLeft != hasRight) {
                horizontalAlignment2 = horizontalAlignment1;
                float extraPadding = (arrowSize + arrowPadding) * (float)(visibleArrow ? 2 : 1);
                textX = hasLeft ? left + extraPadding : right - extraPadding;
            } else {
                horizontalAlignment2 = IGui.HorizontalAlignment.CENTER;
                textX = centerX + (arrowSize + arrowPadding) * ((hasLeft ? 0.5f : 0.0f) + (hasRight ? -0.5f : 0.0f) + (leftToRight ? 0.5f : -0.5f));
            }
            int textColor = this.vertical ? -1 : -16777216;
            float maxDestinationWidth = right - left - (arrowSize + arrowPadding) * (float)(1 + (hasLeft && visibleArrow ? 1 : 0) + (hasRight && visibleArrow ? 1 : 0));
            IDrawing.drawStringWithFont(this.matrices, this.textRenderer, this.immediate, destinationString, horizontalAlignment1, IGui.VerticalAlignment.CENTER, horizontalAlignment2, textX, (top + bottom) / 2.0f, maxDestinationWidth, arrowSize + arrowPadding, 27.0f / arrowSize, textColor, false, newLight, (x1, y1, x2, y2) -> {
                VertexConsumer vertexConsumerArrow = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/sign/arrow.png", newLight, true));
                if (hasLeft && visibleArrow) {
                    IDrawing.drawTexture(this.matrices, vertexConsumerArrow, x1 - arrowSize * 2.0f - arrowPadding * 2.0f, top, arrowSize, arrowSize, 0.0f, 0.0f, 1.0f, 1.0f, facing, textColor, newLight);
                }
                if (hasRight && visibleArrow) {
                    IDrawing.drawTexture(this.matrices, vertexConsumerArrow, x2 + arrowPadding + (leftToRight ? 0.0f : arrowSize + arrowPadding), top, arrowSize, arrowSize, 1.0f, 0.0f, 0.0f, 1.0f, facing, textColor, newLight);
                }
                VertexConsumer vertexConsumerCircle = this.vertexConsumers.m_6299_(RouteRenderer.getRenderLayer("mtr:textures/sign/circle.png", newLight, true));
                float chunkHeight = arrowSize / (float)routeCount;
                float circleX = leftToRight ? x1 - arrowSize - arrowPadding : x2 + arrowPadding;
                for (int i = 0; i < routeCount; ++i) {
                    IDrawing.drawTexture(this.matrices, vertexConsumerCircle, circleX, top + (float)i * chunkHeight, arrowSize, chunkHeight, 0.0f, (float)i / (float)routeCount, 1.0f, (float)(i + 1) / (float)routeCount, facing, 0xFF000000 | this.routeData.get((int)i).routeColor, newLight);
                }
                this.matrices.m_85836_();
                this.matrices.m_85837_(0.0, 0.0, (double)-0.003125f);
                IDrawing.drawStringWithFont(this.matrices, this.textRenderer, this.immediate, this.platformNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, circleX + arrowSize / 2.0f, top + arrowSize * 0.63f, 27.0f / arrowSize / 2.2f, -1, false, newLight, null);
                this.matrices.m_85849_();
            });
        }
        this.matrices.m_85849_();
    }

    private float getStationPosition(int stationIndex, int routeLength, float startScaled, float endScaled) {
        return (float)(this.vertical ? routeLength - stationIndex - 1 : stationIndex) * (endScaled - startScaled) / (float)(routeLength - 1) + startScaled;
    }

    private int convertLight(int light) {
        if (light == 0xF000F0 && !this.glowing) {
            return light & 0xE000F0;
        }
        return light;
    }

    private static RenderType getRenderLayer(String texture, int light, boolean isTranslucent) {
        return light == 0xF000F0 ? MoreRenderLayers.getLight(new ResourceLocation(texture), isTranslucent) : MoreRenderLayers.getExterior(new ResourceLocation(texture));
    }
}

