/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mtr.MTRClient;
import mtr.block.BlockNode;
import mtr.block.BlockPlatform;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.client.ResourcePackCreatorProperties;
import mtr.client.TrainClientRegistry;
import mtr.data.IGui;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.entity.EntitySeat;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.EntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelCableCarGrip;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class RenderTrains
extends EntityRendererMapper<EntitySeat>
implements IGui {
    public static int maxTrainRenderDistance;
    public static ResourcePackCreatorProperties creatorProperties;
    private static float lastRenderedTick;
    private static int prevPlatformCount;
    private static int prevSidingCount;
    private static UUID renderedUuid;
    public static final int PLAYER_RENDER_OFFSET = 1000;
    private static final Set<String> AVAILABLE_TEXTURES;
    private static final Set<String> UNAVAILABLE_TEXTURES;
    private static final int DETAIL_RADIUS = 32;
    private static final int DETAIL_RADIUS_SQUARED = 1024;
    private static final int MAX_RADIUS_REPLAY_MOD = 1024;
    private static final int TICKS_PER_SECOND = 20;
    private static final EntityModel<Minecart> MODEL_MINECART;
    private static final EntityModel<Boat> MODEL_BOAT;
    private static final Map<Long, FakeBoat> BOATS;
    private static final ModelCableCarGrip MODEL_CABLE_CAR_GRIP;

    public RenderTrains(Object parameter) {
        super(parameter);
    }

    public void render(EntitySeat entity, float entityYaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int entityLight) {
        RenderTrains.render(entity, tickDelta, matrices, vertexConsumers);
    }

    public ResourceLocation getTextureLocation(EntitySeat entity) {
        return null;
    }

    public static void render(EntitySeat entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers) {
        Vec3 cameraOffset;
        boolean useAnnouncements;
        boolean alreadyRendered;
        Minecraft client = Minecraft.m_91087_();
        boolean backupRendering = entity == null;
        boolean bl = alreadyRendered = renderedUuid != null && (backupRendering || entity.m_142081_() != renderedUuid);
        if (backupRendering) {
            renderedUuid = null;
        }
        LocalPlayer player = client.f_91074_;
        ClientLevel world = client.f_91073_;
        if (alreadyRendered || player == null || world == null) {
            return;
        }
        if (!backupRendering) {
            renderedUuid = entity.m_142081_();
        }
        int renderDistanceChunks = UtilitiesClient.getRenderDistance();
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        boolean bl2 = useAnnouncements = Config.useTTSAnnouncements() || Config.showAnnouncementMessages();
        if (Config.useDynamicFPS()) {
            if ((double)lastFrameDuration > 0.5) {
                maxTrainRenderDistance = Math.max(maxTrainRenderDistance - (maxTrainRenderDistance - 32) / 2, 32);
            } else if ((double)lastFrameDuration < 0.4) {
                maxTrainRenderDistance = Math.min(maxTrainRenderDistance + 1, renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1));
            }
        } else {
            maxTrainRenderDistance = renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1);
        }
        Camera camera = client.f_91063_.m_109153_();
        Vec3 vec3 = cameraOffset = camera.m_90594_() ? player.m_20299_(client.m_91296_()) : camera.m_90583_();
        if (!backupRendering) {
            matrices.m_85849_();
            matrices.m_85836_();
            Vec3 cameraPosition = camera.m_90583_();
            matrices.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
        }
        matrices.m_85836_();
        float cameraYaw = camera.m_90590_();
        boolean secondF5 = Math.abs(Utilities.getYaw((Entity)player) - cameraYaw) > 90.0f;
        double entityX = entity == null ? 0.0 : Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_());
        double entityY = entity == null ? 0.0 : Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_());
        double entityZ = entity == null ? 0.0 : Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_());
        ClientData.TRAINS.forEach(arg_0 -> RenderTrains.lambda$render$15((Level)world, client, lastFrameDuration, matrices, entity, entityX, entityY, entityZ, cameraOffset, player, cameraYaw, secondF5, vertexConsumers, camera, useAnnouncements, arg_0));
        if (!Config.hideTranslucentParts()) {
            ClientData.TRAINS.forEach(TrainClient::renderTranslucent);
        }
        boolean renderColors = RenderTrains.isHoldingRailRelated((Player)player);
        int maxRailDistance = renderDistanceChunks * 16;
        HashMap renderedRailMap = new HashMap();
        ClientData.RAILS.forEach((arg_0, arg_1) -> RenderTrains.lambda$render$18(player, maxRailDistance, renderedRailMap, (Level)world, matrices, vertexConsumers, renderColors, arg_0, arg_1));
        matrices.m_85849_();
        lastRenderedTick = MTRClient.getGameTick();
        if (prevPlatformCount != ClientData.PLATFORMS.size() || prevSidingCount != ClientData.SIDINGS.size()) {
            ClientData.DATA_CACHE.sync();
        }
        prevPlatformCount = ClientData.PLATFORMS.size();
        prevSidingCount = ClientData.SIDINGS.size();
        ClientData.DATA_CACHE.clearDataIfNeeded();
    }

    public static boolean shouldNotRender(BlockPos pos, int maxDistance, Direction facing) {
        Entity camera = Minecraft.m_91087_().f_91075_;
        return RenderTrains.shouldNotRender(camera == null ? null : camera.m_20182_(), pos, maxDistance, facing);
    }

    public static void clearTextureAvailability() {
        AVAILABLE_TEXTURES.clear();
        UNAVAILABLE_TEXTURES.clear();
    }

    public static boolean isHoldingRailRelated(Player player) {
        return Utilities.isHolding(player, item -> item instanceof ItemNodeModifierBase || Block.m_49814_((Item)item) instanceof BlockSignalLightBase || Block.m_49814_((Item)item) instanceof BlockNode || Block.m_49814_((Item)item) instanceof BlockSignalSemaphoreBase || Block.m_49814_((Item)item) instanceof BlockPlatform);
    }

    private static double maxDistanceXZ(Vec3 pos1, BlockPos pos2) {
        return Math.max(Math.abs(pos1.f_82479_ - (double)pos2.m_123341_()), Math.abs(pos1.f_82481_ - (double)pos2.m_123343_()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldNotRender(Vec3 cameraPos, BlockPos pos, int maxDistance, Direction facing) {
        double playerZOffset;
        double playerXOffset;
        boolean playerFacingAway = cameraPos == null || facing == null ? false : (facing.m_122434_() == Direction.Axis.X ? Math.signum(playerXOffset = cameraPos.f_82479_ - (double)pos.m_123341_() - 0.5) == (double)facing.m_122429_() && Math.abs(playerXOffset) >= 0.5 : Math.signum(playerZOffset = cameraPos.f_82481_ - (double)pos.m_123343_() - 0.5) == (double)facing.m_122431_() && Math.abs(playerZOffset) >= 0.5);
        if (cameraPos == null) return true;
        if (playerFacingAway) return true;
        double d = RenderTrains.maxDistanceXZ(cameraPos, pos);
        int n = MTRClient.isReplayMod() ? 1024 : maxDistance;
        if (!(d > (double)n)) return false;
        return true;
    }

    private static void renderRailStandard(Level world, PoseStack matrices, MultiBufferSource vertexConsumers, Rail rail, float yOffset, boolean renderColors, float railWidth) {
        RenderTrains.renderRailStandard(world, matrices, vertexConsumers, rail, yOffset, renderColors, railWidth, renderColors && rail.railType == RailType.QUARTZ ? "mtr:textures/block/rail_preview.png" : "textures/block/rail.png", -1.0f, -1.0f, -1.0f, -1.0f);
    }

    private static void renderRailStandard(Level world, PoseStack matrices, MultiBufferSource vertexConsumers, Rail rail, float yOffset, boolean renderColors, float railWidth, String texture, float u1, float v1, float u2, float v2) {
        int maxRailDistance = UtilitiesClient.getRenderDistance() * 16;
        rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
            BlockPos pos2 = new BlockPos(x1, y1, z1);
            if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                return;
            }
            int light2 = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, pos2), (int)world.m_45517_(LightLayer.SKY, pos2));
            if (rail.railType == RailType.NONE) {
                if (rail.transportMode != TransportMode.CABLE_CAR && renderColors) {
                    VertexConsumer vertexConsumerArrow = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(new ResourceLocation("mtr:textures/block/one_way_rail_arrow.png")));
                    IDrawing.drawTexture(matrices, vertexConsumerArrow, (float)x1, (float)y1 + yOffset, (float)z1, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x3, (float)y2 + yOffset, (float)z3, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, 0.0f, 0.25f, 1.0f, 0.75f, Direction.UP, -1, light2);
                    IDrawing.drawTexture(matrices, vertexConsumerArrow, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x1, (float)y1 + yOffset, (float)z1, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, (float)x3, (float)y2 + yOffset, (float)z3, 0.0f, 0.25f, 1.0f, 0.75f, Direction.UP, -1, light2);
                }
            } else {
                float textureOffset = (float)((int)(x1 + z1) % 4) * 0.25f + (float)Config.trackTextureOffset() / 32.0f;
                int color = renderColors || !Config.hideSpecialRailColors() && rail.railType.hasSavedRail ? rail.railType.color : -1;
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(new ResourceLocation(texture)));
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1 + yOffset, (float)z1, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x3, (float)y2 + yOffset, (float)z3, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, Direction.UP, color, light2);
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x1, (float)y1 + yOffset, (float)z1, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, (float)x3, (float)y2 + yOffset, (float)z3, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, Direction.UP, color, light2);
            }
        }, -railWidth, railWidth);
    }

    private static void renderSignalsStandard(Level world, PoseStack matrices, MultiBufferSource vertexConsumers, Rail rail, BlockPos startPos, BlockPos endPos) {
        int maxRailDistance = UtilitiesClient.getRenderDistance() * 16;
        List<SignalBlocks.SignalBlock> signalBlocks = ClientData.SIGNAL_BLOCKS.getSignalBlocksAtTrack(PathData.getRailProduct(startPos, endPos));
        float width = 1.0f / (float)DyeColor.values().length;
        for (int i = 0; i < signalBlocks.size(); ++i) {
            SignalBlocks.SignalBlock signalBlock = signalBlocks.get(i);
            boolean shouldGlow = signalBlock.isOccupied() && (int)Math.floor(MTRClient.getGameTick()) % 20 < 10;
            VertexConsumer vertexConsumer = shouldGlow ? vertexConsumers.m_6299_(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false)) : vertexConsumers.m_6299_(MoreRenderLayers.getExterior(new ResourceLocation("textures/block/white_wool.png")));
            float u1 = width * (float)i + 1.0f - width * (float)signalBlocks.size() / 2.0f;
            float u2 = u1 + width;
            int color = 0xFF000000 | signalBlock.color.m_41069_().f_76396_;
            rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                BlockPos pos2 = new BlockPos(x1, y1, z1);
                if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                    return;
                }
                int light2 = shouldGlow ? 0xF000F0 : LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, pos2), (int)world.m_45517_(LightLayer.SKY, pos2));
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1, (float)z1, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x3, (float)y2, (float)z3, (float)x4, (float)y2 + 0.003125f, (float)z4, u1, 0.0f, u2, 1.0f, Direction.UP, color, light2);
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x4, (float)y2 + 0.003125f, (float)z4, (float)x3, (float)y2, (float)z3, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x1, (float)y1, (float)z1, u1, 0.0f, u2, 1.0f, Direction.UP, color, light2);
            }, u1 - 1.0f, u2 - 1.0f);
        }
    }

    private static void renderWithLight(Level world, double x, double y, double z, boolean noOffset, RenderCallback renderCallback) {
        BlockPos posAverage;
        Entity camera = Minecraft.m_91087_().f_91075_;
        Vec3 cameraPos = camera == null ? null : camera.m_20182_();
        if (!RenderTrains.shouldNotRender(cameraPos, posAverage = new BlockPos(x + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82479_), y + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82480_), z + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82481_)), UtilitiesClient.getRenderDistance() * (Config.trainRenderDistanceRatio() + 1), null)) {
            renderCallback.renderCallback(LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage)), posAverage);
        }
    }

    private static Component getStationText(Station station, String textKey) {
        if (station != null) {
            return Text.literal(IGui.formatStationName(IGui.insertTranslation("gui.mtr." + textKey + "_station_cjk", "gui.mtr." + textKey + "_station", 1, IGui.textOrUntitled(station.name))));
        }
        return Text.literal("");
    }

    private static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, Vec3 pos1, Vec3 pos2, Vec3 pos3, Vec3 pos4, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, (float)pos1.f_82479_, (float)pos1.f_82480_, (float)pos1.f_82481_, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_, (float)pos3.f_82479_, (float)pos3.f_82480_, (float)pos3.f_82481_, (float)pos4.f_82479_, (float)pos4.f_82480_, (float)pos4.f_82481_, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -1, light);
    }

    private static ResourceLocation resolveTexture(String baseTrainType, String textureId, Function<String, String> formatter) {
        boolean available;
        String textureString = formatter.apply(textureId);
        ResourceLocation id = new ResourceLocation(textureString);
        if (!AVAILABLE_TEXTURES.contains(textureString) && !UNAVAILABLE_TEXTURES.contains(textureString)) {
            available = UtilitiesClient.hasResource(id);
            (available ? AVAILABLE_TEXTURES : UNAVAILABLE_TEXTURES).add(textureString);
            if (!available) {
                System.out.println("Texture " + textureString + " not found, using default");
            }
        } else {
            available = AVAILABLE_TEXTURES.contains(textureString);
        }
        if (available) {
            return id;
        }
        String newTextureId = TrainClientRegistry.getTrainProperties((String)baseTrainType).textureId;
        return new ResourceLocation(newTextureId == null ? "mtr:textures/block/transparent.png" : formatter.apply(newTextureId));
    }

    private static ResourceLocation getConnectorTextureString(TrainClientRegistry.TrainProperties trainProperties, boolean isConnector, String partName) {
        return RenderTrains.resolveTexture(trainProperties.baseTrainType, isConnector ? trainProperties.gangwayConnectionId : trainProperties.trainBarrierId, textureId -> String.format("%s_%s_%s.png", textureId, isConnector ? "connector" : "barrier", partName));
    }

    @Deprecated
    public static float getGameTicks() {
        return MTRClient.getGameTick();
    }

    private static /* synthetic */ void lambda$render$18(LocalPlayer player, int maxRailDistance, Map renderedRailMap, Level world, PoseStack matrices, MultiBufferSource vertexConsumers, boolean renderColors, BlockPos startPos, Map railMap) {
        railMap.forEach((endPos, rail) -> {
            if (!RailwayData.isBetween(player.m_20185_(), startPos.m_123341_(), endPos.m_123341_(), maxRailDistance) || !RailwayData.isBetween(player.m_20189_(), startPos.m_123343_(), endPos.m_123343_(), maxRailDistance)) {
                return;
            }
            UUID railProduct = PathData.getRailProduct(startPos, endPos);
            if (renderedRailMap.containsKey(railProduct)) {
                if (renderedRailMap.get(railProduct) == rail.railType) {
                    return;
                }
            } else {
                renderedRailMap.put(railProduct, rail.railType);
            }
            switch (rail.transportMode) {
                case TRAIN: {
                    RenderTrains.renderRailStandard(world, matrices, vertexConsumers, rail, 0.065625f, renderColors, 1.0f);
                    if (!renderColors) break;
                    RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                    break;
                }
                case BOAT: {
                    if (!renderColors) break;
                    RenderTrains.renderRailStandard(world, matrices, vertexConsumers, rail, 0.065625f, true, 0.5f);
                    RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                    break;
                }
                case CABLE_CAR: {
                    if (rail.railType.hasSavedRail || rail.railType == RailType.CABLE_CAR_STATION) {
                        RenderTrains.renderRailStandard(world, matrices, vertexConsumers, rail, 0.253125f, renderColors, 0.25f, "mtr:textures/block/metal.png", 0.25f, 0.0f, 0.75f, 1.0f);
                    }
                    if (renderColors && !rail.railType.hasSavedRail) {
                        RenderTrains.renderRailStandard(world, matrices, vertexConsumers, rail, 0.503125f, true, 1.0f, "mtr:textures/block/one_way_rail_arrow.png", 0.0f, 0.75f, 1.0f, 0.25f);
                    }
                    if (rail.railType == RailType.NONE) break;
                    rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                        int r = renderColors ? rail.railType.color >> 16 & 0xFF : 0;
                        int g = renderColors ? rail.railType.color >> 8 & 0xFF : 0;
                        int b = renderColors ? rail.railType.color & 0xFF : 0;
                        IDrawing.drawLine(matrices, vertexConsumers, (float)x1, (float)y1 + 0.5f, (float)z1, (float)x3, (float)y2 + 0.5f, (float)z3, r, g, b);
                    }, 0.0f, 0.0f);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$render$15(Level world, Minecraft client, float lastFrameDuration, PoseStack matrices, EntitySeat entity, double entityX, double entityY, double entityZ, Vec3 cameraOffset, LocalPlayer player, float cameraYaw, boolean secondF5, MultiBufferSource vertexConsumers, Camera camera, boolean useAnnouncements, TrainClient train) {
        train.simulateTrain(world, client.m_91104_() || lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration, (x, y, z, yaw, pitch, trainId, transportMode, currentCar, trainCars, head1IsFront, doorLeftValue, doorRightValue, opening, lightsOn, isTranslucent, playerOffset, ridingPositions) -> RenderTrains.renderWithLight(world, x, y, z, playerOffset == null, (light, posAverage) -> {
            TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId);
            if (trainProperties.model == null && isTranslucent) {
                return;
            }
            matrices.m_85836_();
            if (playerOffset != null) {
                double offsetZ;
                double offsetY;
                double offsetX;
                if (MTRClient.isVivecraft() && entity != null) {
                    offsetX = entityX;
                    offsetY = entityY;
                    offsetZ = entityZ;
                } else {
                    offsetX = cameraOffset.f_82479_;
                    offsetY = cameraOffset.f_82480_;
                    offsetZ = cameraOffset.f_82481_;
                }
                matrices.m_85837_(offsetX, offsetY, offsetZ);
                matrices.m_85845_(Vector3f.f_122225_.m_122240_(Utilities.getYaw((Entity)player) - cameraYaw + (float)(secondF5 ? 180 : 0)));
                matrices.m_85837_(-playerOffset.f_82479_, -playerOffset.f_82480_, -playerOffset.f_82481_);
            }
            matrices.m_85836_();
            matrices.m_85837_(x, y, z);
            matrices.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI + yaw));
            matrices.m_85845_(Vector3f.f_122223_.m_122270_((float)Math.PI + (transportMode.hasPitch ? pitch : 0.0f)));
            if (trainProperties.model == null || trainProperties.textureId == null) {
                boolean isBoat = transportMode == TransportMode.BOAT;
                matrices.m_85837_(0.0, isBoat ? 0.875 : 0.5, 0.0);
                matrices.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                EntityModel<Boat> model = isBoat ? MODEL_BOAT : MODEL_MINECART;
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(model.m_103119_(RenderTrains.resolveTexture(trainProperties.baseTrainType, trainProperties.textureId, textureId -> textureId + ".png")));
                if (isBoat) {
                    if (!BOATS.containsKey(train.id)) {
                        BOATS.put(train.id, new FakeBoat());
                    }
                    MODEL_BOAT.m_6973_((Entity)BOATS.get(train.id), (train.getSpeed() + 0.01f) * (doorLeftValue == 0.0f && doorRightValue == 0.0f ? lastFrameDuration : 0.0f), 0.0f, -0.1f, 0.0f, 0.0f);
                } else {
                    model.m_6973_(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
                }
                model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                try {
                    boolean renderDetails = MTRClient.isReplayMod() || posAverage.m_123331_((Vec3i)camera.m_90588_()) <= 1024.0;
                    trainProperties.model.render(matrices, vertexConsumers, RenderTrains.resolveTexture(trainProperties.baseTrainType, trainProperties.textureId, textureId -> textureId + ".png"), light, doorLeftValue, doorRightValue, opening, currentCar, trainCars, head1IsFront, lightsOn, isTranslucent, renderDetails);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (transportMode == TransportMode.CABLE_CAR) {
                matrices.m_85837_(0.0, (double)TransportMode.CABLE_CAR.railOffset + 0.5, 0.0);
                if (!transportMode.hasPitch) {
                    matrices.m_85845_(Vector3f.f_122223_.m_122270_(pitch));
                }
                if (trainId.endsWith("_rht")) {
                    matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                }
                MODEL_CABLE_CAR_GRIP.render(matrices, vertexConsumers, light);
            }
            matrices.m_85849_();
            EntityRenderDispatcher entityRenderDispatcher = client.m_91290_();
            matrices.m_85836_();
            matrices.m_85837_(0.0, 1000.0, 0.0);
            ridingPositions.forEach((uuid, offset) -> {
                Player renderPlayer = world.m_46003_(uuid);
                if (renderPlayer != null && (!uuid.equals(player.m_142081_()) || camera.m_90594_())) {
                    entityRenderDispatcher.m_114384_((Entity)renderPlayer, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0f, 1.0f, matrices, vertexConsumers, 0xF000F0);
                }
            });
            matrices.m_85849_();
            matrices.m_85849_();
        }), (prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, trainId, lightsOn, isConnector, playerOffset) -> RenderTrains.renderWithLight(world, x, y, z, playerOffset == null, (light, posAverage) -> {
            TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId);
            if (trainProperties.textureId == null) {
                return;
            }
            matrices.m_85836_();
            if (playerOffset != null) {
                double offsetZ;
                double offsetY;
                double offsetX;
                if (MTRClient.isVivecraft() && entity != null) {
                    offsetX = entityX;
                    offsetY = entityY;
                    offsetZ = entityZ;
                } else {
                    offsetX = cameraOffset.f_82479_;
                    offsetY = cameraOffset.f_82480_;
                    offsetZ = cameraOffset.f_82481_;
                }
                matrices.m_85837_(offsetX, offsetY, offsetZ);
                matrices.m_85845_(Vector3f.f_122225_.m_122240_(Utilities.getYaw((Entity)player) - cameraYaw + (float)(secondF5 ? 180 : 0)));
                matrices.m_85837_(-playerOffset.f_82479_, -playerOffset.f_82480_, -playerOffset.f_82481_);
            }
            VertexConsumer vertexConsumerExterior = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(RenderTrains.getConnectorTextureString(trainProperties, isConnector, "exterior")));
            RenderTrains.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, light);
            RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, light);
            if (isConnector) {
                RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos3, prevPos2, light);
                RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos1, thisPos4, thisPos1, prevPos4, light);
                int lightOnLevel = lightsOn ? 0xF000B0 : light;
                VertexConsumer vertexConsumerSide = vertexConsumers.m_6299_(MoreRenderLayers.getInterior(RenderTrains.getConnectorTextureString(trainProperties, true, "side")));
                RenderTrains.drawTexture(matrices, vertexConsumerSide, thisPos3, prevPos2, prevPos1, thisPos4, lightOnLevel);
                RenderTrains.drawTexture(matrices, vertexConsumerSide, prevPos3, thisPos2, thisPos1, prevPos4, lightOnLevel);
                RenderTrains.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getInterior(RenderTrains.getConnectorTextureString(trainProperties, true, "roof"))), prevPos2, thisPos3, thisPos2, prevPos3, lightOnLevel);
                RenderTrains.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getInterior(RenderTrains.getConnectorTextureString(trainProperties, true, "floor"))), prevPos4, thisPos1, thisPos4, prevPos1, lightOnLevel);
            } else {
                RenderTrains.drawTexture(matrices, vertexConsumerExterior, thisPos3, prevPos2, prevPos1, thisPos4, light);
                RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos1, prevPos4, light);
            }
            matrices.m_85849_();
        }), (speed, stopIndex, routeIds) -> {
            if (!(speed <= 5.0f) || !RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> player.m_5661_(switch ((int)(System.currentTimeMillis() / 1000L % 3L)) {
                default -> RenderTrains.getStationText(thisStation, "this");
                case 1 -> {
                    if (nextStation == null) {
                        yield RenderTrains.getStationText(thisStation, "this");
                    }
                    yield RenderTrains.getStationText(nextStation, "next");
                }
                case 2 -> RenderTrains.getStationText(lastStation, "last_" + thisRoute.transportMode.toString().toLowerCase());
            }, true))) {
                player.m_5661_((Component)Text.translatable("gui.mtr.vehicle_speed", Float.valueOf(RailwayData.round(speed, 1)), Float.valueOf(RailwayData.round(speed * 3.6f, 1))), true);
            }
        }, (stopIndex, routeIds) -> {
            if (useAnnouncements) {
                RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                    String nextRouteSplit;
                    ArrayList<String> messages = new ArrayList<String>();
                    String thisRouteSplit = thisRoute.name.split("\\|\\|")[0];
                    String string = nextRouteSplit = nextRoute == null ? null : nextRoute.name.split("\\|\\|")[0];
                    if (nextStation != null) {
                        Station nextFinalStation;
                        List<String> interchangeRoutes;
                        String mergedStations;
                        boolean isLightRailRoute = thisRoute.isLightRailRoute;
                        messages.add(IGui.insertTranslation(isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement_cjk" : "gui.mtr.next_station_announcement_cjk", isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement" : "gui.mtr.next_station_announcement", 1, nextStation.name));
                        Map<Integer, ClientCache.ColorNameTuple> routesInStation = ClientData.DATA_CACHE.stationIdToRoutes.get(nextStation.id);
                        if (routesInStation != null && !(mergedStations = IGui.mergeStations(interchangeRoutes = routesInStation.values().stream().filter(interchangeRoute -> {
                            String routeName = interchangeRoute.name.split("\\|\\|")[0];
                            return !routeName.equals(thisRouteSplit) && (nextRoute == null || !routeName.equals(nextRouteSplit));
                        }).map(interchangeRoute -> interchangeRoute.name).collect(Collectors.toList()), ", ")).isEmpty()) {
                            messages.add(IGui.insertTranslation("gui.mtr.interchange_announcement_cjk", "gui.mtr.interchange_announcement", 1, mergedStations));
                        }
                        if (lastStation != null && nextStation.id == lastStation.id && nextRoute != null && !nextRoute.platformIds.isEmpty() && !nextRouteSplit.equals(thisRouteSplit) && (nextFinalStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(nextRoute.platformIds.get(nextRoute.platformIds.size() - 1))) != null) {
                            String modeString = thisRoute.transportMode.toString().toLowerCase();
                            if (nextRoute.isLightRailRoute) {
                                messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_light_rail_announcement_cjk", "gui.mtr.next_route_" + modeString + "_light_rail_announcement", nextRoute.lightRailRouteNumber, 1, nextFinalStation.name.split("\\|\\|")[0]));
                            } else {
                                messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_announcement_cjk", "gui.mtr.next_route_" + modeString + "_announcement", 2, nextRouteSplit, nextFinalStation.name.split("\\|\\|")[0]));
                            }
                        }
                    }
                    IDrawing.narrateOrAnnounce(IGui.mergeStations(messages, " "));
                });
            }
        }, (stopIndex, routeIds) -> {
            if (useAnnouncements) {
                RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                    if (thisRoute.isLightRailRoute && lastStation != null) {
                        IDrawing.narrateOrAnnounce(IGui.insertTranslation("gui.mtr.light_rail_route_announcement_cjk", "gui.mtr.light_rail_route_announcement", thisRoute.lightRailRouteNumber, 1, lastStation.name));
                    }
                });
            }
        });
    }

    static {
        creatorProperties = new ResourcePackCreatorProperties();
        AVAILABLE_TEXTURES = new HashSet<String>();
        UNAVAILABLE_TEXTURES = new HashSet<String>();
        MODEL_MINECART = UtilitiesClient.getMinecartModel();
        MODEL_BOAT = UtilitiesClient.getBoatModel();
        BOATS = new HashMap<Long, FakeBoat>();
        MODEL_CABLE_CAR_GRIP = new ModelCableCarGrip();
    }

    @FunctionalInterface
    private static interface RenderCallback {
        public void renderCallback(int var1, BlockPos var2);
    }

    private static class FakeBoat
    extends Boat {
        private float progress;

        public FakeBoat() {
            super(EntityType.f_20552_, null);
        }

        public float m_38315_(int paddle, float newProgress) {
            this.progress += newProgress;
            return this.progress;
        }
    }
}

