/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import mtr.block.BlockRouteSignBase;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;

public class RenderRouteSign<T extends BlockRouteSignBase.TileEntityRouteSignBase>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    private static final float SIDE = 0.15625f;
    private static final float BOTTOM = 0.65625f;
    private static final float MIDDLE = 0.8125f;
    private static final float TOP = 0.96875f;
    private static final float WIDTH = 0.6875f;
    private static final float HEIGHT_BOTTOM = 1.15625f;
    private static final float HEIGHT_TOP = 0.15625f;
    private static final float TEXTURE_BREAK = 0.7027027f;

    public RenderRouteSign(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState state;
        Direction facing;
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, facing = (Direction)IBlock.getStatePropertySafe(state = world.m_8055_(pos), BlockStationNameBase.f_54117_))) {
            return;
        }
        boolean isTop = IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER;
        int arrowDirection = (Integer)IBlock.getStatePropertySafe(state, BlockRouteSignBase.ARROW_DIRECTION);
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        if (station == null) {
            return;
        }
        Map<Long, Platform> platformPositions = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
        if (platformPositions == null || platformPositions.isEmpty()) {
            return;
        }
        Platform platform = platformPositions.get(((BlockRouteSignBase.TileEntityRouteSignBase)((Object)entity)).getPlatformId());
        if (platform == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        matrices.m_85845_(Vector3f.f_122224_.m_122240_(facing.m_122435_()));
        matrices.m_85837_(-0.5, 0.0, 0.43124999990686774);
        VertexConsumer vertexConsumer1 = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getDirectionArrow(platform.id, true, (arrowDirection & 1) > 0, (arrowDirection & 2) > 0, IGui.HorizontalAlignment.CENTER, true, 0.2f, 4.4f, false)));
        IDrawing.drawTexture(matrices, vertexConsumer1, 0.84375f, 0.96875f + (float)(!isTop ? 1 : 0), 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing.m_122424_(), -1, light);
        VertexConsumer vertexConsumer2 = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getRouteMap(platform.id, true, false, 1.6818181f, false)));
        IDrawing.drawTexture(matrices, vertexConsumer2, 0.84375f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.84375f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, isTop ? 0.7027027f : 1.0f, 1.0f, facing.m_122424_(), -1, light);
        matrices.m_85849_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }
}

