/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RenderRouteBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    protected float bottomPadding;
    protected float topPadding;
    protected final float sidePadding;
    private final float z;
    private final boolean transparentWhite;
    private final Property<Integer> arrowDirectionProperty;

    public RenderRouteBase(BlockEntityRenderDispatcher dispatcher, float z, float sidePadding, boolean transparentWhite, Property<Integer> arrowDirectionProperty) {
        super(dispatcher);
        this.z = z / 16.0f;
        this.sidePadding = sidePadding / 16.0f;
        this.transparentWhite = transparentWhite;
        this.arrowDirectionProperty = arrowDirectionProperty;
    }

    public final void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        long platformId;
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
        this.renderAdditionalUnmodified(matrices, vertexConsumers, state, facing, light);
        if (!RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null) && (platformId = RailwayData.getClosePlatformId(ClientData.PLATFORMS, ClientData.DATA_CACHE, pos)) != 0L) {
            matrices.m_85837_(0.0, 1.0, 0.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrices.m_85837_(-0.5, 0.0, (double)this.z);
            int leftBlocks = this.getTextureNumber((BlockGetter)world, pos, facing, true);
            int rightBlocks = this.getTextureNumber((BlockGetter)world, pos, facing, false);
            int colorByte = this.transparentWhite && facing.m_122434_() == Direction.Axis.X ? 191 : 255;
            int color = 0xFF000000 | (colorByte << 16) + (colorByte << 8) + colorByte;
            RenderType renderType = this.getRenderType((BlockGetter)world, pos.m_5484_(facing.m_122428_(), leftBlocks), state);
            if ((renderType == RenderType.ARROW || renderType == RenderType.ROUTE) && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                int arrowDirection = IBlock.getStatePropertySafe(state, this.arrowDirectionProperty);
                VertexConsumer vertexConsumer = renderType == RenderType.ARROW ? vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getDirectionArrow(platformId, false, (arrowDirection & 1) > 0, (arrowDirection & 2) > 0, IGui.HorizontalAlignment.CENTER, true, 0.25f, width / height, this.transparentWhite))) : vertexConsumers.m_6299_(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getRouteMap(platformId, false, arrowDirection == 2, width / height, this.transparentWhite)));
                IDrawing.drawTexture(matrices, vertexConsumer, leftBlocks == 0 ? this.sidePadding : 0.0f, this.topPadding, 0.0f, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), 1.0f - this.bottomPadding, 0.0f, ((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing.m_122424_(), color, light);
            }
            this.renderAdditional(matrices, vertexConsumers, platformId, state, leftBlocks, rightBlocks, facing.m_122424_(), color, light);
        }
        matrices.m_85849_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    protected void renderAdditionalUnmodified(PoseStack matrices, MultiBufferSource vertexConsumers, BlockState state, Direction facing, int light) {
    }

    protected boolean isLeft(BlockState state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.LEFT;
    }

    protected boolean isRight(BlockState state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.RIGHT;
    }

    protected abstract RenderType getRenderType(BlockGetter var1, BlockPos var2, BlockState var3);

    protected abstract void renderAdditional(PoseStack var1, MultiBufferSource var2, long var3, BlockState var5, int var6, int var7, Direction var8, int var9, int var10);

    private int getTextureNumber(BlockGetter world, BlockPos pos, Direction facing, boolean searchLeft) {
        BlockState state;
        int number = 0;
        Block thisBlock = world.m_8055_(pos).m_60734_();
        while ((state = world.m_8055_(pos.m_5484_(searchLeft ? facing.m_122428_() : facing.m_122427_(), number))).m_60734_() == thisBlock) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            if (number != 0 && !(searchLeft ? !isRight : !isLeft)) break;
            ++number;
            if (!(searchLeft ? isLeft : isRight)) continue;
            break;
        }
        return number - 1;
    }

    protected static enum RenderType {
        ARROW,
        ROUTE,
        NONE;

    }
}

