/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.entity.EntityLift;
import mtr.mappings.EntityRendererMapper;
import mtr.model.ModelLift1;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderLift
extends EntityRendererMapper<EntityLift>
implements IGui {
    public static final int LIGHT_COLOR = -65536;
    private static final ResourceLocation LIFT_TEXTURE = new ResourceLocation("mtr:textures/entity/lift_1.png");
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("mtr:textures/sign/lift_arrow.png");

    public RenderLift(Object parameter) {
        super(parameter);
    }

    public void render(EntityLift entity, float entityYaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.m_85836_();
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        new ModelLift1(entity.liftType).render(matrices, vertexConsumers, LIFT_TEXTURE, light, entity.getFrontDoorValueClient(), entity.getBackDoorValueClient(), false, 0, 1, false, true, false, false);
        for (int i = 0; i < (entity.liftType.isDoubleSided ? 2 : 1); ++i) {
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            matrices.m_85836_();
            matrices.m_85837_(0.875, -1.5, (double)((float)entity.liftType.depth / 2.0f) - 0.25 - (double)0.003125f);
            RenderLift.renderLiftDisplay(matrices, vertexConsumers, entity.m_142538_(), entity.getCurrentFloorDisplay()[0], entity.getLiftDirectionClient(), 0.1875f, 0.3125f);
            matrices.m_85849_();
        }
        matrices.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityLift entity) {
        return null;
    }

    public static void renderLiftDisplay(PoseStack matrices, MultiBufferSource vertexConsumers, BlockPos pos, String floorNumber, EntityLift.LiftDirection liftDirection, float maxWidth, float height) {
        if (RenderTrains.shouldNotRender(pos, Math.min(16, RenderTrains.maxTrainRenderDistance), null)) {
            return;
        }
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        IDrawing.drawStringWithFont(matrices, Minecraft.m_91087_().f_91062_, immediate, floorNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0.0f, height, maxWidth, -1.0f, 18.0f / maxWidth, -65536, false, 0xF000F0, null);
        immediate.m_109911_();
        if (liftDirection != EntityLift.LiftDirection.NONE) {
            IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getLight(ARROW_TEXTURE, true)), -maxWidth / 6.0f, 0.0f, maxWidth / 3.0f, maxWidth / 3.0f, 0.0f, liftDirection == EntityLift.LiftDirection.UP ? 0.0f : 1.0f, 1.0f, liftDirection == EntityLift.LiftDirection.UP ? 1.0f : 0.0f, Direction.UP, -65536, 0xF000F0);
        }
    }
}

