/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.POIMarker;
import de.bluecolored.bluemap.api.marker.Shape;
import de.bluecolored.bluemap.api.marker.ShapeMarker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import mtr.data.AreaBase;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.packet.IUpdateWebMap;
import net.minecraft.world.level.Level;

public class UpdateBlueMap
implements IGui,
IUpdateWebMap {
    private static String bluemapStationIcon = "";
    private static String bluemapDepotIcon = "";

    public static void updateBlueMap(Level world, RailwayData railwayData) {
        try {
            UpdateBlueMap.updateBlueMap(world, railwayData.stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", bluemapStationIcon);
            UpdateBlueMap.updateBlueMap(world, railwayData.depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", bluemapDepotIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends AreaBase> void updateBlueMap(Level world, Set<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) throws IOException {
        BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
        if (api == null) {
            return;
        }
        String worldId = world.m_46472_().m_135782_().m_135815_();
        BlueMapMap map = api.getMaps().stream().filter(map1 -> worldId.contains(map1.getId())).findFirst().orElse(null);
        if (map == null) {
            return;
        }
        MarkerAPI markerApi = api.getMarkerAPI();
        int areaY = world.m_5736_();
        MarkerSet markerSetAreas = markerApi.createMarkerSet(areasId);
        markerSetAreas.setLabel(areasTitle);
        markerSetAreas.getMarkers().forEach(marker -> {
            if (marker.getId().startsWith("1_" + worldId)) {
                markerSetAreas.removeMarker(marker);
            }
        });
        MarkerSet markerSetAreaAreas = markerApi.createMarkerSet(areaAreasId);
        markerSetAreaAreas.setLabel(areaAreasTitle);
        markerSetAreaAreas.setDefaultHidden(true);
        markerSetAreaAreas.getMarkers().forEach(marker -> {
            if (marker.getId().startsWith("2_" + worldId)) {
                markerSetAreaAreas.removeMarker(marker);
            }
        });
        IUpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
            POIMarker markerArea = markerSetAreas.createPOIMarker("1_" + worldId + id, map, (double)areaX, (double)areaY, (double)areaZ);
            markerArea.setLabel(name);
            markerArea.setIcon(iconKey, 12, 12);
            ShapeMarker markerAreaArea = markerSetAreaAreas.createShapeMarker("2_" + worldId + id, map, (double)areaX, (double)areaY, (double)areaZ, Shape.createRect((double)areaCorner1X, (double)areaCorner1Z, (double)areaCorner2X, (double)areaCorner2Z), (float)areaY);
            markerAreaArea.setLabel(name);
            markerAreaArea.setFillColor(new Color(color.getRGB() & 0xFFFFFF | 0x7F000000, true));
            markerAreaArea.setLineColor(color.darker());
        });
        markerApi.save();
    }

    private static void resizeImage(InputStream inputStream, Consumer<BufferedImage> callback) {
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            BufferedImage newBufferedImage = new BufferedImage(24, 24, bufferedImage.getType());
            newBufferedImage.getGraphics().drawImage(bufferedImage.getScaledInstance(24, 24, 4), 0, 0, null);
            callback.accept(newBufferedImage);
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            BlueMapAPI.getInstance().ifPresent(api -> {
                IUpdateWebMap.readResource("/assets/mtr/textures/sign/logo.png", inputStream -> UpdateBlueMap.resizeImage(inputStream, bufferedImage -> {
                    try {
                        bluemapStationIcon = api.createImage(bufferedImage, "mtr_station_bluemap");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                IUpdateWebMap.readResource("/assets/mtr/textures/sign/logo_grayscale.png", inputStream -> UpdateBlueMap.resizeImage(inputStream, bufferedImage -> {
                    try {
                        bluemapDepotIcon = api.createImage(bufferedImage, "mtr_depot_bluemap");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

