/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.model.ModelTrainBase;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelDoorOverlay
extends EntityModel<Entity> {
    private final ModelMapper door_left_overlay_interior;
    private final ModelMapper door_left_top_r1;
    private final ModelMapper door_right_overlay_interior;
    private final ModelMapper door_right_top_r1;
    private final ModelMapper door_right_bottom_r1;
    private final ModelMapper door_left_overlay_exterior;
    private final ModelMapper door_left_top_r2;
    private final ModelMapper door_right_overlay_exterior;
    private final ModelMapper door_right_top_r2;
    private final ModelMapper wall_1;
    private final ModelMapper upper_wall_1_r1;
    private final ModelMapper wall_2;
    private final ModelMapper upper_wall_2_r1;
    private final ResourceLocation doorOverlayTextureLeft;
    private final ResourceLocation doorOverlayTextureRight;
    private final boolean renderLeft;
    private final boolean renderRight;

    public ModelDoorOverlay(int doorMax, float angle, String overlayLeftTextureName, String overlayRightTextureName) {
        this(doorMax, angle, 14, overlayLeftTextureName, overlayRightTextureName, true, true);
    }

    public ModelDoorOverlay(int doorMax, float angle, int pivotY, String overlayLeftTextureName, String overlayRightTextureName) {
        this(doorMax, angle, pivotY, overlayLeftTextureName, overlayRightTextureName, true, true);
    }

    public ModelDoorOverlay(int doorMax, float angle, int pivotY, String overlayLeftTextureName, String overlayRightTextureName, boolean renderLeft, boolean renderRight) {
        float angleRadians = (float)Math.toRadians(angle);
        this.doorOverlayTextureLeft = new ResourceLocation("mtr:textures/sign/" + overlayLeftTextureName);
        this.doorOverlayTextureRight = new ResourceLocation("mtr:textures/sign/" + overlayRightTextureName);
        this.renderLeft = renderLeft;
        this.renderRight = renderRight;
        int textureWidth = 38;
        int textureHeight = 32;
        ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, 38, 32);
        this.door_left_overlay_interior = new ModelMapper(modelDataWrapper);
        this.door_left_overlay_interior.setPos(0.0f, 24.0f, 0.0f);
        this.door_left_overlay_interior.texOffs(3, 3).addBox(-19.7f, -pivotY, 0.0f, 0, 13, 16, 0.0f, false);
        this.door_left_top_r1 = new ModelMapper(modelDataWrapper);
        this.door_left_top_r1.setPos(-19.7f, -pivotY, 0.0f);
        this.door_left_overlay_interior.addChild(this.door_left_top_r1);
        ModelTrainBase.setRotationAngle(this.door_left_top_r1, 0.0f, 0.0f, angleRadians);
        this.door_left_top_r1.texOffs(3, -16).addBox(0.0f, -19.0f, 0.0f, 0, 19, 16, 0.0f, false);
        this.door_right_overlay_interior = new ModelMapper(modelDataWrapper);
        this.door_right_overlay_interior.setPos(0.0f, 24.0f, 0.0f);
        this.door_right_top_r1 = new ModelMapper(modelDataWrapper);
        this.door_right_top_r1.setPos(-19.7f, -pivotY, 0.0f);
        this.door_right_overlay_interior.addChild(this.door_right_top_r1);
        ModelTrainBase.setRotationAngle(this.door_right_top_r1, 0.0f, 3.1416f, angleRadians);
        this.door_right_top_r1.texOffs(3, -16).addBox(0.0f, -19.0f, 0.0f, 0, 19, 16, 0.0f, false);
        this.door_right_bottom_r1 = new ModelMapper(modelDataWrapper);
        this.door_right_bottom_r1.setPos(0.0f, 0.0f, 0.0f);
        this.door_right_overlay_interior.addChild(this.door_right_bottom_r1);
        ModelTrainBase.setRotationAngle(this.door_right_bottom_r1, 0.0f, 3.1416f, 0.0f);
        this.door_right_bottom_r1.texOffs(3, 3).addBox(19.7f, -pivotY, 0.0f, 0, 13, 16, 0.0f, false);
        this.door_left_overlay_exterior = new ModelMapper(modelDataWrapper);
        this.door_left_overlay_exterior.setPos(0.0f, 24.0f, 0.0f);
        this.door_left_top_r2 = new ModelMapper(modelDataWrapper);
        this.door_left_top_r2.setPos(-20.7f, -pivotY, 0.0f);
        this.door_left_overlay_exterior.addChild(this.door_left_top_r2);
        ModelTrainBase.setRotationAngle(this.door_left_top_r2, 0.0f, 0.0f, angleRadians);
        this.door_left_top_r2.texOffs(3, -16).addBox(0.0f, -19.0f, 0.0f, 0, 19, 16, 0.0f, false);
        this.door_right_overlay_exterior = new ModelMapper(modelDataWrapper);
        this.door_right_overlay_exterior.setPos(0.0f, 24.0f, 0.0f);
        this.door_right_top_r2 = new ModelMapper(modelDataWrapper);
        this.door_right_top_r2.setPos(-20.7f, -pivotY, 0.0f);
        this.door_right_overlay_exterior.addChild(this.door_right_top_r2);
        ModelTrainBase.setRotationAngle(this.door_right_top_r2, 0.0f, 3.1416f, angleRadians);
        this.door_right_top_r2.texOffs(3, -16).addBox(0.0f, -19.0f, 0.0f, 0, 19, 16, 0.0f, false);
        this.wall_1 = new ModelMapper(modelDataWrapper);
        this.wall_1.setPos(0.0f, 24.0f, 0.0f);
        this.wall_1.texOffs(32, 19).addBox(-20.0f, -pivotY, (float)(-doorMax) + 0.1f, 3, 13, 0, 0.0f, false);
        this.upper_wall_1_r1 = new ModelMapper(modelDataWrapper);
        this.upper_wall_1_r1.setPos(-20.0f, -pivotY, 0.0f);
        this.wall_1.addChild(this.upper_wall_1_r1);
        ModelTrainBase.setRotationAngle(this.upper_wall_1_r1, 0.0f, 0.0f, angleRadians);
        this.upper_wall_1_r1.texOffs(32, 0).addBox(0.0f, -19.0f, (float)(-doorMax) + 0.1f, 3, 19, 0, 0.0f, false);
        this.wall_2 = new ModelMapper(modelDataWrapper);
        this.wall_2.setPos(0.0f, 24.0f, 0.0f);
        this.wall_2.texOffs(0, 19).addBox(-20.0f, -pivotY, (float)doorMax - 0.1f, 3, 13, 0, 0.0f, false);
        this.upper_wall_2_r1 = new ModelMapper(modelDataWrapper);
        this.upper_wall_2_r1.setPos(-20.0f, -pivotY, 0.0f);
        this.wall_2.addChild(this.upper_wall_2_r1);
        ModelTrainBase.setRotationAngle(this.upper_wall_2_r1, 0.0f, 0.0f, angleRadians);
        this.upper_wall_2_r1.texOffs(0, 0).addBox(0.0f, -19.0f, (float)doorMax - 0.1f, 3, 19, 0, 0.0f, false);
        modelDataWrapper.setModelPart(38, 32);
        this.door_left_overlay_interior.setModelPart();
        this.door_right_overlay_interior.setModelPart();
        this.door_left_overlay_exterior.setModelPart();
        this.door_right_overlay_exterior.setModelPart();
        this.wall_1.setModelPart();
        this.wall_2.setModelPart();
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, ModelTrainBase.RenderStage renderStage, int light, int position, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean lightsOn) {
        switch (renderStage) {
            case INTERIOR: {
                RenderType renderLayerInteriorRight;
                RenderType renderLayerInteriorLeft = lightsOn ? MoreRenderLayers.getInterior(this.doorOverlayTextureLeft) : MoreRenderLayers.getExterior(this.doorOverlayTextureLeft);
                RenderType renderType = renderLayerInteriorRight = lightsOn ? MoreRenderLayers.getInterior(this.doorOverlayTextureRight) : MoreRenderLayers.getExterior(this.doorOverlayTextureRight);
                if (this.renderRight) {
                    ModelTrainBase.renderOnce(this.door_left_overlay_interior, matrices, vertexConsumers.m_6299_(renderLayerInteriorRight), light, doorRightX, (float)position + doorRightZ);
                    ModelTrainBase.renderOnce(this.door_right_overlay_interior, matrices, vertexConsumers.m_6299_(renderLayerInteriorLeft), light, doorRightX, (float)position - doorRightZ);
                    ModelTrainBase.renderOnce(this.wall_1, matrices, vertexConsumers.m_6299_(renderLayerInteriorLeft), light, position);
                    ModelTrainBase.renderOnce(this.wall_2, matrices, vertexConsumers.m_6299_(renderLayerInteriorRight), light, position);
                }
                if (!this.renderLeft) break;
                ModelTrainBase.renderOnceFlipped(this.door_left_overlay_interior, matrices, vertexConsumers.m_6299_(renderLayerInteriorRight), light, doorLeftX, (float)position - doorLeftZ);
                ModelTrainBase.renderOnceFlipped(this.door_right_overlay_interior, matrices, vertexConsumers.m_6299_(renderLayerInteriorLeft), light, doorLeftX, (float)position + doorLeftZ);
                ModelTrainBase.renderOnceFlipped(this.wall_1, matrices, vertexConsumers.m_6299_(renderLayerInteriorLeft), light, position);
                ModelTrainBase.renderOnceFlipped(this.wall_2, matrices, vertexConsumers.m_6299_(renderLayerInteriorRight), light, position);
                break;
            }
            case EXTERIOR: {
                if (this.renderRight) {
                    ModelTrainBase.renderOnce(this.door_left_overlay_exterior, matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(this.doorOverlayTextureLeft)), light / 4 * 3, doorRightX, (float)position + doorRightZ);
                    ModelTrainBase.renderOnce(this.door_right_overlay_exterior, matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(this.doorOverlayTextureRight)), light / 4 * 3, doorRightX, (float)position - doorRightZ);
                }
                if (!this.renderLeft) break;
                ModelTrainBase.renderOnceFlipped(this.door_left_overlay_exterior, matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(this.doorOverlayTextureLeft)), light / 4 * 3, doorLeftX, (float)position - doorLeftZ);
                ModelTrainBase.renderOnceFlipped(this.door_right_overlay_exterior, matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(this.doorOverlayTextureRight)), light / 4 * 3, doorLeftX, (float)position + doorLeftZ);
            }
        }
    }

    public void m_6973_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public final void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
    }
}

