/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import dev.architectury.platform.forge.EventBuses;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;

public class ForgeUtilities {
    private static Runnable renderTickAction = () -> {};
    private static final Set<EntityRendererPair<?>> ENTITY_RENDERER_PAIRS = new HashSet();

    public static void registerModEventBus(String modId, IEventBus eventBus) {
        EventBuses.registerModEventBus((String)modId, (IEventBus)eventBus);
    }

    public static void registerKeyBinding(KeyMapping keyMapping) {
        ClientRegistry.registerKeyBinding((KeyMapping)keyMapping);
    }

    public static Packet<?> createAddEntityPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    public static void renderTickAction(Runnable runnable) {
        renderTickAction = runnable;
    }

    public static <T extends Entity> void registerEntityRenderer(Supplier<EntityType<? extends T>> entityType, EntityRendererProvider<T> entityRendererProvider) {
        ENTITY_RENDERER_PAIRS.add(new EntityRendererPair<T>(entityType, entityRendererProvider));
    }

    private static class EntityRendererPair<T extends Entity> {
        private final Supplier<EntityType<? extends T>> entityTypeSupplier;
        private final EntityRendererProvider<T> entityRendererProvider;

        private EntityRendererPair(Supplier<EntityType<? extends T>> entityTypeSupplier, EntityRendererProvider<T> entityRendererProvider) {
            this.entityTypeSupplier = entityTypeSupplier;
            this.entityRendererProvider = entityRendererProvider;
        }

        private void register(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(this.entityTypeSupplier.get(), this.entityRendererProvider);
        }
    }

    public static class RegisterEntityRenderer {
        @SubscribeEvent
        public static void onRegisterEntityRendererEvent(EntityRenderersEvent.RegisterRenderers event) {
            ENTITY_RENDERER_PAIRS.forEach(entityRendererPair -> entityRendererPair.register(event));
        }
    }

    public static class RenderTick {
        @SubscribeEvent
        public static void onRenderTickEvent(RenderLevelLastEvent event) {
            renderTickAction.run();
        }
    }
}

