/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.Blocks;
import mtr.block.BlockNode;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.Text;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ItemNodeModifierSelectableBlockBase
extends ItemNodeModifierBase {
    private final boolean canSaveBlock;
    private final int height;
    private final int width;
    private final int radius;
    private static final String TAG_BLOCK_ID = "block_id";

    public ItemNodeModifierSelectableBlockBase(boolean canSaveBlock, int height, int width) {
        super(true, false, true);
        this.canSaveBlock = canSaveBlock;
        this.height = height;
        this.width = width;
        this.radius = width / 2;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        if (this.canSaveBlock) {
            Player player;
            Level world = context.m_43725_();
            if (!world.f_46443_ && (player = context.m_43723_()) != null && player.m_6144_()) {
                BlockState state = world.m_8055_(context.m_8083_());
                BlockState newState = state.m_60734_() instanceof BlockNode ? net.minecraft.world.level.block.Blocks.f_50016_.m_49966_() : state;
                player.m_5661_((Component)Text.translatable("tooltip.mtr.selected_material", Text.translatable(newState.m_60734_().m_7705_(), new Object[0])), true);
                CompoundTag compoundTag = context.m_43722_().m_41784_();
                compoundTag.m_128405_(TAG_BLOCK_ID, Block.m_49956_((BlockState)newState));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.height > 0) {
            tooltip.add((Component)Text.translatable("tooltip.mtr.rail_action_height", this.height).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)Text.translatable("tooltip.mtr.rail_action_width", this.width).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        if (this.canSaveBlock) {
            String[] textSplit;
            BlockState state = this.getSavedState(stack);
            for (String text : textSplit = Text.translatable(state.m_60795_() ? "tooltip.mtr.shift_right_click_to_select_material" : "tooltip.mtr.shift_right_click_to_clear", Minecraft.m_91087_().f_91066_.f_92090_.m_90863_(), Text.translatable(Blocks.RAIL_NODE.get().m_7705_(), new Object[0])).getString().split("\\|")) {
                tooltip.add((Component)Text.literal(text).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131157_(ChatFormatting.ITALIC)));
            }
            tooltip.add((Component)Text.translatable("tooltip.mtr.selected_material", Text.translatable(state.m_60734_().m_7705_(), new Object[0])).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        }
        super.m_7373_(stack, level, tooltip, tooltipFlag);
    }

    @Override
    protected final void onConnect(Level world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, Player player, RailwayData railwayData) {
        if (player != null && !this.onConnect(player, stack, railwayData, posStart, posEnd, this.radius, this.height)) {
            player.m_5661_((Component)Text.translatable("gui.mtr.rail_not_found_action", new Object[0]), true);
        }
    }

    @Override
    protected final void onRemove(Level world, BlockPos posStart, BlockPos posEnd, RailwayData railwayData) {
    }

    protected BlockState getSavedState(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TAG_BLOCK_ID)) {
            return Block.m_49803_((int)tag.m_128451_(TAG_BLOCK_ID));
        }
        return net.minecraft.world.level.block.Blocks.f_50016_.m_49966_();
    }

    protected abstract boolean onConnect(Player var1, ItemStack var2, RailwayData var3, BlockPos var4, BlockPos var5, int var6, int var7);
}

