/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import mtr.data.IGui;
import mtr.data.TransportMode;
import net.minecraft.world.level.material.MaterialColor;

public enum RailType implements IGui
{
    WOODEN(20, MaterialColor.f_76411_, false, true, false, RailSlopeStyle.CURVE),
    STONE(40, MaterialColor.f_76409_, false, true, false, RailSlopeStyle.CURVE),
    EMERALD(60, MaterialColor.f_76369_, false, true, false, RailSlopeStyle.CURVE),
    IRON(80, MaterialColor.f_76404_, false, true, false, RailSlopeStyle.CURVE),
    OBSIDIAN(120, MaterialColor.f_76422_, false, true, false, RailSlopeStyle.CURVE),
    BLAZE(160, MaterialColor.f_76413_, false, true, false, RailSlopeStyle.CURVE),
    QUARTZ(200, MaterialColor.f_76412_, false, true, false, RailSlopeStyle.CURVE),
    DIAMOND(300, MaterialColor.f_76367_, false, true, false, RailSlopeStyle.CURVE),
    PLATFORM(80, MaterialColor.f_76364_, true, false, true, RailSlopeStyle.CURVE),
    SIDING(40, MaterialColor.f_76416_, true, false, true, RailSlopeStyle.CURVE),
    TURN_BACK(80, MaterialColor.f_76361_, false, false, false, RailSlopeStyle.CURVE),
    CABLE_CAR(30, MaterialColor.f_76406_, false, true, true, RailSlopeStyle.CABLE),
    CABLE_CAR_STATION(2, MaterialColor.f_76406_, false, true, true, RailSlopeStyle.CURVE),
    NONE(20, MaterialColor.f_76365_, false, false, false, RailSlopeStyle.CURVE);

    public final int speedLimit;
    public final float maxBlocksPerTick;
    public final int color;
    public final boolean hasSavedRail;
    public final boolean canAccelerate;
    public final boolean forContinuousMovement;
    public final RailSlopeStyle railSlopeStyle;

    private RailType(int speedLimit, MaterialColor MaterialColor2, boolean hasSavedRail, boolean canAccelerate, boolean forContinuousMovement, RailSlopeStyle railSlopeStyle) {
        this.speedLimit = speedLimit;
        this.maxBlocksPerTick = (float)speedLimit / 3.6f / 20.0f;
        this.color = MaterialColor2.f_76396_ | 0x7F000000;
        this.hasSavedRail = hasSavedRail;
        this.canAccelerate = canAccelerate;
        this.forContinuousMovement = forContinuousMovement;
        this.railSlopeStyle = railSlopeStyle;
    }

    public static float getDefaultMaxBlocksPerTick(TransportMode transportMode) {
        return (transportMode.continuousMovement ? RailType.CABLE_CAR_STATION : RailType.WOODEN).maxBlocksPerTick;
    }

    public static enum RailSlopeStyle {
        CURVE,
        CABLE;

    }
}

