/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.client.DynamicTrainModel;
import mtr.client.DynamicTrainModelLegacy;
import mtr.client.ICustomResources;
import mtr.client.IResourcePackCreatorProperties;
import mtr.client.TrainClientRegistry;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class CustomResources
implements IResourcePackCreatorProperties,
ICustomResources {
    public static final Map<String, CustomSign> CUSTOM_SIGNS = new HashMap<String, CustomSign>();

    public static void reload(ResourceManager manager) {
        TrainClientRegistry.reset();
        RenderTrains.clearTextureAvailability();
        CUSTOM_SIGNS.clear();
        ArrayList customTrains = new ArrayList();
        CustomResources.readResource(manager, "mtr:mtr_custom_resources.json", jsonConfig -> {
            try {
                jsonConfig.get("custom_trains").getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String name = CustomResources.getOrDefault(jsonObject, "name", (String)entry.getKey(), JsonElement::getAsString);
                        int color = CustomResources.getOrDefault(jsonObject, "color", 0, jsonElement -> CustomResources.colorStringToInt(jsonElement.getAsString()));
                        String trainId = "mtr_custom_train_" + (String)entry.getKey();
                        String baseTrainType = CustomResources.getOrDefault(jsonObject, "base_train_type", "", JsonElement::getAsString);
                        TrainClientRegistry.TrainProperties baseTrainProperties = TrainClientRegistry.getTrainProperties(baseTrainType);
                        String textureId = CustomResources.getOrDefault(jsonObject, "texture_id", baseTrainProperties.textureId, JsonElement::getAsString);
                        String gangwayConnectionId = CustomResources.getOrDefault(jsonObject, "gangway_connection_id", baseTrainProperties.gangwayConnectionId, JsonElement::getAsString);
                        String trainBarrierId = CustomResources.getOrDefault(jsonObject, "train_barrier_id", baseTrainProperties.trainBarrierId, JsonElement::getAsString);
                        float riderOffset = CustomResources.getOrDefault(jsonObject, "rider_offset", Float.valueOf(baseTrainProperties.riderOffset), JsonElement::getAsFloat).floatValue();
                        int speedSoundCount = CustomResources.getOrDefault(jsonObject, "speed_sound_count", baseTrainProperties.speedSoundCount, JsonElement::getAsInt);
                        String speedSoundBaseId = CustomResources.getOrDefault(jsonObject, "speed_sound_base_id", baseTrainProperties.speedSoundBaseId, JsonElement::getAsString);
                        String doorSoundBaseId = CustomResources.getOrDefault(jsonObject, "door_sound_base_id", baseTrainProperties.doorSoundBaseId, JsonElement::getAsString);
                        float doorCloseSoundTime = CustomResources.getOrDefault(jsonObject, "door_close_sound_time", Float.valueOf(baseTrainProperties.doorCloseSoundTime), JsonElement::getAsFloat).floatValue();
                        if (!baseTrainProperties.baseTrainType.isEmpty()) {
                            TrainClientRegistry.register(trainId, baseTrainType, baseTrainProperties.model, textureId, speedSoundBaseId, doorSoundBaseId, name, color, gangwayConnectionId, trainBarrierId, riderOffset, speedSoundCount, doorCloseSoundTime, false);
                            customTrains.add(trainId);
                        }
                        if (jsonObject.has("model") && jsonObject.has("model_properties")) {
                            CustomResources.readResource(manager, jsonObject.get("model").getAsString(), jsonModel -> CustomResources.readResource(manager, jsonObject.get("model_properties").getAsString(), jsonProperties -> {
                                IResourcePackCreatorProperties.checkSchema(jsonProperties);
                                String newBaseTrainType = String.format("%s_%s_%s", jsonProperties.get("transport_mode").getAsString(), jsonProperties.get("length").getAsInt(), jsonProperties.get("width").getAsInt());
                                String gangwayConnectionId2 = gangwayConnectionId.isEmpty() ? (CustomResources.getOrDefault(jsonObject, "has_gangway_connection", true, JsonElement::getAsBoolean).booleanValue() ? "mtr:textures/entity/sp1900" : "") : gangwayConnectionId;
                                String newBaseTrainType2 = baseTrainType.startsWith("base_") ? baseTrainType.replace("base_", "train_") : newBaseTrainType;
                                boolean useLegacy = jsonProperties.has("parts_normal");
                                TrainClientRegistry.register(trainId, newBaseTrainType2.toLowerCase(), useLegacy ? new DynamicTrainModelLegacy((JsonObject)jsonModel, (JsonObject)jsonProperties) : new DynamicTrainModel((JsonObject)jsonModel, (JsonObject)jsonProperties), textureId, speedSoundBaseId, doorSoundBaseId, name, color, gangwayConnectionId2, trainBarrierId, riderOffset, speedSoundCount, doorCloseSoundTime, false);
                                customTrains.add(trainId);
                            }));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jsonConfig.get("custom_signs").getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        boolean flipTexture = CustomResources.getOrDefault(jsonObject, "flip_texture", false, JsonElement::getAsBoolean);
                        String customText = CustomResources.getOrDefault(jsonObject, "custom_text", "", JsonElement::getAsString);
                        boolean flipCustomText = CustomResources.getOrDefault(jsonObject, "flip_custom_text", false, JsonElement::getAsBoolean);
                        boolean small = CustomResources.getOrDefault(jsonObject, "small", false, JsonElement::getAsBoolean);
                        int backgroundColor = CustomResources.getOrDefault(jsonObject, "background_color", 0, jsonElement -> CustomResources.colorStringToInt(jsonElement.getAsString()));
                        CUSTOM_SIGNS.put("mtr_custom_sign_" + (String)entry.getKey(), new CustomSign(new ResourceLocation(jsonObject.get("texture_id").getAsString()), flipTexture, customText, flipCustomText, small, backgroundColor));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        System.out.println("Loaded " + customTrains.size() + " custom train(s)");
        customTrains.forEach(System.out::println);
        System.out.println("Loaded " + CUSTOM_SIGNS.size() + " custom sign(s)");
        CUSTOM_SIGNS.keySet().forEach(System.out::println);
    }

    public static int colorStringToInt(String string) {
        try {
            return Integer.parseInt(string.toUpperCase().replaceAll("[^\\dA-F]", ""), 16);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private static void readResource(ResourceManager manager, String path, Consumer<JsonObject> callback) {
        try {
            UtilitiesClient.getResources(manager, new ResourceLocation(path)).forEach(resource -> {
                try (InputStream stream = Utilities.getInputStream(resource);){
                    callback.accept(new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Utilities.closeResource(resource);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> T getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            return function.apply(jsonObject.get(key));
        }
        return defaultValue;
    }

    public static class CustomSign {
        public final ResourceLocation textureId;
        public final boolean flipTexture;
        public final String customText;
        public final boolean flipCustomText;
        public final boolean small;
        public final int backgroundColor;

        public CustomSign(ResourceLocation textureId, boolean flipTexture, String customText, boolean flipCustomText, boolean small, int backgroundColor) {
            this.textureId = textureId;
            this.flipTexture = flipTexture;
            this.customText = customText;
            this.flipCustomText = flipCustomText;
            this.small = small;
            this.backgroundColor = backgroundColor;
        }

        public boolean hasCustomText() {
            return !this.customText.isEmpty();
        }
    }
}

