/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mtr.BlockEntityTypes;
import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTactileMap
extends BlockDirectionalDoubleBlockBase
implements EntityBlockMapper {
    public BlockTactileMap(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (world.f_46443_ && TileEntityTactileMap.onUse != null) {
            TileEntityTactileMap.onUse.accept(pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 2.0, 16.0, 7.0, 14.0, facing);
        }
        return Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape)IBlock.getVoxelShapeByDirection(6.0, 1.0, 7.0, 10.0, 16.0, 9.0, facing));
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityTactileMap(pos, state);
    }

    @Override
    public <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
        TileEntityTactileMap.tick(world, pos);
    }

    @Override
    public BlockEntityType<? extends BlockEntityMapper> getType() {
        return BlockEntityTypes.TACTILE_MAP_TILE_ENTITY.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HALF});
    }

    public static class TileEntityTactileMap
    extends BlockEntityMapper
    implements TickableMapper {
        public static BiConsumer<BlockPos, Boolean> updateSoundSource = null;
        public static Consumer<BlockPos> onUse = null;

        public TileEntityTactileMap(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.TACTILE_MAP_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void tick() {
            TileEntityTactileMap.tick(this.f_58857_, this.f_58858_);
        }

        public void m_7651_() {
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && updateSoundSource != null) {
                updateSoundSource.accept(this.f_58858_, true);
            }
            super.m_7651_();
        }

        public static <T extends BlockEntityMapper> void tick(Level world, BlockPos pos) {
            if (world != null && world.f_46443_ && updateSoundSource != null) {
                updateSoundSource.accept(pos, false);
            }
        }
    }
}

