/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores.util;

import io.github.phantamanta44.mekores.constant.LangConst;
import io.github.phantamanta44.mekores.ore.OreType;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.OreGas;

public class GasHelper {
    public static GasStack gasStack(String name, int count) {
        return new GasStack(GasRegistry.getGas((String)name), count);
    }

    public static void registerOreGas(OreType type) {
        Gas cleanGas = GasRegistry.getGas((String)("clean" + type.getName()));
        if (cleanGas == null) {
            cleanGas = GasRegistry.register((Gas)new MekanismOreGas(type, true)).setVisible(false);
        }
        if (GasRegistry.getGas((String)type.getName()) == null) {
            MekanismOreGas dirtyGas = new MekanismOreGas(type, false);
            if (cleanGas instanceof OreGas) {
                dirtyGas.setCleanGas((OreGas)cleanGas);
            }
            GasRegistry.register((Gas)dirtyGas.setVisible(false));
        }
    }

    private static class MekanismOreGas
    extends OreGas {
        private final OreType type;
        private final boolean clean;

        MekanismOreGas(OreType type, boolean clean) {
            super(clean ? "clean" + type.getName() : type.getName(), type.getName());
            this.type = type;
            this.clean = clean;
        }

        public String getOreName() {
            return LangConst.get("mekores.misc.ore", this.type.getLocalizedName());
        }

        public String getLocalizedName() {
            return LangConst.get(this.clean ? "mekores.misc.slurry_clean" : "mekores.misc.slurry", this.type.getLocalizedName());
        }

        public int getTint() {
            return this.type.getColour();
        }
    }
}

