/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigurable;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityFusionReactorPort
extends TileEntityFusionReactorBlock
implements IConfigurable {
    public TileEntityFusionReactorPort() {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_PORT);
        this.delaySupplier = () -> 0;
    }

    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getEnergyContainers(side);
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getInventorySlots(side);
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.FLUID || type == SubstanceType.ENERGY || type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    public boolean persistInventory() {
        return false;
    }

    protected void onUpdateServer(FusionReactorMultiblockData multiblock) {
        super.onUpdateServer((MultiblockData)multiblock);
        if (this.getActive() && multiblock.isFormed()) {
            Set directionsToEmit = multiblock.getDirectionsToEmit(this.func_174877_v());
            ChemicalUtil.emit((Set)directionsToEmit, (IChemicalTank)multiblock.steamTank, (TileEntity)this);
            CableUtils.emit((Set)directionsToEmit, (IEnergyContainer)multiblock.energyContainer, (TileEntity)this);
        }
    }

    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        TileEntity adj = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side));
        if (adj instanceof TileEntityFusionReactorBlock) {
            return null;
        }
        return CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER_CAPABILITY, (Direction)side.func_176734_d()).resolve().orElse(null);
    }

    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, new Object[]{MekanismLang.MEKANISM, EnumColor.GRAY, GeneratorsLang.REACTOR_PORT_EJECT.translate(new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)})}), Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }

    public int getRedstoneLevel() {
        return ((FusionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

