/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import mekanism.api.providers.IBlockProvider;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;

public class TileEntityFusionReactorBlock
extends TileEntityMultiblock<FusionReactorMultiblockData> {
    public TileEntityFusionReactorBlock() {
        this((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_FRAME);
    }

    public TileEntityFusionReactorBlock(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    public FusionReactorMultiblockData createMultiblock() {
        return new FusionReactorMultiblockData(this);
    }

    public MultiblockManager<FusionReactorMultiblockData> getManager() {
        return MekanismGenerators.fusionReactorManager;
    }

    public boolean canBeMaster() {
        return false;
    }

    public void setInjectionRateFromPacket(int rate) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            multiblock.setInjectionRate(Math.min(98, Math.max(0, rate - rate % 2)));
            this.markDirty(false);
        }
    }

    public void addFuelTabContainerTrackers(MekanismContainer container) {
        SyncMapper.setup((MekanismContainer)container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), (String)"fuel");
    }

    public void addHeatTabContainerTrackers(MekanismContainer container) {
        SyncMapper.setup((MekanismContainer)container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), (String)"heat");
    }
}

