/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.heat.MultiblockHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class FissionReactorMultiblockData
extends MultiblockData
implements IValveHandler {
    private static final double INVERSE_INSULATION_COEFFICIENT = 10000.0;
    private static final double INVERSE_CONDUCTION_COEFFICIENT = 10.0;
    private static final double waterConductivity = 0.5;
    private static final int COOLANT_PER_VOLUME = 100000;
    private static final long HEATED_COOLANT_PER_VOLUME = 1000000L;
    private static final long FUEL_PER_ASSEMBLY = 8000L;
    public static final double MIN_DAMAGE_TEMPERATURE = 1200.0;
    public static final double MAX_DAMAGE_TEMPERATURE = 1800.0;
    public static final double MAX_DAMAGE = 100.0;
    private static final double EXPLOSION_CHANCE = 1.953125E-6;
    public final Set<FissionReactorValidator.FormedAssembly> assemblies = new LinkedHashSet<FissionReactorValidator.FormedAssembly>();
    @ContainerSync
    public int fuelAssemblies = 1;
    @ContainerSync
    public int surfaceArea;
    @ContainerSync
    public IGasTank gasCoolantTank;
    @ContainerSync
    public MultiblockFluidTank<FissionReactorMultiblockData> fluidCoolantTank;
    @ContainerSync
    public IGasTank fuelTank;
    @ContainerSync
    public IGasTank heatedCoolantTank;
    @ContainerSync
    public IGasTank wasteTank;
    @ContainerSync
    public MultiblockHeatCapacitor<FissionReactorMultiblockData> heatCapacitor;
    @ContainerSync
    public double lastEnvironmentLoss = 0.0;
    @ContainerSync
    public long lastBoilRate = 0L;
    @ContainerSync
    public double lastBurnRate = 0.0;
    public boolean clientBurning;
    @ContainerSync
    public double reactorDamage = 0.0;
    @ContainerSync
    public double rateLimit;
    public double burnRemaining;
    public double partialWaste;
    @ContainerSync
    private boolean active;
    private AxisAlignedBB hotZone;
    public float prevCoolantScale;
    private float prevFuelScale;
    public float prevHeatedCoolantScale;
    private float prevWasteScale;

    public FissionReactorMultiblockData(TileEntityFissionReactorCasing tile) {
        super((TileEntity)tile);
        this.rateLimit = MekanismGeneratorsConfig.generators.defaultBurnRate.get();
        this.burnRemaining = 0.0;
        this.partialWaste = 0.0;
        this.fluidCoolantTank = MultiblockFluidTank.create((MultiblockData)this, (TileEntityMultiblock)tile, () -> this.getVolume() * 100000, (stack, automationType) -> automationType != AutomationType.EXTERNAL, (stack, automationType) -> this.isFormed(), fluid -> fluid.getFluid().func_207185_a((ITag)FluidTags.field_206959_a) && this.gasCoolantTank.isEmpty(), null);
        this.fluidTanks.add(this.fluidCoolantTank);
        this.gasCoolantTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.create((MultiblockData)this, (TileEntityMultiblock)tile, () -> (long)this.getVolume() * 100000L, (stack, automationType) -> automationType != AutomationType.EXTERNAL, (stack, automationType) -> this.isFormed(), gas -> gas.has(GasAttributes.CooledCoolant.class) && this.fluidCoolantTank.isEmpty());
        this.fuelTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.create((MultiblockData)this, (TileEntityMultiblock)tile, () -> (long)this.fuelAssemblies * 8000L, (stack, automationType) -> automationType != AutomationType.EXTERNAL, (stack, automationType) -> this.isFormed(), gas -> gas == MekanismGases.FISSILE_FUEL.getChemical(), ChemicalAttributeValidator.ALWAYS_ALLOW, null);
        this.heatedCoolantTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.create((MultiblockData)this, (TileEntityMultiblock)tile, () -> (long)this.getVolume() * 1000000L, (stack, automationType) -> this.isFormed(), (stack, automationType) -> automationType != AutomationType.EXTERNAL, gas -> gas == MekanismGases.STEAM.get() || gas.has(GasAttributes.HeatedCoolant.class));
        this.wasteTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.create((MultiblockData)this, (TileEntityMultiblock)tile, () -> (long)this.fuelAssemblies * 8000L, (stack, automationType) -> this.isFormed(), (stack, automationType) -> automationType != AutomationType.EXTERNAL, gas -> gas == MekanismGases.NUCLEAR_WASTE.getChemical(), ChemicalAttributeValidator.ALWAYS_ALLOW, null);
        this.gasTanks.addAll(Arrays.asList(this.fuelTank, this.heatedCoolantTank, this.wasteTank, this.gasCoolantTank));
        this.heatCapacitor = MultiblockHeatCapacitor.create((MultiblockData)this, (TileEntityMultiblock)tile, (double)MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get(), () -> 10.0, () -> 10000.0);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    public void onCreated(World world) {
        super.onCreated(world);
        this.heatCapacitor.setHeatCapacity(MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get() * (double)this.locations.size(), true);
        this.hotZone = new AxisAlignedBB((double)(this.getMinPos().func_177958_n() + 1), (double)(this.getMinPos().func_177956_o() + 1), (double)(this.getMinPos().func_177952_p() + 1), (double)this.getMaxPos().func_177958_n(), (double)this.getMaxPos().func_177956_o(), (double)this.getMaxPos().func_177952_p());
    }

    public boolean tick(World world) {
        boolean needsPacket = super.tick(world);
        if (this.isActive()) {
            this.burnFuel(world);
        } else {
            this.lastBurnRate = 0.0;
        }
        if (this.isBurning() != this.clientBurning) {
            needsPacket = true;
            this.clientBurning = this.isBurning();
        }
        this.handleCoolant();
        this.lastEnvironmentLoss = this.simulateEnvironment();
        this.updateHeatCapacitors(null);
        this.handleDamage(world);
        this.radiateEntities(world);
        float coolantScale = MekanismUtils.getScale((float)this.prevCoolantScale, this.fluidCoolantTank);
        float fuelScale = MekanismUtils.getScale((float)this.prevFuelScale, (IChemicalTank)this.fuelTank);
        float steamScale = MekanismUtils.getScale((float)this.prevHeatedCoolantScale, (IChemicalTank)this.heatedCoolantTank);
        float wasteScale = MekanismUtils.getScale((float)this.prevWasteScale, (IChemicalTank)this.wasteTank);
        if (coolantScale != this.prevCoolantScale || fuelScale != this.prevFuelScale || steamScale != this.prevHeatedCoolantScale || wasteScale != this.prevWasteScale) {
            needsPacket = true;
            this.prevCoolantScale = coolantScale;
            this.prevFuelScale = fuelScale;
            this.prevHeatedCoolantScale = steamScale;
            this.prevWasteScale = wasteScale;
        }
        return needsPacket;
    }

    public void readUpdateTag(CompoundNBT tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"scale", scale -> {
            this.prevCoolantScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"scaleAlt", scale -> {
            this.prevFuelScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"scale2", scale -> {
            this.prevHeatedCoolantScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"scale3", scale -> {
            this.prevWasteScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"volume", arg_0 -> ((FissionReactorMultiblockData)this).setVolume(arg_0));
        NBTUtils.setFluidStackIfPresent((CompoundNBT)tag, (String)"fluid", value -> this.fluidCoolantTank.setStack(value));
        NBTUtils.setGasStackIfPresent((CompoundNBT)tag, (String)"gas", value -> this.fuelTank.setStack((ChemicalStack)value));
        NBTUtils.setGasStackIfPresent((CompoundNBT)tag, (String)"gas1", value -> this.heatedCoolantTank.setStack((ChemicalStack)value));
        NBTUtils.setGasStackIfPresent((CompoundNBT)tag, (String)"gas2", value -> this.wasteTank.setStack((ChemicalStack)value));
        this.readValves(tag);
        this.assemblies.clear();
        if (tag.func_150297_b("assemblies", 9)) {
            ListNBT list = tag.func_150295_c("assemblies", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.assemblies.add(FissionReactorValidator.FormedAssembly.read(list.func_150305_b(i)));
            }
        }
    }

    public void writeUpdateTag(CompoundNBT tag) {
        super.writeUpdateTag(tag);
        tag.func_74776_a("scale", this.prevCoolantScale);
        tag.func_74776_a("scaleAlt", this.prevFuelScale);
        tag.func_74776_a("scale2", this.prevHeatedCoolantScale);
        tag.func_74776_a("scale3", this.prevWasteScale);
        tag.func_74768_a("volume", this.getVolume());
        tag.func_218657_a("fluid", (INBT)this.fluidCoolantTank.getFluid().writeToNBT(new CompoundNBT()));
        tag.func_218657_a("gas", (INBT)((GasStack)this.fuelTank.getStack()).write(new CompoundNBT()));
        tag.func_218657_a("gas1", (INBT)((GasStack)this.heatedCoolantTank.getStack()).write(new CompoundNBT()));
        tag.func_218657_a("gas2", (INBT)((GasStack)this.wasteTank.getStack()).write(new CompoundNBT()));
        this.writeValves(tag);
        ListNBT list = new ListNBT();
        this.assemblies.forEach(assembly -> list.add((Object)assembly.write()));
        tag.func_218657_a("assemblies", (INBT)list);
    }

    private void handleDamage(World world) {
        double temp = this.heatCapacitor.getTemperature();
        if (temp > 1200.0) {
            double damageRate = Math.min(temp, 1800.0) / 12000.0;
            this.reactorDamage += damageRate;
        } else {
            double repairRate = (1200.0 - temp) / 120000.0;
            this.reactorDamage = Math.max(0.0, this.reactorDamage - repairRate);
        }
        if (MekanismGeneratorsConfig.generators.fissionMeltdownsEnabled.get() && this.reactorDamage >= 100.0 && temp >= 1200.0 && world.field_73012_v.nextDouble() < this.reactorDamage / 100.0 * MekanismGeneratorsConfig.generators.fissionMeltdownChance.get()) {
            double radiation = (double)this.wasteTank.getStored() * ((GasAttributes.Radiation)((Gas)MekanismGases.NUCLEAR_WASTE.get()).get(GasAttributes.Radiation.class)).getRadioactivity();
            if (((GasStack)this.wasteTank.getStack()).has(GasAttributes.Radiation.class)) {
                radiation += (double)this.wasteTank.getStored() * ((GasAttributes.Radiation)((GasStack)this.wasteTank.getStack()).get(GasAttributes.Radiation.class)).getRadioactivity();
            }
            Mekanism.radiationManager.radiate(new Coord4D(this.getBounds().getCenter(), world), radiation *= MekanismGeneratorsConfig.generators.fissionMeltdownRadiationMultiplier.get());
            Mekanism.radiationManager.createMeltdown(world, this.getMinPos(), this.getMaxPos(), this.heatCapacitor.getHeat(), 1.953125E-6);
        }
    }

    private void handleCoolant() {
        GasAttributes.CooledCoolant coolantType;
        double temp = this.heatCapacitor.getTemperature();
        double heat = this.getBoilEfficiency() * (temp - HeatUtils.BASE_BOIL_TEMP) * this.heatCapacitor.getHeatCapacity();
        long coolantHeated = 0L;
        if (!this.fluidCoolantTank.isEmpty()) {
            double caseCoolantHeat = heat * 0.5;
            coolantHeated = (int)(HeatUtils.getSteamEnergyEfficiency() * caseCoolantHeat / HeatUtils.getWaterThermalEnthalpy());
            if ((coolantHeated = Math.max(0L, Math.min(coolantHeated, (long)this.fluidCoolantTank.getFluidAmount()))) > 0L) {
                MekanismUtils.logMismatchedStackSize((long)this.fluidCoolantTank.shrinkStack((int)coolantHeated, Action.EXECUTE), (long)coolantHeated);
                this.heatedCoolantTank.insert((ChemicalStack)MekanismGases.STEAM.getStack(coolantHeated), Action.EXECUTE, AutomationType.INTERNAL);
                caseCoolantHeat = (double)coolantHeated * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
                this.heatCapacitor.handleHeat(-caseCoolantHeat);
            }
        } else if (!this.gasCoolantTank.isEmpty() && (coolantType = (GasAttributes.CooledCoolant)((GasStack)this.gasCoolantTank.getStack()).get(GasAttributes.CooledCoolant.class)) != null) {
            double caseCoolantHeat = heat * coolantType.getConductivity();
            coolantHeated = (int)(caseCoolantHeat / coolantType.getThermalEnthalpy());
            if ((coolantHeated = Math.max(0L, Math.min(coolantHeated, this.gasCoolantTank.getStored()))) > 0L) {
                MekanismUtils.logMismatchedStackSize((long)this.gasCoolantTank.shrinkStack((long)((int)coolantHeated), Action.EXECUTE), (long)coolantHeated);
                this.heatedCoolantTank.insert((ChemicalStack)coolantType.getHeatedGas().getStack(coolantHeated), Action.EXECUTE, AutomationType.INTERNAL);
                caseCoolantHeat = (double)coolantHeated * coolantType.getThermalEnthalpy();
                this.heatCapacitor.handleHeat(-caseCoolantHeat);
            }
        }
        this.lastBoilRate = coolantHeated;
    }

    private void burnFuel(World world) {
        double storedFuel = (double)this.fuelTank.getStored() + this.burnRemaining;
        double toBurn = Math.min(Math.min(this.rateLimit, storedFuel), (double)((long)this.fuelAssemblies * MekanismGeneratorsConfig.generators.burnPerAssembly.get()));
        this.fuelTank.setStackSize((long)(storedFuel -= toBurn), Action.EXECUTE);
        this.burnRemaining = storedFuel % 1.0;
        this.heatCapacitor.handleHeat(toBurn * ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get()).doubleValue());
        this.partialWaste += toBurn;
        long newWaste = (long)Math.floor(this.partialWaste);
        if (newWaste > 0L) {
            this.partialWaste %= 1.0;
            long leftoverWaste = Math.max(0L, newWaste - this.wasteTank.getNeeded());
            GasStack wasteToAdd = MekanismGases.NUCLEAR_WASTE.getStack(newWaste);
            this.wasteTank.insert((ChemicalStack)wasteToAdd, Action.EXECUTE, AutomationType.INTERNAL);
            if (leftoverWaste > 0L) {
                double radioactivity = ((GasAttributes.Radiation)((Gas)wasteToAdd.getType()).get(GasAttributes.Radiation.class)).getRadioactivity();
                Mekanism.radiationManager.radiate(new Coord4D(this.getBounds().getCenter(), world), (double)leftoverWaste * radioactivity);
            }
        }
        this.lastBurnRate = toBurn;
    }

    private void radiateEntities(World world) {
        if (MekanismConfig.general.radiationEnabled.get() && this.isBurning() && world.func_201674_k().nextInt() % 20 == 0) {
            List entitiesToRadiate = this.getWorld().func_217357_a(LivingEntity.class, this.hotZone);
            for (LivingEntity entity : entitiesToRadiate) {
                GasAttributes.Radiation r;
                double wasteRadiation = 0.0;
                if (this.wasteTank.getStored() > 0L && (r = (GasAttributes.Radiation)((Gas)this.wasteTank.getType()).get(GasAttributes.Radiation.class)) != null) {
                    wasteRadiation = r.getRadioactivity() * (double)this.wasteTank.getStored() / 3600.0;
                }
                Mekanism.radiationManager.radiate(entity, this.lastBurnRate + wasteRadiation);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isBurning() {
        return this.lastBurnRate > 0.0;
    }

    public boolean handlesSound(TileEntityFissionReactorCasing tile) {
        return this.getBounds().isOnCorner(tile.func_174877_v());
    }

    public double getBoilEfficiency() {
        double avgSurfaceArea = (double)this.surfaceArea / (double)this.fuelAssemblies;
        return Math.min(1.0, avgSurfaceArea / MekanismGeneratorsConfig.generators.fissionSurfaceAreaTarget.get());
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }
}

