/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.MekanismConfig;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidicPlenisher
extends TileEntityElectricBlock
implements IComputerIntegration,
IConfigurable,
IFluidHandler,
ISustainedTank,
IUpgradeTile,
IRedstoneControl,
ISecurityTile {
    public Set<Coord4D> activeNodes = new HashSet<Coord4D>();
    public Set<Coord4D> usedNodes = new HashSet<Coord4D>();
    public boolean finishedCalc = false;
    public FluidTank fluidTank = new FluidTank(10000);
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = MekanismConfig.usage.fluidicPlenisherUsage;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 20;
    public int operatingTicks;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    private static EnumSet<ForgeDirection> dirs = EnumSet.complementOf(EnumSet.of(ForgeDirection.UP, ForgeDirection.UNKNOWN));
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    private static final String[] methods = new String[]{"reset"};

    public TileEntityFluidicPlenisher() {
        super("FluidicPlenisher", BlockMachine.MachineType.FLUIDIC_PLENISHER.baseEnergy);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(2, this);
            if (this.inventory[0] != null) {
                if (this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                    FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 0, 1, new FluidContainerUtils.FluidChecker(){

                        @Override
                        public boolean isValid(Fluid f) {
                            return f.canBePlacedInWorld();
                        }
                    });
                } else if (FluidContainerRegistry.isFilledContainer((ItemStack)this.inventory[0])) {
                    FluidContainerUtils.handleRegistryItemEmpty(this, this.fluidTank, 0, 1, new FluidContainerUtils.FluidChecker(){

                        @Override
                        public boolean isValid(Fluid f) {
                            return f.canBePlacedInWorld();
                        }
                    });
                }
            }
            if (MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid().canBePlacedInWorld()) {
                if (!this.finishedCalc) {
                    this.setEnergy(this.getEnergy() - this.energyPerTick);
                }
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    if (!this.finishedCalc) {
                        this.doPlenish();
                    } else {
                        Coord4D below = Coord4D.get(this).getFromSide(ForgeDirection.DOWN);
                        if (this.canReplace(below, false, false) && this.fluidTank.getFluidAmount() >= 1000 && this.fluidTank.getFluid().getFluid().canBePlacedInWorld()) {
                            this.field_145850_b.func_147465_d(below.xCoord, below.yCoord, below.zCoord, MekanismUtils.getFlowingBlock(this.fluidTank.getFluid().getFluid()), 0, 3);
                            this.setEnergy(this.getEnergy() - this.energyPerTick);
                            this.fluidTank.drain(1000, true);
                        }
                    }
                    this.operatingTicks = 0;
                }
            }
        }
    }

    private void doPlenish() {
        if (this.usedNodes.size() >= MekanismConfig.general.maxPlenisherNodes) {
            this.finishedCalc = true;
            return;
        }
        if (this.activeNodes.isEmpty()) {
            if (this.usedNodes.isEmpty()) {
                Coord4D below = Coord4D.get(this).getFromSide(ForgeDirection.DOWN);
                if (!this.canReplace(below, true, true)) {
                    this.finishedCalc = true;
                    return;
                }
                this.activeNodes.add(below);
            } else {
                this.finishedCalc = true;
                return;
            }
        }
        HashSet<Coord4D> toRemove = new HashSet<Coord4D>();
        for (Coord4D coord : this.activeNodes) {
            if (coord.exists(this.field_145850_b)) {
                if (this.canReplace(coord, true, false)) {
                    this.field_145850_b.func_147465_d(coord.xCoord, coord.yCoord, coord.zCoord, MekanismUtils.getFlowingBlock(this.fluidTank.getFluid().getFluid()), 0, 3);
                    this.fluidTank.drain(1000, true);
                }
                for (ForgeDirection dir : dirs) {
                    Coord4D sideCoord = coord.getFromSide(dir);
                    if (!sideCoord.exists(this.field_145850_b) || !this.canReplace(sideCoord, true, true)) continue;
                    this.activeNodes.add(sideCoord);
                }
                toRemove.add(coord);
                break;
            }
            toRemove.add(coord);
        }
        for (Coord4D coord : toRemove) {
            this.activeNodes.remove(coord);
            this.usedNodes.add(coord);
        }
    }

    public boolean canReplace(Coord4D coord, boolean checkNodes, boolean isPathfinding) {
        if (checkNodes && this.usedNodes.contains(coord)) {
            return false;
        }
        if (coord.isAirBlock((IBlockAccess)this.field_145850_b) || MekanismUtils.isDeadFluid(this.field_145850_b, coord)) {
            return true;
        }
        if (MekanismUtils.isFluid(this.field_145850_b, coord)) {
            return isPathfinding;
        }
        return coord.getBlock((IBlockAccess)this.field_145850_b).isReplaceable((IBlockAccess)this.field_145850_b, coord.xCoord, coord.yCoord, coord.zCoord);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.finishedCalc = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (dataStream.readInt() == 1) {
                this.fluidTank.setFluid(new FluidStack(dataStream.readInt(), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.finishedCalc);
        data.add(this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            data.add(1);
            data.add(this.fluidTank.getFluid().getFluidID());
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("finishedCalc", this.finishedCalc);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList activeList = new NBTTagList();
        for (Coord4D wrapper : this.activeNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            activeList.func_74742_a((NBTBase)tagCompound);
        }
        if (activeList.func_74745_c() != 0) {
            nbtTags.func_74782_a("activeNodes", (NBTBase)activeList);
        }
        NBTTagList usedList = new NBTTagList();
        for (Coord4D obj : this.usedNodes) {
            activeList.func_74742_a((NBTBase)obj.write(new NBTTagCompound()));
        }
        if (activeList.func_74745_c() != 0) {
            nbtTags.func_74782_a("usedNodes", (NBTBase)usedList);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        int i;
        NBTTagList tagList;
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.finishedCalc = nbtTags.func_74767_n("finishedCalc");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        if (nbtTags.func_74764_b("activeNodes")) {
            tagList = nbtTags.func_150295_c("activeNodes", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.activeNodes.add(Coord4D.read(tagList.func_150305_b(i)));
            }
        }
        if (nbtTags.func_74764_b("usedNodes")) {
            tagList = nbtTags.func_150295_c("usedNodes", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.usedNodes.add(Coord4D.read(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isFilledContainer((ItemStack)itemstack);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 1;
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing).getOpposite());
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        if (side == 0) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        if (direction == ForgeDirection.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid() && from == ForgeDirection.UP) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UP && resource.getFluid().canBePlacedInWorld()) {
            return this.fluidTank.fill(resource, true);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && fluid.canBePlacedInWorld();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        this.activeNodes.clear();
        this.usedNodes.clear();
        this.finishedCalc = false;
        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.plenisherReset")));
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                this.activeNodes.clear();
                this.usedNodes.clear();
                this.finishedCalc = false;
                return new Object[]{"Plenisher calculation reset."};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            }
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

