/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.MekanismConfig;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityElectricPump
extends TileEntityElectricBlock
implements IFluidHandler,
ISustainedTank,
IConfigurable,
IRedstoneControl,
IUpgradeTile,
ITankManager,
IComputerIntegration,
ISecurityTile {
    public FluidTank fluidTank = new FluidTank(10000);
    public Fluid activeType;
    public boolean suckedLastOperation;
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = MekanismConfig.usage.electricPumpUsage;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 20;
    public int operatingTicks;
    public Set<Coord4D> recurringNodes = new HashSet<Coord4D>();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    private static final String[] methods = new String[]{"reset"};

    public TileEntityElectricPump() {
        super("ElectricPump", 10000.0);
        this.inventory = new ItemStack[4];
        this.upgradeComponent.setSupported(Upgrade.FILTER);
    }

    @Override
    public void onUpdate() {
        TileEntity tileEntity;
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(2, this);
            if (this.inventory[0] != null && this.fluidTank.getFluid() != null) {
                if (this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                    FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 0, 1);
                } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[0])) {
                    FluidContainerUtils.handleRegistryItemFill(this, this.fluidTank, 0, 1);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                if (this.suckedLastOperation) {
                    this.setEnergy(this.getEnergy() - this.energyPerTick);
                }
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount + 1000 <= this.fluidTank.getCapacity()) {
                        if (!this.suck(true)) {
                            this.suckedLastOperation = false;
                            this.reset();
                        } else {
                            this.suckedLastOperation = true;
                        }
                    } else {
                        this.suckedLastOperation = false;
                    }
                    this.operatingTicks = 0;
                }
            } else {
                this.suckedLastOperation = false;
            }
        }
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.fluidTank.getFluid() != null && (tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.UP).getTileEntity((IBlockAccess)this.field_145850_b)) instanceof IFluidHandler) {
            FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(256 * (this.upgradeComponent.getUpgrades(Upgrade.SPEED) + 1), this.fluidTank.getFluidAmount()));
            this.fluidTank.drain(((IFluidHandler)tileEntity).fill(ForgeDirection.DOWN, toDrain, true), true);
        }
    }

    public boolean hasFilter() {
        return this.upgradeComponent.getInstalledTypes().contains((Object)Upgrade.FILTER);
    }

    public boolean suck(boolean take) {
        List<Coord4D> tempPumpList = Arrays.asList(this.recurringNodes.toArray(new Coord4D[this.recurringNodes.size()]));
        Collections.shuffle(tempPumpList);
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            Coord4D wrapper = Coord4D.get(this).getFromSide(orientation);
            FluidStack fluid = MekanismUtils.getFluid(this.field_145850_b, wrapper, this.hasFilter());
            if (fluid == null || this.activeType != null && fluid.getFluid() != this.activeType || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(fluid)) continue;
            if (take) {
                this.activeType = fluid.getFluid();
                this.recurringNodes.add(wrapper.clone());
                this.fluidTank.fill(fluid, true);
                if (this.shouldTake(fluid, wrapper)) {
                    this.field_145850_b.func_147465_d(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord, Blocks.field_150350_a, 0, 3);
                }
            }
            return true;
        }
        for (Coord4D wrapper : tempPumpList) {
            FluidStack fluid = MekanismUtils.getFluid(this.field_145850_b, wrapper, this.hasFilter());
            if (!(fluid == null || this.activeType != null && fluid.getFluid() != this.activeType || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(fluid))) {
                if (take) {
                    this.activeType = fluid.getFluid();
                    this.fluidTank.fill(fluid, true);
                    if (this.shouldTake(fluid, wrapper)) {
                        this.field_145850_b.func_147465_d(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord, Blocks.field_150350_a, 0, 3);
                    }
                }
                return true;
            }
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D side = wrapper.getFromSide(orientation);
                if (Coord4D.get(this).distanceTo(side) > MekanismConfig.general.maxPumpRange || (fluid = MekanismUtils.getFluid(this.field_145850_b, side, this.hasFilter())) == null || this.activeType != null && fluid.getFluid() != this.activeType || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(fluid)) continue;
                if (take) {
                    this.activeType = fluid.getFluid();
                    this.recurringNodes.add(side);
                    this.fluidTank.fill(fluid, true);
                    if (this.shouldTake(fluid, side)) {
                        this.field_145850_b.func_147465_d(side.xCoord, side.yCoord, side.zCoord, Blocks.field_150350_a, 0, 3);
                    }
                }
                return true;
            }
            this.recurringNodes.remove(wrapper);
        }
        return false;
    }

    public void reset() {
        this.activeType = null;
        this.recurringNodes.clear();
    }

    private boolean shouldTake(FluidStack fluid, Coord4D coord) {
        if (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.getFluid((String)"heavywater")) {
            return MekanismConfig.general.pumpWaterSources;
        }
        return true;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            if (dataStream.readInt() == 1) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.fluidTank.getFluid() != null) {
            data.add(1);
            data.add(this.fluidTank.getFluid().getFluidID());
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(0);
        }
        data.add(this.controlType.ordinal());
        return data;
    }

    public int getScaledFluidLevel(int i) {
        return this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount * i / 10000 : 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("suckedLastOperation", this.suckedLastOperation);
        if (this.activeType != null) {
            nbtTags.func_74778_a("activeType", FluidRegistry.getFluidName((Fluid)this.activeType));
        }
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        NBTTagList recurringList = new NBTTagList();
        for (Coord4D wrapper : this.recurringNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            recurringList.func_74742_a((NBTBase)tagCompound);
        }
        if (recurringList.func_74745_c() != 0) {
            nbtTags.func_74782_a("recurringNodes", (NBTBase)recurringList);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.suckedLastOperation = nbtTags.func_74767_n("suckedLastOperation");
        if (nbtTags.func_74764_b("activeType")) {
            this.activeType = FluidRegistry.getFluid((String)nbtTags.func_74779_i("activeType"));
        }
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        if (nbtTags.func_74764_b("controlType")) {
            this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        }
        if (nbtTags.func_74764_b("recurringNodes")) {
            NBTTagList tagList = nbtTags.func_150295_c("recurringNodes", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.recurringNodes.add(Coord4D.read(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 1;
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing).getOpposite());
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        if (side == 0) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        if (direction == ForgeDirection.getOrientation((int)1)) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid() && from == ForgeDirection.getOrientation((int)1)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.getOrientation((int)1)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.getOrientation((int)1);
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        this.reset();
        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.pumpReset")));
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank};
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                this.reset();
                return new Object[]{"Pump calculation reset."};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            }
        }
    }
}

