/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.TileEntityInternalMultiblock;
import mekanism.common.tile.TileEntityMultiblock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class UpdateProtocol<T extends SynchronizedData<T>> {
    public Set<TileEntity> iteratedNodes = new HashSet<TileEntity>();
    public Set<Coord4D> innerNodes = new HashSet<Coord4D>();
    public T structureFound = null;
    public TileEntityMultiblock<T> pointer;

    public UpdateProtocol(TileEntityMultiblock<T> tileEntity) {
        this.pointer = tileEntity;
    }

    public void loopThrough(TileEntity tile) {
        World worldObj = tile.func_145831_w();
        int origX = tile.field_145851_c;
        int origY = tile.field_145848_d;
        int origZ = tile.field_145849_e;
        boolean isCorner = true;
        boolean isHollow = true;
        boolean rightBlocks = true;
        boolean rightFrame = true;
        HashSet<Coord4D> locations = new HashSet<Coord4D>();
        int xmin = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        int zmin = 0;
        int zmax = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        int volume = 0;
        if (this.isViableNode(origX + 1, origY, origZ) && this.isViableNode(origX - 1, origY, origZ) || this.isViableNode(origX, origY + 1, origZ) && this.isViableNode(origX, origY - 1, origZ) || this.isViableNode(origX, origY, origZ + 1) && this.isViableNode(origX, origY, origZ - 1)) {
            isCorner = false;
        }
        if (isCorner) {
            if (this.isViableNode(origX + 1, origY, origZ)) {
                xmin = 0;
                while (this.isViableNode(origX + x + 1, origY, origZ)) {
                    ++x;
                }
                xmax = x;
            } else {
                xmax = 0;
                while (this.isViableNode(origX + x - 1, origY, origZ)) {
                    --x;
                }
                xmin = x;
            }
            if (this.isViableNode(origX, origY + 1, origZ)) {
                ymin = 0;
                while (this.isViableNode(origX, origY + y + 1, origZ)) {
                    ++y;
                }
                ymax = y;
            } else {
                ymax = 0;
                while (this.isViableNode(origX, origY + y - 1, origZ)) {
                    --y;
                }
                ymin = y;
            }
            if (this.isViableNode(origX, origY, origZ + 1)) {
                zmin = 0;
                while (this.isViableNode(origX, origY, origZ + z + 1)) {
                    ++z;
                }
                zmax = z;
            } else {
                zmax = 0;
                while (this.isViableNode(origX, origY, origZ + z - 1)) {
                    --z;
                }
                zmin = z;
            }
            for (x = xmin; x <= xmax; ++x) {
                for (y = ymin; y <= ymax; ++y) {
                    for (z = zmin; z <= zmax; ++z) {
                        if (x == xmin || x == xmax || y == ymin || y == ymax || z == zmin || z == zmax) {
                            if (!this.isViableNode(origX + x, origY + y, origZ + z)) {
                                rightBlocks = false;
                                break;
                            }
                            if (this.isFrame(Coord4D.get(tile).translate(x, y, z), origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax) && !this.isValidFrame(origX + x, origY + y, origZ + z)) {
                                rightFrame = false;
                                break;
                            }
                            locations.add(Coord4D.get(tile).translate(x, y, z));
                            continue;
                        }
                        if (!this.isValidInnerNode(origX + x, origY + y, origZ + z)) {
                            isHollow = false;
                            break;
                        }
                        if (!this.isAir(origX + x, origY + y, origZ + z)) {
                            this.innerNodes.add(new Coord4D(origX + x, origY + y, origZ + z, this.pointer.func_145831_w().field_73011_w.field_76574_g));
                        }
                        ++volume;
                    }
                    if (!isHollow || !rightBlocks || !rightFrame) break;
                }
                if (!isHollow || !rightBlocks || !rightFrame) break;
            }
        }
        volume += locations.size();
        if (Math.abs(xmax - xmin) + 1 <= 18 && Math.abs(ymax - ymin) + 1 <= 18 && Math.abs(zmax - zmin) + 1 <= 18 && rightBlocks && rightFrame && isHollow && isCorner) {
            T structure = this.getNewStructure();
            ((SynchronizedData)structure).locations = locations;
            ((SynchronizedData)structure).volLength = Math.abs(xmax - xmin) + 1;
            ((SynchronizedData)structure).volHeight = Math.abs(ymax - ymin) + 1;
            ((SynchronizedData)structure).volWidth = Math.abs(zmax - zmin) + 1;
            ((SynchronizedData)structure).volume = ((SynchronizedData)structure).volLength * ((SynchronizedData)structure).volHeight * ((SynchronizedData)structure).volWidth;
            ((SynchronizedData)structure).renderLocation = Coord4D.get(tile).translate(0, 1, 0);
            ((SynchronizedData)structure).minLocation = Coord4D.get(tile).translate(xmin, ymin, zmin);
            ((SynchronizedData)structure).maxLocation = Coord4D.get(tile).translate(xmax, ymax, zmax);
            if (((SynchronizedData)structure).volLength >= 3 && ((SynchronizedData)structure).volHeight >= 3 && ((SynchronizedData)structure).volWidth >= 3) {
                this.onStructureCreated(structure, origX, origY, origZ, xmin, xmax, ymin, ymax, zmin, zmax);
                if (((SynchronizedData)structure).locations.contains(Coord4D.get(this.pointer)) && this.isCorrectCorner(Coord4D.get(tile), origX + xmin, origY + ymin, origZ + zmin) && this.canForm(structure)) {
                    this.structureFound = structure;
                    return;
                }
            }
        }
        this.innerNodes.clear();
        this.iteratedNodes.add(tile);
        if (this.iteratedNodes.size() > 2048) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Coord4D coord = Coord4D.get(tile).getFromSide(side);
            TileEntity tileEntity = coord.getTileEntity((IBlockAccess)tile.func_145831_w());
            if (!this.isViableNode(coord.xCoord, coord.yCoord, coord.zCoord) || this.iteratedNodes.contains(tileEntity)) continue;
            this.loopThrough(tileEntity);
        }
    }

    protected boolean canForm(T structure) {
        return true;
    }

    public ForgeDirection getSide(Coord4D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.xCoord == xmin) {
            return ForgeDirection.WEST;
        }
        if (obj.xCoord == xmax) {
            return ForgeDirection.EAST;
        }
        if (obj.yCoord == ymin) {
            return ForgeDirection.DOWN;
        }
        if (obj.yCoord == ymax) {
            return ForgeDirection.UP;
        }
        if (obj.zCoord == zmin) {
            return ForgeDirection.NORTH;
        }
        if (obj.zCoord == zmax) {
            return ForgeDirection.SOUTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    protected boolean isAir(int x, int y, int z) {
        return this.pointer.func_145831_w().func_147437_c(x, y, z);
    }

    protected boolean isValidInnerNode(int x, int y, int z) {
        return this.isAir(x, y, z);
    }

    public boolean isViableNode(int x, int y, int z) {
        TileEntity tile = this.pointer.func_145831_w().func_147438_o(x, y, z);
        if (tile instanceof IStructuralMultiblock && ((IStructuralMultiblock)tile).canInterface(this.pointer)) {
            return true;
        }
        return MultiblockManager.areEqual(tile, this.pointer);
    }

    private boolean isCorrectCorner(Coord4D obj, int xmin, int ymin, int zmin) {
        return obj.xCoord == xmin && obj.yCoord == ymin && obj.zCoord == zmin;
    }

    private boolean isFrame(Coord4D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.xCoord == xmin && obj.yCoord == ymin) {
            return true;
        }
        if (obj.xCoord == xmax && obj.yCoord == ymin) {
            return true;
        }
        if (obj.xCoord == xmin && obj.yCoord == ymax) {
            return true;
        }
        if (obj.xCoord == xmax && obj.yCoord == ymax) {
            return true;
        }
        if (obj.xCoord == xmin && obj.zCoord == zmin) {
            return true;
        }
        if (obj.xCoord == xmax && obj.zCoord == zmin) {
            return true;
        }
        if (obj.xCoord == xmin && obj.zCoord == zmax) {
            return true;
        }
        if (obj.xCoord == xmax && obj.zCoord == zmax) {
            return true;
        }
        if (obj.yCoord == ymin && obj.zCoord == zmin) {
            return true;
        }
        if (obj.yCoord == ymax && obj.zCoord == zmin) {
            return true;
        }
        if (obj.yCoord == ymin && obj.zCoord == zmax) {
            return true;
        }
        return obj.yCoord == ymax && obj.zCoord == zmax;
    }

    protected abstract boolean isValidFrame(int var1, int var2, int var3);

    protected abstract MultiblockCache<T> getNewCache();

    protected abstract T getNewStructure();

    protected abstract MultiblockManager<T> getManager();

    protected abstract void mergeCaches(List<ItemStack> var1, MultiblockCache<T> var2, MultiblockCache<T> var3);

    protected void onFormed() {
        for (Coord4D coord : ((SynchronizedData)this.structureFound).internalLocations) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (!(tile instanceof TileEntityInternalMultiblock)) continue;
            ((TileEntityInternalMultiblock)tile).setMultiblock(((SynchronizedData)this.structureFound).inventoryID);
        }
    }

    protected void onStructureCreated(T structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
    }

    public void onStructureDestroyed(T structure) {
        for (Coord4D coord : ((SynchronizedData)structure).internalLocations) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (!(tile instanceof TileEntityInternalMultiblock)) continue;
            ((TileEntityInternalMultiblock)tile).setMultiblock(null);
        }
    }

    public void killInnerNode(Coord4D coord) {
        TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        if (tile instanceof TileEntityInternalMultiblock) {
            ((TileEntityInternalMultiblock)tile).setMultiblock(null);
        }
    }

    public void doUpdate() {
        this.loopThrough(this.pointer);
        if (this.structureFound != null) {
            for (TileEntity tileEntity : this.iteratedNodes) {
                if (((SynchronizedData)this.structureFound).locations.contains(Coord4D.get(tileEntity))) continue;
                for (TileEntity tile : this.iteratedNodes) {
                    if (tile instanceof TileEntityMultiblock) {
                        ((TileEntityMultiblock)tile).structure = null;
                        continue;
                    }
                    if (!(tile instanceof IStructuralMultiblock)) continue;
                    ((IStructuralMultiblock)tile).setController(null);
                }
                for (Coord4D coord : this.innerNodes) {
                    this.killInnerNode(coord);
                }
                return;
            }
            ArrayList<String> idsFound = new ArrayList<String>();
            String idToUse = null;
            for (Coord4D obj : ((SynchronizedData)this.structureFound).locations) {
                TileEntity tileEntity = obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (!(tileEntity instanceof TileEntityMultiblock) || ((TileEntityMultiblock)tileEntity).cachedID == null) continue;
                idsFound.add(((TileEntityMultiblock)tileEntity).cachedID);
            }
            MultiblockCache<T> cache = this.getNewCache();
            ArrayList<ItemStack> rejectedItems = new ArrayList<ItemStack>();
            if (!idsFound.isEmpty()) {
                for (String id : idsFound) {
                    if (this.getManager().inventories.get(id) == null) continue;
                    if (cache == null) {
                        cache = this.getManager().pullInventory(this.pointer.func_145831_w(), id);
                    } else {
                        this.mergeCaches(rejectedItems, cache, this.getManager().pullInventory(this.pointer.func_145831_w(), id));
                    }
                    idToUse = id;
                }
            } else {
                idToUse = this.getManager().getUniqueInventoryID();
            }
            cache.apply(this.structureFound);
            ((SynchronizedData)this.structureFound).inventoryID = idToUse;
            this.onFormed();
            ArrayList<IStructuralMultiblock> structures = new ArrayList<IStructuralMultiblock>();
            Coord4D toUse = null;
            for (Coord4D obj : ((SynchronizedData)this.structureFound).locations) {
                TileEntity tileEntity = obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tileEntity instanceof TileEntityMultiblock) {
                    ((TileEntityMultiblock)tileEntity).structure = this.structureFound;
                    if (toUse != null) continue;
                    toUse = obj.clone();
                    continue;
                }
                if (!(tileEntity instanceof IStructuralMultiblock)) continue;
                structures.add((IStructuralMultiblock)tileEntity);
            }
            for (IStructuralMultiblock node : structures) {
                node.setController(toUse);
                ((SynchronizedData)this.structureFound).locations.remove(Coord4D.get((TileEntity)node));
            }
        } else {
            for (TileEntity tile : this.iteratedNodes) {
                if (tile instanceof TileEntityMultiblock) {
                    TileEntityMultiblock tileEntity = (TileEntityMultiblock)tile;
                    if (tileEntity.structure != null && !((SynchronizedData)tileEntity.structure).destroyed) {
                        this.onStructureDestroyed(tileEntity.structure);
                        ((SynchronizedData)tileEntity.structure).destroyed = true;
                    }
                    tileEntity.structure = null;
                    continue;
                }
                if (!(tile instanceof IStructuralMultiblock)) continue;
                ((IStructuralMultiblock)tile).setController(null);
            }
            for (Coord4D coord : this.innerNodes) {
                this.killInnerNode(coord);
            }
        }
    }

    public static abstract class NodeChecker {
        public abstract boolean isValid(Coord4D var1);

        public boolean shouldContinue(int iterated) {
            return true;
        }
    }

    public class NodeCounter {
        public Set<Coord4D> iterated = new HashSet<Coord4D>();
        public NodeChecker checker;

        public NodeCounter(NodeChecker c) {
            this.checker = c;
        }

        public void loop(Coord4D pos) {
            this.iterated.add(pos);
            if (!this.checker.shouldContinue(this.iterated.size())) {
                return;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D coord = pos.getFromSide(side);
                if (this.iterated.contains(coord) || !this.checker.isValid(coord)) continue;
                this.loop(coord);
            }
        }

        public int calculate(Coord4D coord) {
            if (!this.checker.isValid(coord)) {
                return 0;
            }
            this.loop(coord);
            return this.iterated.size();
        }
    }
}

